<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Favorite_Cappers extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_FAVORITE_CAPPERS;
    private $block_folder_name = 'rdg-favorite-cappers';
    protected $block_title = 'RDG Favorite Cappers';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'favorite', 'capper'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = false;
    protected $config_page_title = '';
    protected $config_menu_title = '';
    protected $config_menu_order = 0;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_favorite_cappers.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_favorite_cappers_block_sdfwefwfwf',
                'title' => 'Block_rdg_favorite_cappers',
                'fields' => array(
                    array(
                        'key' => 'field_63d12adc52db8',
                        'label' => 'Cappers',
                        'name' => 'cappers',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63a2528813bf6',
                                    'operator' => '==',
                                    'value' => 'manual',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63d12adc5a730',
                                'label' => 'Logo',
                                'name' => 'logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_63d12adc52db8',
                            ),
                            array(
                                'key' => 'field_63d12adc5e19b',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d12adc52db8',
                            ),
                            array(
                                'key' => 'field_63d12adc61c6c',
                                'label' => 'Sub Title',
                                'name' => 'sub_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d12adc52db8',
                            ),
                            array(
                                'key' => 'field_63d12adc6576b',
                                'label' => 'Total',
                                'name' => 'total',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d12adc52db8',
                            ),
                            array(
                                'key' => 'field_63d12adc691f1',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d12adc52db8',
                            ),
                            array(
                                'key' => 'field_63d577dde90ba',
                                'label' => 'Description',
                                'name' => 'description',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_63d12adc52db8',
                            ),
                            array(
                                'key' => 'field_63d12adc707ce',
                                'label' => 'Pick Available',
                                'name' => 'pick_available',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d12adc52db8',
                            ),
                            array(
                                'key' => 'field_63d57c5fd2522',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63d12adc52db8',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-favorite-cappers',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-favorite-cappers-title','slug' => 'color-favorite-cappers-title','color' => '#111111'],
            ['name' => 'color-favorite-cappers-sub-title','slug' => 'color-favorite-cappers-sub-title','color' => '#3a96e0'],
            ['name' => 'color-favorite-cappers-total','slug' => 'color-favorite-cappers-total','color' => '#111111'],
            ['name' => 'color-favorite-cappers-picks','slug' => 'color-favorite-cappers-picks','color' => '#00bc00'],
            ['name' => 'color-favorite-cappers-picks-available','slug' => 'color-favorite-cappers-picks-available','color' => '#0160ac'],
            ['name' => 'color-favorite-cappers-picks-available-text','slug' => 'color-favorite-cappers-picks-available-text','color' => '#FFFFFF'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [];
    }
}

$rdg_favorite_cappers_class = new Rdg_Blocks_Favorite_Cappers();
$rdg_favorite_cappers_class->init();

return $rdg_favorite_cappers_class;
