<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Gambling_Center extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_GAMBLING_CENTER;
    private $block_folder_name = BLOCK_RDG_GAMBLING_CENTER;
    protected $block_title = 'RDG Gambling Center';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'gambling', 'center'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_gambling_center.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_64ecaf022a58d',
                'title' => 'RDG Gambling Center',
                'fields' => array(
                    array(
                        'key' => 'field_64ecdaa43ef9c',
                        'label' => 'Title',
                        'name' => 'gambling_center_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ecdacc3ef9d',
                        'label' => 'Heading',
                        'name' => 'gambling_center_heading',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecdaa43ef9c',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'h1' => 'H1',
                            'h2' => 'H2',
                            'h3' => 'H3',
                            'span' => 'Span',
                        ),
                        'default_value' => 'h3',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecdb203ef9e',
                        'label' => 'Ico',
                        'name' => 'gambling_center_ico',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecdaa43ef9c',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'dashicons-plus-alt' => 'Circle Plus',
                            'dashicons-yes-alt' => 'Circle Check',
                            'dashicons-dismiss' => 'Circle Close',
                            'dashicons-warning' => 'Circle Info',
                        ),
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 1,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecaf02607c6',
                        'label' => 'Custom Post Type',
                        'name' => 'cpt_custom_post_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'blog' => 'Blog',
                            'gambling-news' => 'Gambling News',
                            'both' => 'Blog and Gambling News',
                        ),
                        'default_value' => 'blog',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecaf0264190',
                        'label' => 'Show Blog',
                        'name' => 'cpt_blog_show',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf02607c6',
                                    'operator' => '==',
                                    'value' => 'blog',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'latest' => 'Latest Posts',
                            'specific' => 'Specific Posts',
                        ),
                        'default_value' => 'latest',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecaf0267e08',
                        'label' => 'Select Category Type',
                        'name' => 'cpt_blog_select_category_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf0264190',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'include' => 'Include Category',
                            'exclude' => 'Exclude Category',
                        ),
                        'default_value' => 'include',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecaf026b74d',
                        'label' => 'Category Include',
                        'name' => 'cpt_blog_category_include',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf0267e08',
                                    'operator' => '==',
                                    'value' => 'include',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'blog-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64ecaf026f385',
                        'label' => 'Category Exclude',
                        'name' => 'cpt_blog_category_exclude',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf0267e08',
                                    'operator' => '==',
                                    'value' => 'exclude',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'blog-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64ecaf0272ea9',
                        'label' => 'Blogs',
                        'name' => 'cpt_blog_specific',
                        'aria-label' => '',
                        'type' => 'relationship',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf0264190',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'post_type' => array(
                            0 => 'blog',
                        ),
                        'post_status' => array(
                            0 => 'publish',
                        ),
                        'taxonomy' => '',
                        'filters' => array(
                            0 => 'search',
                            1 => 'taxonomy',
                        ),
                        'return_format' => 'object',
                        'min' => '',
                        'max' => '',
                        'elements' => array(
                            0 => 'featured_image',
                        ),
                    ),
                    array(
                        'key' => 'field_64ecaf0276b74',
                        'label' => 'Show News',
                        'name' => 'cpt_news_show',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf02607c6',
                                    'operator' => '==',
                                    'value' => 'gambling-news',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'latest' => 'Latest Posts',
                            'specific' => 'Specific Posts',
                        ),
                        'default_value' => 'latest',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecaf027a873',
                        'label' => 'Select Category Type',
                        'name' => 'cpt_news_select_category_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf0276b74',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'include' => 'Include Category',
                            'exclude' => 'Exclude Category',
                        ),
                        'default_value' => 'include',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecaf027e391',
                        'label' => 'Category Include',
                        'name' => 'cpt_news_category_include',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf027a873',
                                    'operator' => '==',
                                    'value' => 'include',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'news-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64ecaf0282009',
                        'label' => 'Category Exclude',
                        'name' => 'cpt_news_category_exclude',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf027a873',
                                    'operator' => '==',
                                    'value' => 'exclude',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'news-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64ecaf02859f2',
                        'label' => 'News',
                        'name' => 'cpt_news_specific',
                        'aria-label' => '',
                        'type' => 'relationship',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf0276b74',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'post_type' => array(
                            0 => 'gambling-news',
                        ),
                        'post_status' => array(
                            0 => 'publish',
                        ),
                        'taxonomy' => '',
                        'filters' => array(
                            0 => 'search',
                            1 => 'taxonomy',
                        ),
                        'return_format' => 'object',
                        'min' => '',
                        'max' => '',
                        'elements' => array(
                            0 => 'featured_image',
                        ),
                    ),
                    array(
                        'key' => 'field_64ecb070b80d3',
                        'label' => 'Show Blog and Gambling News',
                        'name' => 'cpt_both_show',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf02607c6',
                                    'operator' => '==',
                                    'value' => 'both',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'latest' => 'Latest Posts',
                            'specific' => 'Specific Posts',
                        ),
                        'default_value' => 'latest',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecb0e5e85f3',
                        'label' => 'Select Category Type',
                        'name' => 'cpt_both_select_category_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecb070b80d3',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'include' => 'Include Category',
                            'exclude' => 'Exclude Category',
                        ),
                        'default_value' => 'include',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64ecb131e85f4',
                        'label' => 'Category Blog Include',
                        'name' => 'cpt_both_blog_category_include',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecb0e5e85f3',
                                    'operator' => '==',
                                    'value' => 'include',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'blog-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64ecb1ece85f5',
                        'label' => 'Category Blog Exclude',
                        'name' => 'cpt_both_blog_category_exclude',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecb0e5e85f3',
                                    'operator' => '==',
                                    'value' => 'exclude',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'blog-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64ecb2a170cf6',
                        'label' => 'Category News Include',
                        'name' => 'cpt_both_news_category_include',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecb0e5e85f3',
                                    'operator' => '==',
                                    'value' => 'include',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'news-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64ecb2a870cf7',
                        'label' => 'Category News Exclude',
                        'name' => 'cpt_both_news_category_exclude',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecb0e5e85f3',
                                    'operator' => '==',
                                    'value' => 'exclude',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'news-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64ecb32c6b5ad',
                        'label' => 'Blog and Gambling News',
                        'name' => 'cpt_both_specific',
                        'aria-label' => '',
                        'type' => 'relationship',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecb070b80d3',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'post_type' => array(
                            0 => 'blog',
                            1 => 'gambling-news',
                        ),
                        'post_status' => array(
                            0 => 'publish',
                        ),
                        'taxonomy' => '',
                        'filters' => array(
                            0 => 'search',
                            1 => 'post_type',
                            2 => 'taxonomy',
                        ),
                        'return_format' => 'object',
                        'min' => '',
                        'max' => '',
                        'elements' => array(
                            0 => 'featured_image',
                        ),
                    ),
                    array(
                        'key' => 'field_64ecaf0289397',
                        'label' => 'Quantity',
                        'name' => 'cpt_quantity',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64ecaf0264190',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                            array(
                                array(
                                    'field' => 'field_64ecaf0276b74',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                            array(
                                array(
                                    'field' => 'field_64ecb070b80d3',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 5,
                        'min' => 1,
                        'max' => 100,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-gambling-center',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_fields_cpt($fields) {
        $quantity = (isset($fields['cpt_quantity']) && !empty($fields['cpt_quantity']))
            ? $fields['cpt_quantity']
            : 1;

        $cpt_array['quantity'] = $quantity;

        $cpt = (isset($fields['cpt_custom_post_type']) && !empty($fields['cpt_custom_post_type']))
            ? $fields['cpt_custom_post_type']
            : null;
        
        if ($cpt == null) return null;
        $slug = $cpt;
        $cpt_array['cpt'] = $cpt;
        $cpt_array['taxonomy'] = 'blog-category';
        
        if ($cpt == 'gambling-news') {
            $slug = 'news';
            $cpt_array['taxonomy'] = 'news-category';
        } elseif ($cpt == 'both') {
            $cpt_array['cpt'] = ['blog', 'gambling-news'];
            $cpt_array['taxonomy'] = ['blog' => 'blog-category','gambling-news' => 'news-category'];
        }

        $cpt_array['show'] = isset($fields[sprintf('cpt_%1$s_show', $slug)]) ? $fields[sprintf('cpt_%1$s_show', $slug)] : 'blog';
        $cpt_array['select_category_type'] = isset($fields[sprintf('cpt_%1$s_select_category_type', $slug)]) ? $fields[sprintf('cpt_%1$s_select_category_type', $slug)] : 'include';
        $cpt_array['category_include'] = isset($fields[sprintf('cpt_%1$s_category_include', $slug)]) ? $fields[sprintf('cpt_%1$s_category_include', $slug)] : false;
        $cpt_array['category_exclude'] = isset($fields[sprintf('cpt_%1$s_category_exclude', $slug)]) ? $fields[sprintf('cpt_%1$s_category_exclude', $slug)] : false;
        $cpt_array['elements'] = isset($fields[sprintf('cpt_%1$s_specific', $slug)]) ? $fields[sprintf('cpt_%1$s_specific', $slug)] : false;

        if ($cpt == 'both' && $cpt_array['show'] == 'latest') {
            if ($cpt_array['select_category_type'] == 'include') {
                $cpt_array['both_category'] = [
                    'blog' => $fields['cpt_both_blog_category_include'],
                    'gambling-news' => $fields['cpt_both_news_category_include']
                ];
            } elseif ($cpt_array['select_category_type'] == 'exclude') {
                $cpt_array['both_category'] = [
                    'blog' => $fields['cpt_both_blog_category_exclude'],
                    'gambling-news' => $fields['cpt_both_news_category_exclude']
                ];
            }
        }

        return $cpt_array;
    }

    public function get_elements_type($fields) {
        if (!is_array($fields) || count($fields) == 0) return;

        if (BLOCK_RDG_TYPE_SPECIFIC == $fields['show']) {
            return $fields['elements'];
        }

        $get_quantity = $fields['quantity'];
        $quantity = $get_quantity ? $get_quantity : 1;

        $category = '';
        $operator = 'IN';
        $select_category_type = $fields['select_category_type'];

        if (!empty($select_category_type)) {
            if ('include' == $select_category_type && is_array($fields['category_include']) && count($fields['category_include']) > 0) {
                $category = $fields['category_include'];
            } elseif ('exclude' == $select_category_type && is_array($fields['category_exclude']) && count($fields['category_exclude']) > 0) {
                $operator = 'NOT IN';
                $category = $fields['category_exclude'];
            }
        }

        $args = [
            'post_type' => $fields['cpt'],
            'post_status' => 'publish',
            'posts_per_page' => $quantity,
        ];

        if (is_array($category) && count($category) > 0) {
            $args['tax_query'] = [
                [
                    'taxonomy' => $fields['taxonomy'],
                    'field' => 'id',
                    'terms' => $category,
                    'operator' => $operator
                ]
            ];
        } elseif (is_array($fields['cpt'])) {
            $args['tax_query'] = [
                'relation' => 'OR',
            ];
            
            foreach($fields['cpt'] as $cpt) {
                if (!empty($fields['both_category'][$cpt])) {

                    $args['tax_query'][] = [
                        'taxonomy' => $fields['taxonomy'][$cpt],
                        'field' => 'id',
                        'terms' => $fields['both_category'][$cpt],
                        'operator' => $operator
                    ];
                }
            }
        }

        $elements = (new WP_Query($args));
        wp_reset_postdata();

        return $elements;
    }

    public function is_valid_cpt($cpt) {
        $valid_count = 0;
        $all_post_type = get_post_types([], 'names', 'and');

        if (is_array($cpt)) {
            foreach ($cpt as $post_type) {
                if (isset($all_post_type[$post_type])) {
                    $valid_count++;
                }
            }

            if ($valid_count == count($cpt)) return true;
        } elseif (isset($all_post_type[$cpt])) {
            return true;
        }
        
        return false;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-gambling-center-title','slug' => 'color-rdg-gambling-center-title','color' => '#111111'],
            ['name' => 'color-rdg-gambling-center-article-a','slug' => 'color-rdg-gambling-center-article-a','color' => '#3a96e0'],
            ['name' => 'color-rdg-gambling-center-article-a-hover','slug' => 'color-rdg-gambling-center-article-a-hover','color' => '#03467d'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [];
    }
}

$rdg_gambling_center_class = new Rdg_Blocks_Gambling_Center();
$rdg_gambling_center_class->init();

return $rdg_gambling_center_class;
