<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Table extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_TABLE;
    private $block_folder_name = 'rdg-table';
    protected $block_title = 'RDG Table';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'table'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_table.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_top_winners_block_hasd23ed12d',
                'title' => 'Block_rdg_top_winners',
                'fields' => array(
                    array(
                        'key' => 'field_63d2d055ebd49',
                        'label' => 'Title',
                        'name' => 'title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63d2d055ef8c1',
                        'label' => 'Heading',
                        'name' => 'heading',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d2d055ebd49',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'h1' => 'Heading H1',
                            'h2' => 'Heading H2',
                            'h3' => 'Heading H3',
                            'span' => 'Heading Span',
                        ),
                        'default_value' => 'h1',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63d2d055f3251',
                        'label' => 'Color',
                        'name' => 'title_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d2d055ebd49',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#ffffff',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63d2d0560659d',
                        'label' => 'Color Shadow',
                        'name' => 'title_color_shadow',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d2d055ebd49',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#03467d',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63d2d0560db9c',
                        'label' => 'Tops',
                        'name' => 'tops',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d2d05609fd7',
                                    'operator' => '==',
                                    'value' => 'manual',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63d2d0562c17d',
                                'label' => 'Name',
                                'name' => 'name',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d2d0560db9c',
                            ),
                            array(
                                'key' => 'field_63d2d0562fbdc',
                                'label' => 'Value',
                                'name' => 'value',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d2d0560db9c',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_63d2d05615248',
                        'label' => 'Link',
                        'name' => 'link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-table',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_title($fields) {
        $title = (!empty($fields['title'])) ? $fields['title'] : '';
        $heading = (!empty($fields['heading'])) ? $fields['heading'] : 'span';
        $title_align = (!empty($fields['title_align'])) ? $fields['title_align'] : 'left';
        $title_color = (!empty($fields['title_color'])) ? $fields['title_color'] : '3a96e0';
        $title_color_shadow = (!empty($fields['title_color_shadow'])) ? $fields['title_color_shadow'] : '#03467d';

        $styles = [];
        $style[] = (!empty($title_color)) ? 'color: '.$title_color : 'color: #ffffff';
        $style[] = (!empty($title_color_shadow)) ? 'text-shadow: 0px 1px 1px '.$title_color_shadow : 'text-shadow: none';
    
        if (count($style) > 0) {
            $styles = implode('; ', $style).';';
        }
    
        return [$heading, $title, $styles];
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-table-title-bg','slug' => 'color-rdg-table-title-bg','color' => '#0160ac'],
            ['name' => 'color-rdg-table-title-border','slug' => 'color-rdg-table-title-border','color' => '#3a96e0'],
            ['name' => 'color-rdg-table-footer-bg','slug' => 'color-rdg-table-footer-bg','color' => '#0160ac'],
            ['name' => 'color-rdg-table-body-bg','slug' => 'color-rdg-table-body-bg','color' => '#F1F1F1'],
            ['name' => 'color-rdg-table-value','slug' => 'color-rdg-table-value','color' => '#0160ac'],
            ['name' => 'color-rdg-table-footer-border','slug' => 'color-rdg-table-footer-border','color' => '#3a96e0'],
            ['name' => 'color-rdg-table-top-border','slug' => 'color-rdg-table-top-border','color' => '#ffffff'],
            ['name' => 'color-rdg-table-header-bg','slug' => 'color-rdg-table-header-bg','color' => '#0160ac'],
            ['name' => 'color-rdg-table-header-border','slug' => 'color-rdg-table-header-border','color' => '#3a96e0'],
            ['name' => 'color-rdg-table-header-body','slug' => 'color-rdg-table-header-body','color' => '#F1F1F1'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-table .header .title',
                'fontWeight' =>'600',
                'fontSize' => '1.1rem',
                'fontSizeMobile' => '1rem',
            ],
            [
                'customSelector' => '.rdg-table .footer .footer-link',
                'fontWeight' =>'600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-table .body .tops .top .separator .name',
                'fontWeight' => '700',
                'fontSize' => '1.1rem',
                'fontSizeTablet' => '1rem',
            ],
            [
                'customSelector' => '.rdg-table .body .tops .top .separator .value',
                'fontWeight' => '700',
                'fontSize' => '1.1rem',
                'fontSizeTablet' => '1rem',
            ],
        ];
    }
}

$rdg_table_class = new Rdg_Blocks_Table();
$rdg_table_class->init();

return $rdg_table_class;
