<?php
/**
 * RDG-Blocks
 *
 * @package       RDGBLOCKS
 * @author        RDGCorp
 * @version 1.2.32
 *
 * @wordpress-plugin
 * Plugin Name:   RDG-Blocks
 * Plugin URI:    https://www.rdgcorp.com
 * Description:   Custom Gutenberg Blocks
 * Version: 1.2.32
 * Author:        RDGCorp
 * Author URI:    https://www.rdgcorp.com
 * Text Domain:   rdg-blocks
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 *
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 *
 * The comment above contains all information about the plugin
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 *
 * The function RDGBLOCKS() is the main function that you will be able to
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 *
 * HELPER COMMENT END
 */

// Plugin name
define('RDGBLOCKS_NAME', 'RDG-Blocks');
define('RDGBLOCKS_NAME_SLUG', 'rdg-blocks');

// Plugin version
define('RDGBLOCKS_VERSION', '1.2.32');

if (defined('PLATFORM') && PLATFORM) {
    define('RDGBLOCKS_BASE_PATH', sprintf('/app/uploads/%1$s/images/', RDGBLOCKS_NAME_SLUG));
} else {
    define('RDGBLOCKS_BASE_PATH', sprintf('/wp-content/uploads/%1$s/images/', RDGBLOCKS_NAME_SLUG));
}

// Plugin Root File
define('RDGBLOCKS_PLUGIN_FILE', __FILE__);

// Plugin base
define('RDGBLOCKS_PLUGIN_BASE', plugin_basename(RDGBLOCKS_PLUGIN_FILE));

// Plugin Folder Path
define('RDGBLOCKS_PLUGIN_DIR', plugin_dir_path(RDGBLOCKS_PLUGIN_FILE));

// Plugin Folder URL
define('RDGBLOCKS_PLUGIN_URL', plugin_dir_url(RDGBLOCKS_PLUGIN_FILE));

// Plugin Blocks Folder URL
define('RDGBLOCKS_PLUGIN_BLOCKS_DIR', plugin_dir_path(RDGBLOCKS_PLUGIN_FILE).'blocks/');

// Plugin Vendor Folder
define('RDGBLOCKS_PLUGIN_VENDOR_DIR', plugin_dir_path(RDGBLOCKS_PLUGIN_FILE).'vendor/');

// Images Maintenance Path
define('IMAGES_MAINTENANCE_FOLDER', wp_upload_dir()['basedir'].'/'.RDGBLOCKS_NAME_SLUG.'/images/');

// Cache Maintenance Path
define('CACHE_MAINTENANCE_FOLDER', wp_upload_dir()['basedir'].'/'.RDGBLOCKS_NAME_SLUG.'/');

// Block List Const
define('BLOCK_RDG_CALL_TO_ACTION', 'rdg-call-to-action');
define('BLOCK_RDG_IMAGE_COLUMN', 'rdg-image-column');
define('BLOCK_RDG_MAIN_BANNER', 'rdg-main-banner');
define('BLOCK_RDG_SPORTS_PICKS', 'rdg-sports-picks');
define('BLOCK_RDG_TITLE', 'rdg-title');
define('BLOCK_RDG_TOP_WINNERS', 'rdg-top-winners');
define('BLOCK_RDG_ADMIN_CAPPERS', 'rdg-admin-cappers');
define('BLOCK_RDG_NEXT_GAME', 'rdg-next-game');
define('BLOCK_RDG_SLIDER_LATEST_POST', 'rdg-slider-latest-post');
define('BLOCK_RDG_LATEST_POST', 'rdg-latest-post');
define('BLOCK_RDG_PICKS_LIST', 'rdg-picks-list');
define('BLOCK_RDG_FAQ', 'rdg-faq');
define('BLOCK_RDG_BUTTONS', 'rdg-buttons');
define('BLOCK_RDG_LOGO_TEAM', 'rdg-logo-team');
define('BLOCK_RDG_ODD_BETTING_SELECT', 'rdg-odd-betting-select');
define('BLOCK_RDG_ODD_BETTING_DATE', 'rdg-odd-betting-date');
define('BLOCK_RDG_SPORTS_PICKS_VS', 'rdg-sports-picks-vs');
define('BLOCK_RDG_PARAGRAPH_CUSTOM', 'rdg-paragraph-custom');
define('BLOCK_RDG_POSTS_LIST', 'rdg-posts-list');
define('BLOCK_RDG_NEW_PARAGRAPH_CUSTOM', 'rdg-new-paragraph-custom');
define('BLOCK_RDG_PICKS_VS', 'rdg-picks-vs');
define('BLOCK_RDG_PICKS_VS_CATEGORIES', 'rdg-picks-vs-categories');
define('BLOCK_RDG_MAIN_PROMOTIONS', 'rdg-main-promotions');
define('BLOCK_RDG_TOP_CAPPERS', 'rdg-top-cappers');
define('BLOCK_RDG_FAVORITE_CAPPERS', 'rdg-favorite-cappers');
define('BLOCK_RDG_LEADER_BOARD', 'rdg-leader-board');
define('BLOCK_RDG_LOGO_RANKING', 'rdg-logo-ranking');
define('BLOCK_RDG_TABLE', 'rdg-table');
define('BLOCK_RDG_ADMIN_CAPPERS_SIMPLE', 'rdg-admin-cappers-simple');
define('BLOCK_RDG_TABLE_LEAGUES', 'rdg-table-leagues');
define('BLOCK_RDG_COLUMNS_PICKS', 'rdg-columns-picks');
define('BLOCK_RDG_SEPARATOR', 'rdg-separator');
define('BLOCK_RDG_SINGLE_PICK', 'rdg-single-pick');
define('BLOCK_RDG_PARAGRAPH_COLOR', 'rdg-paragraph-color');
define('BLOCK_RDG_LOGIN', 'rdg-login');
define('BLOCK_RDG_REGISTER', 'rdg-register');
define('BLOCK_RDG_BOX_LIST', 'rdg-box-list');
define('BLOCK_RDG_SOCIALS_ICONS', 'rdg-socials-icons');
define('BLOCK_RDG_CONSENSUS', 'rdg-consensus');
define('BLOCK_RDG_POSTS_AJAX', 'rdg-posts-ajax');
define('BLOCK_RDG_EXPERTS_BANNER', 'rdg-experts-banner');
define('BLOCK_RDG_PREVIEWS_AND_PREDICTIONS', 'rdg-previews-and-predictions');
define('BLOCK_RDG_SECONDARY_BANNER', 'rdg-secondary-banner');
define('BLOCK_RDG_BUTTONS_COLUMN', 'rdg-buttons-column');
define('BLOCK_RDG_RANKING_BOOKIE', 'rdg-ranking-bookie');
define('BLOCK_RDG_BOOKIE_LOGO', 'rdg-bookie-logo');
define('BLOCK_RDG_PRODUCT_REPORT', 'rdg-product-report');
define('BLOCK_RDG_BEST_PPH', 'rdg-best-pph');
define('BLOCK_RDG_SINGLE_TOP_HANDICAPPERS', 'rdg-single-top-handicappers');
define('BLOCK_RDG_SIMPLE_POST_LIST', 'rdg-simple-post-list');
define('BLOCK_RDG_HEADING', 'rdg-heading');
define('BLOCK_RDG_PROS_CONS', 'rdg-pros-cons');
define('BLOCK_RDG_HEADING_PARAGRAPH', 'rdg-heading-paragraph');
define('BLOCK_RDG_MEMBERSHIPS', 'rdg-memberships');
define('BLOCK_RDG_BOOKIE_SUMMARY', 'rdg-bookie-summary');
define('BLOCK_RDG_QUICK_LINKS', 'rdg-quick-links');
define('BLOCK_RDG_BOOKIE_SUMMARY_SIDEBAR', 'rdg-bookie-summary-sidebar');
define('BLOCK_RDG_QUICK_LINKS_SIDEBAR', 'rdg-quick-links-sidebar');
define('BLOCK_RDG_CPT_LIST', 'rdg-cpt-list');
define('BLOCK_RDG_BEST_PPH_SITES', 'rdg-best-pph-sites');
define('BLOCK_RDG_GAMBLING_CENTER', 'rdg-gambling-center');
define('BLOCK_RDG_BOOKIE_SELECTOR', 'rdg-bookie-selector');
define('BLOCK_RDG_BANNER_SIDEBAR', 'rdg-banner-sidebar');
define('BLOCK_RDG_SPORT_INFORMATION', 'rdg-sport-information');
define('BLOCK_RDG_MEMBERSHIP_INFO', 'rdg-membership-info');
define('BLOCK_RDG_PROMOTE_SITE', 'rdg-promote-site');

define('BLOCK_RDG_TYPE_LATEST', 'latest');
define('BLOCK_RDG_TYPE_SPECIFIC', 'specific');
define('BLOCK_RDG_TYPE_EXTERNAL', 'external');

// Source Data Const
define('SOURCE_DATA_MANUAL', 'manual');
define('SOURCE_DATA_API', 'api');

// API DATE TYPE
define('API_DATE_TYPE_YESTERDAY', 'yesterday');
define('API_DATE_TYPE_NOW', 'now');
define('API_DATE_TYPE_TOMORROW', 'tomorrow');
define('API_DATE_TYPE_RANGE', 'range');

// REDIS
define('REDIS_GROUP_BLOCKS', 'blocks');
define('REDIS_TIMEOUT', 3600);

# RDG PLUGIN REVIEWS LIST
define('RDG_BLOCKS_REVIEWS', 'pph-review,sportsbook-review');

/**
 * Load the main class for the core functionality
 */
require_once RDGBLOCKS_PLUGIN_DIR.'core/class-rdg-blocks.php';

/**
 * Load the mase class for the blocks functionality
 */
require_once RDGBLOCKS_PLUGIN_BLOCKS_DIR."rdg-blocks-base.php";
require_once RDGBLOCKS_PLUGIN_BLOCKS_DIR."rdg-blocks-api-request.php";

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  RDGCorp
 * @since   1.0.0
 * @return  object|Rdg_Blocks
 */
function RDGBLOCKS() {
    $rdgb = Rdg_Blocks::instance();
    $rdg_base_style = $rdgb->helpers->webpack('rdg_base_style.css');

    add_action('init', function () use ($rdg_base_style) {
        wp_enqueue_style('rdg_base_style', $rdg_base_style, [], true);
        $jquery_load = (isset(get_field('rdg_resource_jquery_group', 'option')['jquery_versions'])) ? get_field('rdg_resource_jquery_group', 'option')['jquery_versions'] : 'none';

        if ($jquery_load != 'none') {
            $path = 'core/includes/assets/js/jquery/';
            $jquery_dir = RDGBLOCKS_PLUGIN_DIR.$path;
            $jquery_uri = RDGBLOCKS_PLUGIN_URL.$path;

            if (file_exists($jquery_dir.$jquery_load)) {
                wp_enqueue_script('rdgblocks-'.$jquery_load, $jquery_uri.$jquery_load, [], RDGBLOCKS_VERSION, false);
            } else {
                error_log(print_r([
                    'message' => 'The requested jquery file does not exist.',
                    'jquery_load' => $jquery_load,
                    'jquery_dir' => $jquery_dir,
                    'jquery_uri' => $jquery_uri,
                ], true));
            }
        }

        // wp_enqueue_script('rdgblocks-bootstrap-custom', RDGBLOCKS_PLUGIN_URL.'core/includes/assets/js/bootstrap_custom.js', [], RDGBLOCKS_VERSION, false);
        // wp_enqueue_script('rdgblocks-backend-scripts', RDGBLOCKS_PLUGIN_URL.'core/includes/assets/js/backend-scripts.js', [], RDGBLOCKS_VERSION, false);

        if (is_admin()) {
            wp_enqueue_script( 'rdgblocks-backend-scripts', RDGBLOCKS_PLUGIN_URL . 'core/includes/assets/js/backend-scripts.js', [], RDGBLOCKS_VERSION, false );
        }
    });

    add_action('init', function() {
        remove_filter('acf_the_content', 'wpautop');
    });

    add_action('edit_post', function($post_id) use ($rdgb) {
        $post_content = get_post($post_id)->post_content;
        $blocks = $rdgb->settings->get_blocks();
        $blocks_caching = $rdgb->helpers->get_blocks_caching($blocks, $_POST, $post_content);

        if (count($blocks_caching) > 0) {
            foreach ($blocks_caching as $block) {
                $block_name = $block['name'];
                $items = $block['items'];
                $block_custom_id = $block['custom_id'];
                $rdgb->helpers->clear_cache($block_name, $post_id);

                try {
                    $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id, $block_custom_id, true);
                    $set_cache_file = $rdgb->helpers->set_cache_file($block_name, $cache_file);
                    $current_block = $rdgb->settings->get_block($block_name);
                    $api_attributes = $current_block->get_api_attributes($items, $block['api_params']);

                    $response = $rdgb->helpers->get_api_request(
                        $api_attributes['request'],
                        $api_attributes['method'],
                        $api_attributes['headers']
                    );

                    if ($response['http_code'] != 200) {
                        $rdgb->helpers->get_api_error($response['http_code'], [
                            'block_name' => $block_name,
                            'http_code' => $response['http_code'],
                            'set_cache_file' => $set_cache_file,
                            'api_attributes' => $api_attributes
                        ]);

                        continue;
                    }

                    $response_json = $rdgb->helpers->is_json($response['data']);

                    if ($response_json == null) {
                        $rdgb->helpers->get_api_error('json_response', [
                            'block_name' => $block_name,
                            'code' => 'json_response',
                            'set_cache_file' => $set_cache_file,
                            'api_attributes' => $api_attributes
                        ]);

                        continue;
                    }

                    $cache = fopen($set_cache_file->cache_file, "w");
                    fwrite($cache, serialize($response_json));
                    fclose($cache);

                    $rdgb->helpers->get_api_error(200, ['block_name' => $block_name]);
                } catch (Exception $exception) {
                    $rdgb->helpers->get_api_error('', [
                        'block_name' => $block_name,
                        'set_cache_file' => $set_cache_file,
                        'api_attributes' => $api_attributes,
                        'exception' => [
                            'file' => $exception->getFile(),
                            'line' => $exception->getLine(),
                            'message' => $exception->getMessage(),
                        ],
                    ]);
                }
            }
        }
    });

    add_filter('acf/pre_save_block', function($attributes) use ($rdgb) {
        global $post;

        if (!isset($attributes['data']['custom_id'])) {
            $attributes['data']['custom_id'] = 'block-'.uniqid();
        }

        if (!empty($post->ID)) {
            $attributes['data']['post_id'] = $post->ID;
        }

        return $attributes;
    });

    return $rdgb;
}

$rdgb = RDGBLOCKS();

include 'blocks/rdg-team-schedules/rdg-team-schedules.php';


add_action('init', 'add_custom_post_type_news', 0);

/**
 * Creation of the custom post type news
 */
function add_custom_post_type_news() {
    $labels = [
        'name'               => __('News', 'score-and-stats'),
        'singular_name'      => __('News', 'score-and-stats'),
        'all_items'          => __('All News', 'score-and-stats'),
        'search_items'       => __('Search News', 'score-and-stats'),
        'not_found_in_trash' => __('No news found in Trash.', 'score-and-stats'),
        'not_found'          => __('No news found.', 'score-and-stats'),
    ];

    $supports = [
        'title',
        'editor',
        'author',
        'thumbnail',
        'excerpt',
        'custom-fields',
        'revisions',
        'page-attributes'
    ];
     
    $args = [
        'labels'                    => $labels,
        'supports'                  => $supports,
        'public'                    => true,
        'has_archive'               => true,
        'show_in_rest'              => true,
        'hierarchical'              => true,
        'capability_type'           => 'post',
        'rewrite'                   => ['with_front' => true],
        'cptp_permalink_structure'  => '/%gambling-news%/'
    ];

    register_post_type('gambling-news', $args);
}

add_action('init', 'add_custom_taxonomy_news_category', 0);

/**
 * Creating the news category taxonomy
 */
function add_custom_taxonomy_news_category() {
    $labels = [
        'name'              => _x('News Category', 'score-and-stats'),
        'singular_name'     => _x('News Category', 'score-and-stats'),
        'search_items'      => __('Search News Category', 'score-and-stats'),
        'all_items'         => __('All News Category', 'score-and-stats'),
        'parent_item'       => __('Parent News Category', 'score-and-stats'),
        'parent_item_colon' => __('Parent News Category:', 'score-and-stats'),
        'edit_item'         => __('Edit News Category', 'score-and-stats'),
        'update_item'       => __('Update News Category', 'score-and-stats'),
        'add_new_item'      => __('Add New News Category', 'score-and-stats'),
        'new_item_name'     => __('New News Category Name', 'score-and-stats'),
        'menu_name'         => __('News Category', 'score-and-stats')
    ];

    $args = [
        'labels'            => $labels,
        'hierarchical'      => true,
        'show_admin_column' => true,
        'show_in_rest'      => true,
        'rewrite' => [
            'slug' => 'news-category',
            'with_front' => true,
        ],
        'cptp_permalink_structure' => 'news/category/%news-category%/'
    ];

    register_taxonomy('news-category', 'gambling-news', $args);

    $term_uncategorized = get_term_by('name', 'Uncategorized', 'news-category');
    if (!is_object($term_uncategorized)) {
        wp_insert_term('Uncategorized', 'news-category');
    }
}

function create_post_type_pph_review() {
    $supports = array(
        'title', // post title
        'editor', // post content
        'author', // post author
        'thumbnail', // featured images
        'excerpt', // post excerpt
        'custom-fields', // custom fields
        'comments', // post comments
    );

    $labels = array(
        'name' => _x('PPH Reviews', 'plural'),
        'singular_name' => _x('PPH Review', 'singular'),
        'menu_name' => _x('PPH Reviews', 'admin menu'),
        'name_admin_bar' => _x('PPH Reviews', 'admin bar'),
        'add_new' => _x('Add New', 'add new'),
        'add_new_item' => __('Add New Review'),
        'new_item' => __('New PPH Review'),
        'edit_item' => __('Edit PPH Review'),
        'view_item' => __('View PPH Reviews'),
        'all_items' => __('All PPH Reviews'),
        'search_items' => __('Search PPH Reviews'),
        'not_found' => __('No PPH Review found.'),
    );

    $args = array(
        'supports' => $supports,
        'labels' => $labels,
        'query_var' => true,
        'rewrite' => array('slug' => 'pph-review'),
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 20,
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'page',
        'show_in_rest' => true,
    );

    register_post_type('pph-review', $args);
}

add_action('init', 'create_post_type_pph_review');

function create_post_type_sportsbook_review() {
    $supports = array(
        'title', // post title
        'editor', // post content
        'author', // post author
        'thumbnail', // featured images
        'excerpt', // post excerpt
        'custom-fields', // custom fields
        'comments', // post comments
    );

    $labels = array(
        'name' => _x('Sportsbook Reviews', 'plural'),
        'singular_name' => _x('Sportsbook Review', 'singular'),
        'menu_name' => _x('Sportsbook Reviews', 'admin menu'),
        'name_admin_bar' => _x('Sportsbook Reviews', 'admin bar'),
        'add_new' => _x('Add New', 'add new'),
        'add_new_item' => __('Add New Review'),
        'new_item' => __('New Sportsbook Review'),
        'edit_item' => __('Edit Sportsbook Review'),
        'view_item' => __('View Sportsbook Reviews'),
        'all_items' => __('All Sportsbook Reviews'),
        'search_items' => __('Search Sportsbook Reviews'),
        'not_found' => __('No Sportsbook Review found.'),
    );

    $args = array(
        'supports' => $supports,
        'labels' => $labels,
        'query_var' => true,
        'rewrite' => array('slug' => 'sportsbook-review'),
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 20,
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'page',
        'show_in_rest' => true,
    );

    register_post_type('sportsbook-review', $args);
}

add_action('init', 'create_post_type_sportsbook_review');

function post_types_bookie_sumary_register_fields() {
    if( function_exists('acf_add_local_field_group') ):
        acf_add_local_field_group(array(
            'key' => 'group_bookie_summary_custom_post_type_r56h4d54234gv3545s',
            'title' => 'Bookie Summary',
            'fields' => array(
                array(
                    'key' => 'field_6446a448c5995',
                    'label' => 'Separator',
                    'name' => 'separator_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6446a697afe36',
                            'label' => 'Border',
                            'name' => 'border',
                            'aria-label' => '',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '33',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 1,
                            'min' => 1,
                            'max' => 10,
                            'placeholder' => '',
                            'step' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446a6baafe37',
                            'label' => 'Margin',
                            'name' => 'margin',
                            'aria-label' => '',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '33',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 1,
                            'min' => 1,
                            'max' => 10,
                            'placeholder' => '',
                            'step' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446a6d5afe38',
                            'label' => 'Color',
                            'name' => 'color',
                            'aria-label' => '',
                            'type' => 'color_picker',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '34',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '#CCC',
                            'enable_opacity' => 0,
                            'return_format' => 'string',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6446aa349bb4a',
                    'label' => 'Logo',
                    'name' => 'logo',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6446aa349bb4b',
                            'label' => 'Display Logo',
                            'name' => 'logo_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6446aa6f34698',
                            'label' => 'Bookie Logo',
                            'name' => 'bookie_logo',
                            'aria-label' => '',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446aa349bb4b',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'preview_size' => 'medium',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6446a8d3d2760',
                    'label' => 'Review',
                    'name' => 'review_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6446a8e9d2761',
                            'label' => 'Display Review',
                            'name' => 'review_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6446aaea3be0e',
                            'label' => 'Ranking',
                            'name' => 'ranking',
                            'aria-label' => '',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446a8e9d2761',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '33',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 1,
                            'min' => '',
                            'max' => '',
                            'placeholder' => '',
                            'step' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446ab003be0f',
                            'label' => 'Site',
                            'name' => 'site',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446a8e9d2761',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '33',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446ab123be10',
                            'label' => 'Since',
                            'name' => 'since',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446a8e9d2761',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '34',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446ab1d3be11',
                            'label' => 'Description',
                            'name' => 'description',
                            'aria-label' => '',
                            'type' => 'textarea',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446a8e9d2761',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'rows' => 4,
                            'placeholder' => '',
                            'new_lines' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6446ce50b89ca',
                    'label' => 'Offers',
                    'name' => 'offers_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6446cefcfec85',
                            'label' => 'Display Offers',
                            'name' => 'offers_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6446be3250171',
                            'label' => 'Offer',
                            'name' => 'offer',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446cefcfec85',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'layout' => 'block',
                            'pagination' => 0,
                            'min' => 0,
                            'max' => 0,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_6446be3b50172',
                                    'label' => 'Type',
                                    'name' => 'type',
                                    'aria-label' => '',
                                    'type' => 'radio',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'choices' => array(
                                        'image' => 'Image',
                                        'basic' => 'Basic',
                                    ),
                                    'default_value' => 'image',
                                    'return_format' => 'value',
                                    'allow_null' => 0,
                                    'other_choice' => 0,
                                    'layout' => 'horizontal',
                                    'save_other_choice' => 0,
                                    'parent_repeater' => 'field_6446be3250171',
                                ),
                                array(
                                    'key' => 'field_6446ca683c969',
                                    'label' => 'Image Button',
                                    'name' => 'image_button',
                                    'aria-label' => '',
                                    'type' => 'group',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => array(
                                        array(
                                            array(
                                                'field' => 'field_6446be3b50172',
                                                'operator' => '==',
                                                'value' => 'image',
                                            ),
                                        ),
                                    ),
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'layout' => 'block',
                                    'sub_fields' => array(
                                        array(
                                            'key' => 'field_6446be7450173',
                                            'label' => 'Image',
                                            'name' => 'image',
                                            'aria-label' => '',
                                            'type' => 'image',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                            'library' => 'all',
                                            'min_width' => '',
                                            'min_height' => '',
                                            'min_size' => '',
                                            'max_width' => '',
                                            'max_height' => '',
                                            'max_size' => '',
                                            'mime_types' => '',
                                            'preview_size' => 'medium',
                                        ),
                                        array(
                                            'key' => 'field_6446be8f50174',
                                            'label' => 'Background Color',
                                            'name' => 'background_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#0160ac',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6446bee750176',
                                            'label' => 'Texts',
                                            'name' => 'texts',
                                            'aria-label' => '',
                                            'type' => 'repeater',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'layout' => 'block',
                                            'pagination' => 0,
                                            'min' => 0,
                                            'max' => 0,
                                            'collapsed' => '',
                                            'button_label' => 'Add Row',
                                            'rows_per_page' => 20,
                                            'sub_fields' => array(
                                                array(
                                                    'key' => 'field_6446bef150177',
                                                    'label' => 'Text',
                                                    'name' => 'text',
                                                    'aria-label' => '',
                                                    'type' => 'text',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '40',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => '',
                                                    'maxlength' => '',
                                                    'placeholder' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                                array(
                                                    'key' => 'field_6446bf1a50178',
                                                    'label' => 'Padding',
                                                    'name' => 'text_padding',
                                                    'aria-label' => '',
                                                    'type' => 'number',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => 0,
                                                    'min' => 0,
                                                    'max' => 10,
                                                    'placeholder' => '',
                                                    'step' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                                array(
                                                    'key' => 'field_6446bf3a50179',
                                                    'label' => 'Size',
                                                    'name' => 'size',
                                                    'aria-label' => '',
                                                    'type' => 'number',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => 1,
                                                    'min' => 1,
                                                    'max' => 10,
                                                    'placeholder' => '',
                                                    'step' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                                array(
                                                    'key' => 'field_6446bf4f5017a',
                                                    'label' => 'Weight',
                                                    'name' => 'weight',
                                                    'aria-label' => '',
                                                    'type' => 'select',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'choices' => array(
                                                        100 => '100',
                                                        200 => '200',
                                                        300 => '300',
                                                        400 => '400',
                                                        500 => '500',
                                                        600 => '600',
                                                        700 => '700',
                                                        800 => '800',
                                                        900 => '900',
                                                    ),
                                                    'default_value' => 400,
                                                    'return_format' => 'value',
                                                    'multiple' => 0,
                                                    'allow_null' => 0,
                                                    'ui' => 0,
                                                    'ajax' => 0,
                                                    'placeholder' => '',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                                array(
                                                    'key' => 'field_6446bf645017b',
                                                    'label' => 'Color',
                                                    'name' => 'color',
                                                    'aria-label' => '',
                                                    'type' => 'color_picker',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => '#FFFFFF',
                                                    'enable_opacity' => 0,
                                                    'return_format' => 'string',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                            ),
                                        ),
                                        array(
                                            'key' => 'field_6446bea550175',
                                            'label' => 'Padding Button',
                                            'name' => 'padding_button',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 0,
                                            'min' => 0,
                                            'max' => 10,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c37f0d228',
                                            'label' => 'Link',
                                            'name' => 'link',
                                            'aria-label' => '',
                                            'type' => 'link',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '60',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                        ),
                                        array(
                                            'key' => 'field_644ac1a9f7bda',
                                            'label' => 'Link Rel Option',
                                            'name' => 'link_rel_option',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'none' => 'None',
                                                'no_follow' => 'No Follow',
                                            ),
                                            'default_value' => 'none',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                    ),
                                    'parent_repeater' => 'field_6446be3250171',
                                ),
                                array(
                                    'key' => 'field_6446cb81e150e',
                                    'label' => 'Basic Button',
                                    'name' => 'basic_button',
                                    'aria-label' => '',
                                    'type' => 'group',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => array(
                                        array(
                                            array(
                                                'field' => 'field_6446be3b50172',
                                                'operator' => '==',
                                                'value' => 'basic',
                                            ),
                                        ),
                                    ),
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'layout' => 'block',
                                    'sub_fields' => array(
                                        array(
                                            'key' => 'field_6446cd1271d51',
                                            'label' => 'Padding Button',
                                            'name' => 'padding_button',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 0,
                                            'min' => 0,
                                            'max' => 10,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c2820d221',
                                            'label' => 'Text Size',
                                            'name' => 'text_size',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 1,
                                            'min' => 1,
                                            'max' => 20,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c2b00d222',
                                            'label' => 'Text Weight',
                                            'name' => 'text_weight',
                                            'aria-label' => '',
                                            'type' => 'select',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                100 => '100',
                                                200 => '200',
                                                300 => '300',
                                                400 => '400',
                                                500 => '500',
                                                600 => '600',
                                                700 => '700',
                                                800 => '800',
                                                900 => '900',
                                            ),
                                            'default_value' => 400,
                                            'return_format' => 'value',
                                            'multiple' => 0,
                                            'allow_null' => 0,
                                            'ui' => 0,
                                            'ajax' => 0,
                                            'placeholder' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c2dc0d223',
                                            'label' => 'Text Color',
                                            'name' => 'color_basic',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#FFFFFF',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6446c2fc0d224',
                                            'label' => 'Style',
                                            'name' => 'style',
                                            'aria-label' => '',
                                            'type' => 'select',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'info' => 'Info',
                                                'success' => 'Success',
                                                'warning' => 'Warning',
                                                'danger' => 'Danger',
                                                'custom' => 'Custom',
                                            ),
                                            'default_value' => 'info',
                                            'return_format' => 'value',
                                            'multiple' => 0,
                                            'allow_null' => 0,
                                            'ui' => 0,
                                            'ajax' => 0,
                                            'placeholder' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c32e0d225',
                                            'label' => 'Border Color',
                                            'name' => 'border_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6446c2fc0d224',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '33',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#3a96e0',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6446c3500d226',
                                            'label' => 'Background Color',
                                            'name' => 'background_color_button',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6446c2fc0d224',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '33',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#0160ac',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6446c36c0d227',
                                            'label' => 'Hover Color',
                                            'name' => 'hover_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6446c2fc0d224',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '34',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#03467d',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_644a68f85bc68',
                                            'label' => 'Display Text',
                                            'name' => 'display_text',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '30',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'show' => 'Show',
                                                'hide' => 'Hide',
                                            ),
                                            'default_value' => 'show',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                        array(
                                            'key' => 'field_6446c2630d220',
                                            'label' => 'Text',
                                            'name' => 'text_basic',
                                            'aria-label' => '',
                                            'type' => 'text',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a68f85bc68',
                                                        'operator' => '==',
                                                        'value' => 'show',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '70',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '',
                                            'maxlength' => '',
                                            'placeholder' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446cd3171d52',
                                            'label' => 'Link',
                                            'name' => 'link',
                                            'aria-label' => '',
                                            'type' => 'link',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a68f85bc68',
                                                        'operator' => '==',
                                                        'value' => 'hide',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                        ),
                                        array(
                                            'key' => 'field_644ab5ec08e5f',
                                            'label' => 'Link Rel Option',
                                            'name' => 'link_rel_option',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a68f85bc68',
                                                        'operator' => '==',
                                                        'value' => 'hide',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'none' => 'None',
                                                'no_follow' => 'No Follow',
                                            ),
                                            'default_value' => 'none',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                    ),
                                    'parent_repeater' => 'field_6446be3250171',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6447e4df700ab',
                    'label' => 'Payment Methods',
                    'name' => 'payment_methods_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6447e537700ac',
                            'label' => 'Display Payment Methods',
                            'name' => 'payment_methods_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6447e5c7700ad',
                            'label' => 'Title',
                            'name' => 'title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6447e537700ac',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6447e5da700ae',
                            'label' => 'Images',
                            'name' => 'images',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6447e537700ac',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'layout' => 'block',
                            'pagination' => 0,
                            'min' => 0,
                            'max' => 0,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_6447e5e4700af',
                                    'label' => '',
                                    'name' => 'image',
                                    'aria-label' => '',
                                    'type' => 'image',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'return_format' => 'array',
                                    'library' => 'all',
                                    'min_width' => '',
                                    'min_height' => '',
                                    'min_size' => '',
                                    'max_width' => '',
                                    'max_height' => '',
                                    'max_size' => '',
                                    'mime_types' => '',
                                    'preview_size' => 'medium',
                                    'parent_repeater' => 'field_6447e5da700ae',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6447e90bac7d8',
                    'label' => 'Buttons',
                    'name' => 'buttons_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6447e90bac7d9',
                            'label' => 'Display Buttons',
                            'name' => 'buttons_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6447e90bac7da',
                            'label' => 'Buttons',
                            'name' => 'buttons',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6447e90bac7d9',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'layout' => 'block',
                            'pagination' => 0,
                            'min' => 0,
                            'max' => 0,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_6447e90bac7db',
                                    'label' => 'Type',
                                    'name' => 'type',
                                    'aria-label' => '',
                                    'type' => 'radio',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'choices' => array(
                                        'image' => 'Image',
                                        'basic' => 'Basic',
                                    ),
                                    'default_value' => 'image',
                                    'return_format' => 'value',
                                    'allow_null' => 0,
                                    'other_choice' => 0,
                                    'save_other_choice' => 0,
                                    'layout' => 'horizontal',
                                    'parent_repeater' => 'field_6447e90bac7da',
                                ),
                                array(
                                    'key' => 'field_6447e90bac7dc',
                                    'label' => 'Image Button',
                                    'name' => 'image_button',
                                    'aria-label' => '',
                                    'type' => 'group',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => array(
                                        array(
                                            array(
                                                'field' => 'field_6447e90bac7db',
                                                'operator' => '==',
                                                'value' => 'image',
                                            ),
                                        ),
                                    ),
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'layout' => 'block',
                                    'sub_fields' => array(
                                        array(
                                            'key' => 'field_6447e90bac7dd',
                                            'label' => 'Image',
                                            'name' => 'image',
                                            'aria-label' => '',
                                            'type' => 'image',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                            'library' => 'all',
                                            'min_width' => '',
                                            'min_height' => '',
                                            'min_size' => '',
                                            'max_width' => '',
                                            'max_height' => '',
                                            'max_size' => '',
                                            'mime_types' => '',
                                            'preview_size' => 'medium',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7de',
                                            'label' => 'Background Color',
                                            'name' => 'background_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#0160ac',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7df',
                                            'label' => 'Texts',
                                            'name' => 'texts',
                                            'aria-label' => '',
                                            'type' => 'repeater',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'layout' => 'block',
                                            'pagination' => 0,
                                            'rows_per_page' => 20,
                                            'min' => 0,
                                            'max' => 0,
                                            'collapsed' => '',
                                            'button_label' => 'Add Row',
                                            'sub_fields' => array(
                                                array(
                                                    'key' => 'field_6447e90bac7e0',
                                                    'label' => 'Text',
                                                    'name' => 'text',
                                                    'aria-label' => '',
                                                    'type' => 'text',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '40',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => '',
                                                    'maxlength' => '',
                                                    'placeholder' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                                array(
                                                    'key' => 'field_6447e90bac7e1',
                                                    'label' => 'Padding',
                                                    'name' => 'text_padding',
                                                    'aria-label' => '',
                                                    'type' => 'number',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => 0,
                                                    'min' => 0,
                                                    'max' => 10,
                                                    'placeholder' => '',
                                                    'step' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                                array(
                                                    'key' => 'field_6447e90bac7e2',
                                                    'label' => 'Size',
                                                    'name' => 'size',
                                                    'aria-label' => '',
                                                    'type' => 'number',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => 1,
                                                    'min' => 1,
                                                    'max' => 10,
                                                    'placeholder' => '',
                                                    'step' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                                array(
                                                    'key' => 'field_6447e90bac7e3',
                                                    'label' => 'Weight',
                                                    'name' => 'weight',
                                                    'aria-label' => '',
                                                    'type' => 'select',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'choices' => array(
                                                        100 => '100',
                                                        200 => '200',
                                                        300 => '300',
                                                        400 => '400',
                                                        500 => '500',
                                                        600 => '600',
                                                        700 => '700',
                                                        800 => '800',
                                                        900 => '900',
                                                    ),
                                                    'default_value' => 400,
                                                    'return_format' => 'value',
                                                    'multiple' => 0,
                                                    'allow_null' => 0,
                                                    'ui' => 0,
                                                    'ajax' => 0,
                                                    'placeholder' => '',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                                array(
                                                    'key' => 'field_6447e90bac7e4',
                                                    'label' => 'Color',
                                                    'name' => 'color',
                                                    'aria-label' => '',
                                                    'type' => 'color_picker',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => '#FFFFFF',
                                                    'enable_opacity' => 0,
                                                    'return_format' => 'string',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                            ),
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7e5',
                                            'label' => 'Padding Button',
                                            'name' => 'padding_button',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 0,
                                            'min' => 0,
                                            'max' => 10,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7e6',
                                            'label' => 'Link',
                                            'name' => 'link',
                                            'aria-label' => '',
                                            'type' => 'link',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '60',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                        ),
                                        array(
                                            'key' => 'field_644abf0d20b40',
                                            'label' => 'Link Rel Option',
                                            'name' => 'link_rel_option',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'none' => 'None',
                                                'no_follow' => 'No Follow',
                                            ),
                                            'default_value' => 'none',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                    ),
                                    'parent_repeater' => 'field_6447e90bac7da',
                                ),
                                array(
                                    'key' => 'field_6447e90bac7e7',
                                    'label' => 'Basic Button',
                                    'name' => 'basic_button',
                                    'aria-label' => '',
                                    'type' => 'group',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => array(
                                        array(
                                            array(
                                                'field' => 'field_6447e90bac7db',
                                                'operator' => '==',
                                                'value' => 'basic',
                                            ),
                                        ),
                                    ),
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'layout' => 'block',
                                    'sub_fields' => array(
                                        array(
                                            'key' => 'field_6447e90bac7f0',
                                            'label' => 'Padding Button',
                                            'name' => 'padding_button',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 0,
                                            'min' => 0,
                                            'max' => 10,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7e9',
                                            'label' => 'Text Size',
                                            'name' => 'text_size',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 1,
                                            'min' => 1,
                                            'max' => 20,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ea',
                                            'label' => 'Text Weight',
                                            'name' => 'text_weight',
                                            'aria-label' => '',
                                            'type' => 'select',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                100 => '100',
                                                200 => '200',
                                                300 => '300',
                                                400 => '400',
                                                500 => '500',
                                                600 => '600',
                                                700 => '700',
                                                800 => '800',
                                                900 => '900',
                                            ),
                                            'default_value' => 400,
                                            'return_format' => 'value',
                                            'multiple' => 0,
                                            'allow_null' => 0,
                                            'ui' => 0,
                                            'ajax' => 0,
                                            'placeholder' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7eb',
                                            'label' => 'Text Color',
                                            'name' => 'color_basic',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#FFFFFF',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ec',
                                            'label' => 'Style',
                                            'name' => 'style',
                                            'aria-label' => '',
                                            'type' => 'select',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'info' => 'Info',
                                                'success' => 'Success',
                                                'warning' => 'Warning',
                                                'danger' => 'Danger',
                                                'custom' => 'Custom',
                                            ),
                                            'default_value' => 'info',
                                            'return_format' => 'value',
                                            'multiple' => 0,
                                            'allow_null' => 0,
                                            'ui' => 0,
                                            'ajax' => 0,
                                            'placeholder' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ed',
                                            'label' => 'Border Color',
                                            'name' => 'border_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6447e90bac7ec',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '33',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#3a96e0',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ee',
                                            'label' => 'Background Color',
                                            'name' => 'background_color_button',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6447e90bac7ec',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '33',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#0160ac',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ef',
                                            'label' => 'Hover Color',
                                            'name' => 'hover_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6447e90bac7ec',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '34',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#03467d',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_644a6528d6405',
                                            'label' => 'Display Text',
                                            'name' => 'display_text',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '30',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'show' => 'Show',
                                                'hide' => 'Hide',
                                            ),
                                            'default_value' => 'show',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7e8',
                                            'label' => 'Text',
                                            'name' => 'text_basic',
                                            'aria-label' => '',
                                            'type' => 'text',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a6528d6405',
                                                        'operator' => '==',
                                                        'value' => 'show',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '70',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '',
                                            'maxlength' => '',
                                            'placeholder' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7f1',
                                            'label' => 'Link',
                                            'name' => 'link',
                                            'aria-label' => '',
                                            'type' => 'link',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a6528d6405',
                                                        'operator' => '==',
                                                        'value' => 'hide',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                        ),
                                        array(
                                            'key' => 'field_644abda0d2c13',
                                            'label' => 'Link Rel Option',
                                            'name' => 'link_rel_option',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a6528d6405',
                                                        'operator' => '==',
                                                        'value' => 'hide',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'none' => 'None',
                                                'no_follow' => 'No Follow',
                                            ),
                                            'default_value' => 'none',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                    ),
                                    'parent_repeater' => 'field_6447e90bac7da',
                                ),
                            ),
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'pph-review',
                    ),
                ),
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'sportsbook-review',
                    ),
                ),
            ),
            'menu_order' => 1,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
        ));

    endif;
}

add_action('acf/init', 'post_types_bookie_sumary_register_fields');

function post_types_quick_links_register_fields() {
    if( function_exists('acf_add_local_field_group') ):
        acf_add_local_field_group(array(
            'key' => 'group_quick_link_custom_post_type_5645f345d3354d3',
            'title' => 'Quick Links',
            'fields' => array(
                array(
                    'key' => 'field_64482404d9261',
                    'label' => 'Title',
                    'name' => 'quick_links_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_64482404dce0b',
                    'label' => 'Items',
                    'name' => 'quick_links_items',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_64482404e491a',
                            'label' => 'Text',
                            'name' => 'text',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_64482404dce0b',
                        ),
                        array(
                            'key' => 'field_64482404e84bc',
                            'label' => 'Link',
                            'name' => 'link',
                            'aria-label' => '',
                            'type' => 'link',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'parent_repeater' => 'field_64482404dce0b',
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'pph-review',
                    ),
                ),
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'sportsbook-review',
                    ),
                ),
            ),
            'menu_order' => 2,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
        ));

    endif;
}

add_action('acf/init', 'post_types_quick_links_register_fields');