<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Banner_Sidebar extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_BANNER_SIDEBAR;
    private $block_folder_name = BLOCK_RDG_BANNER_SIDEBAR;
    protected $block_title = 'RDG Banner Sidebar';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'banner', 'sidebar'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_banner_sidebar.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_banner_block_hfsfdfsfsf',
                'title' => 'RDG Banner Sidebar',
                'fields' => array(
                    array(
                        'key' => 'field_6asdaweqwedwqwqdq',
                        'label' => 'Background',
                        'name' => 'background',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6dsfsefr32wrd323',
                                'label' => 'Background color',
                                'name' => 'color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#172d54',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6sdfsefwefwfwfe',
                                'label' => 'Background Image',
                                'name' => 'image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_sdfserd23r23r2r',
                        'label' => 'Padding / Spaces',
                        'name' => 'padding_spaces',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_sdfw4232df2',
                                'label' => 'Padding Top',
                                'name' => 'padding_top',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_sdfwf233fr232f3',
                                'label' => 'Padding Left',
                                'name' => 'padding_left',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_sdfsef32423ff32',
                                'label' => 'Padding Right',
                                'name' => 'padding_right',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_sfwef232f23fr2rf',
                                'label' => 'Width',
                                'name' => 'width',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 100,
                                'min' => 10,
                                'max' => 100,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_sdfew233f2f23f3',
                        'label' => 'Texts',
                        'name' => 'texts',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_e45gg345543535gf3545',
                                'label' => 'Text',
                                'name' => 'texts',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6373ae761363c',
                                        'label' => 'Title',
                                        'name' => 'title',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373ae871363d',
                                        'label' => 'Heading',
                                        'name' => 'heading',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'h1' => 'H1',
                                            'h2' => 'H2',
                                            'h3' => 'H3',
                                            'span' => 'Span',
                                        ),
                                        'default_value' => 'h1',
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373aecf1363e',
                                        'label' => 'Size',
                                        'name' => 'size',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 2,
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6sfwef2ffefe',
                                        'label' => 'Size LG',
                                        'name' => 'size_lg',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_62f2f2f2ff',
                                        'label' => 'Size MD',
                                        'name' => 'size_md',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6323f2f3f23ff',
                                        'label' => 'Size SM',
                                        'name' => 'size_sm',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6f23ffff3f3f',
                                        'label' => 'Padding',
                                        'name' => 'padding',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 0,
                                        'min' => 0,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_fwfefwf23ff23f',
                                        'label' => 'Weight',
                                        'name' => 'weight',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            100 => '100',
                                            200 => '200',
                                            300 => '300',
                                            400 => '400',
                                            500 => '500',
                                            600 => '600',
                                            700 => '700',
                                            800 => '800',
                                            900 => '900',
                                        ),
                                        'default_value' => 500,
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_g43g3434g3g3',
                                        'label' => 'Color',
                                        'name' => 'color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#00bc00',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_634ff3f3f3f3f',
                                        'label' => 'Shadow Color',
                                        'name' => 'shadow_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#000000',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                ),
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_3f44f343f3f3fdfgdgd',
                        'label' => 'Member',
                        'name' => 'member',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6dfggfhjj67u67',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_g45g56y5566hrtg',
                                'label' => 'Background Color',
                                'name' => 'background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#00bc00',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_sdfert45u868678765g',
                                'label' => 'Title Color',
                                'name' => 'title_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#ffffff',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_ff34ftgv3443v43r43r43',
                                'label' => 'Shadow Color',
                                'name' => 'shadow_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#68f96e',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-banner-sidebar',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($type, $fields) {
        $style = [];
    
        if ('block' == $type) {
            $color = (!empty($fields['color'])) ? $fields['color'] : '#172d54';
            $style[] = 'background-color: '.$color;
    
            if (!empty($fields['image']['url'])) {
                $style[] = 'background-image: url('.$fields['image']['url'].')';
            }
    
            return implode('; ', $style);
        }
    
        if ('position' == $type) {
            if (!empty($fields['padding_top'])) {
                $style[] = 'padding-top: '.$fields['padding_top'].'rem';
            }
    
            if (!empty($fields['padding_left'])) {
                $style[] = 'padding-left: '.$fields['padding_left'].'rem';
            }
    
            if (!empty($fields['padding_right'])) {
                $style[] = 'padding-right: '.$fields['padding_right'].'rem';
            }
    
            return implode('; ', $style);
        }
    }

    public function get_texts($spaces, $titles, $member) {
        $texts = [];
        $min_size = (100 - $spaces['width']) / 2;
    
        if (empty($titles) || !isset($titles['texts']) || !is_array($titles['texts'])) {
            return;
        }

        $rdg_helpers = new Rdg_Blocks_Helpers();
        
        foreach($titles['texts'] as $title) {
            $style = $rdg_helpers->get_title_sizes($title);
            $style[] = (!empty($title['color'])) ? 'color: '.$title['color'] : 'color: #ffffff';
            $style[] = (!empty($title['weight'])) ? 'font-weight: '.$title['weight'] : 'font-weight: 400';
            $style[] = (!empty($title['padding'])) ? 'padding-bottom: '.$title['padding'].'rem' : 'padding-bottom: 0rem';
    
            if (!empty($title['shadow_color'])) {
                $style[] = 'text-shadow: 0px 1px 1px '.$title['shadow_color'];
            }
    
            $texts[] = '<'.$title['heading'].' style="'.implode('; ', $style).'">'.$title['title'].'</'.$title['heading'].'>';
            $style = [];
        }
        
        $button = $this->get_link($member);
    
        echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
        echo '<div class="position size-center" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
        echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';

        return;
    }

    private function get_link($member) {
        if (is_array($member['link'])) {
            if (!empty($member['background_color'])) {
                $styles[] = 'background-color: '.$member['background_color'].';';
            } else {
                $styles[] = 'background-color: #459519;';
            }
    
            if (!empty($member['title_color'])) {
                $styles[] = 'color: '.$member['title_color'].';';
            } else {
                $styles[] = 'color: #ffffff;';
            }
    
            if (!empty($member['shadow_color'])) {
                $styles[] = '--btn-box-shadow: '.$member['shadow_color'].';';
            } else {
                $styles[] = '--btn-box-shadow: #68f96e;';
            }
    
            $target = (!empty($member['link']['title'])) ? $member['link']['target'] : '_self';
            return '<a class="link-member" href="'.$member['link']['url'].'" target="'.$target.'" style="'.implode(' ', $styles).'">'.$member['link']['title'].'</a>';
        }
    
        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-banner-sidebar-positions','slug' => 'color-banner-sidebar-positions','color' => '#ffffff'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [];
    }
}


$rdg_banner_sidebar_class = new Rdg_Blocks_Banner_Sidebar();
$rdg_banner_sidebar_class->init();

return $rdg_banner_sidebar_class;
