<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Bookie_Selector extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_BOOKIE_SELECTOR;
    private $block_folder_name = 'rdg-bookie-selector';
    protected $block_title = 'RDG Bookie Selector';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'bookie', 'selector'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_bookie_selector.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_bookie_selector_block_swserfw3weff',
                'title' => 'RDG Bookie Selector',
                'fields' => array(
                    array(
                        'key' => 'field_656a1bfeac6ad',
                        'label' => 'Post Type',
                        'name' => 'post_type_selector',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'acfe_save_meta' => 0,
                        'choices' => array(
                            'pph-review' => 'PPH Review',
                            'sportsbook-review' => 'Sportsbook Review',
                        ),
                        'default_value' => 'pph-review',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'max' => '',
                        'prepend' => '',
                        'append' => '',
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                        'allow_custom' => 0,
                        'search_placeholder' => '',
                        'min' => '',
                    ),
                    array(
                        'key' => 'field_656a1dbc51ef8',
                        'label' => 'Bookie Selected',
                        'name' => 'bookie_selected',
                        'aria-label' => '',
                        'type' => 'post_object',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_656a1bfeac6ad',
                                    'operator' => '==',
                                    'value' => 'pph-review',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'acfe_save_meta' => 0,
                        'post_type' => array(
                            0 => 'pph-review',
                        ),
                        'post_status' => array(
                            0 => 'publish',
                        ),
                        'taxonomy' => '',
                        'return_format' => 'id',
                        'multiple' => 0,
                        'max' => '',
                        'save_custom' => 0,
                        'save_post_status' => 'publish',
                        'acfe_add_post' => 0,
                        'acfe_edit_post' => 0,
                        'acfe_bidirectional' => array(
                            'acfe_bidirectional_enabled' => '0',
                        ),
                        'allow_null' => 0,
                        'bidirectional' => 0,
                        'ui' => 1,
                        'bidirectional_target' => array(
                        ),
                        'save_post_type' => '',
                        'min' => '',
                    ),
                    array(
                        'key' => 'field_656a225551ef9',
                        'label' => 'Bookie Selected',
                        'name' => 'bookie_selected',
                        'aria-label' => '',
                        'type' => 'post_object',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_656a1bfeac6ad',
                                    'operator' => '==',
                                    'value' => 'sportsbook-review',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'acfe_save_meta' => 0,
                        'post_type' => array(
                            0 => 'sportsbook-review',
                        ),
                        'post_status' => array(
                            0 => 'publish',
                        ),
                        'taxonomy' => '',
                        'return_format' => 'id',
                        'multiple' => 0,
                        'max' => '',
                        'save_custom' => 0,
                        'save_post_status' => 'publish',
                        'acfe_add_post' => 0,
                        'acfe_edit_post' => 0,
                        'acfe_bidirectional' => array(
                            'acfe_bidirectional_enabled' => '0',
                        ),
                        'allow_null' => 0,
                        'bidirectional' => 0,
                        'ui' => 1,
                        'bidirectional_target' => array(
                        ),
                        'save_post_type' => '',
                        'min' => '',
                    ),
                    array(
                        'key' => 'field_6441758487519',
                        'label' => 'Logo',
                        'name' => 'logo_show',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show' => 'Show',
                            'hide' => 'Hide',
                        ),
                        'default_value' => 'show',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_64417946ca168',
                        'label' => 'Review',
                        'name' => 'review_show',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show' => 'Show',
                            'hide' => 'Hide',
                        ),
                        'default_value' => 'show',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_64ferfreerf',
                        'label' => 'Offers',
                        'name' => 'offers_show',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show' => 'Show',
                            'hide' => 'Hide',
                        ),
                        'default_value' => 'show',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_6441wefweffewf',
                        'label' => 'Buttons',
                        'name' => 'buttons_show',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show' => 'Show',
                            'hide' => 'Hide',
                        ),
                        'default_value' => 'show',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-bookie-selector',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_stars(float $stars) {
        $fills = intval($stars);
        $half = ($stars - $fills == 0) ? 0 : 1;
        $emptys = 5 - $fills - $half;

        for ($i = 0; $i < $fills; $i++) {
            echo '<span class="star star-fill"></span>';
        }

        if ($half > 0) {
            echo '<span class="star star-half"></span>';
        }

        for ($i = 0; $i < $emptys; $i++) {
            echo '<span class="star star-empty"></span>';
        }
    }

    public function get_style($fields, $type) {
        $style = [];

        if ($type == 'separator') {
            $style[] = (is_array($fields['separator']) && !empty($fields['separator']['border'])) 
                ? '--separator-border:'.intval($fields['separator']['border']).'px' 
                : '--separator-border:1px';
            $style[] = (is_array($fields['separator']) && !empty($fields['separator']['margin'])) 
                ? '--separator-margin:'.intval($fields['separator']['margin']).'rem' 
                : '--separator-margin:1rem';
            $style[] = (is_array($fields['separator']) && !empty($fields['separator']['color'])) 
                ? '--separator-color:'.$fields['separator']['color'] 
                : '--separator-color:#CCC';

            return implode('; ',$style).';';
        }
    }

    public function get_buttons_attributes($buttons) {
        $new_format = [];

        foreach ($buttons as $key => $button) {
            $type = ($button['type'] == 'basic') ? 'basic_button' : 'image_button';
            $tem_array = $button[$type];
            $new_format[] = array_merge($tem_array, ['type' => $button['type']]);
        }

        return $new_format;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-bookie-selector-url','slug' => 'color-bookie-selector-url','color' => '#111111'],
            ['name' => 'color-bookie-selector-since','slug' => 'color-bookie-selector-since','color' => '#7F8C8D'],
            ['name' => 'color-bookie-selector-description','slug' => 'color-bookie-selector-description','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-bookie-selector .content .site .url',
                'fontWeight' => '700',
                'fontSize' => '1.43rem',
            ],
            [
                'customSelector' => '.rdg-bookie-selector .content .site .since',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-bookie-selector .content .site .description',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-bookie-selector a',
                'textDecoration' => 'none'
            ],
        ];
    }
}

$rdg_bookie_selector_class = new Rdg_Blocks_Bookie_Selector();
$rdg_bookie_selector_class->init();

return $rdg_bookie_selector_class;
