<?php foreach($picks as $pick):?>
    <div class="pick">
        <div class="pick-header">
            <div class="title">
                <span class="header-title"><?php echo $pick->home_team; ?> vs <?php echo $pick->visitor_team; ?></span>
            </div>
        </div>
        <div class="pick-body">
            <div class="teams">
                <div class="team 'team-a'">
                    <div class="team-logo">
                        <?php if (isset($pick->home_image) && $pick->home_image != ''): ?>
                            <img src="<?php echo $pick->home_image; ?>" alt="">
                        <?php endif; ?>
                    </div>
                </div>

                <div class="team team-vs">
                    <div class="vs-logo"><span>vs</span></div>
                </div>

                <div class="team 'team-b'">
                    <div class="team-logo">
                        <?php if (isset($pick->visitor_image) && $pick->visitor_image != ''): ?>
                            <img src="<?php echo $pick->visitor_image; ?>" alt="">
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="fields">
                <div class="field separator">
                    <div class="team-home"><?php echo $pick->home_team; ?></div>
                    <div class="leyend"><?php echo _('ODDS'); ?></div>
                    <div class="team-visitor"><?php echo $pick->visitor_team; ?></div>
                </div>

                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick->openerGameOdds[0]->spread_home_odds)) ? $pick->openerGameOdds[0]->spread_home_odds : '-'; ?></div>
                    <div class="leyend"><?php echo _('OPENER'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick->openerGameOdds[0]->spread_visitor_odds)) ? $pick->openerGameOdds[0]->spread_visitor_odds : '-'; ?></div>
                </div>

                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick->currentGameOdds[0]->spread_home_odds)) ? $pick->currentGameOdds[0]->spread_home_odds : '-'; ?></div>
                    <div class="leyend"><?php echo _('CURRENT'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick->currentGameOdds[0]->spread_visitor_odds)) ? $pick->currentGameOdds[0]->spread_visitor_odds : '-'; ?></div>
                </div>
            
                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick->currentGameOdds[0]->money_line_home_odds)) ? $pick->currentGameOdds[0]->money_line_home_odds : '-'; ?></div>
                    <div class="leyend"><?php echo _('MONEYLINE'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick->currentGameOdds[0]->money_line_visitor_odds)) ? $pick->currentGameOdds[0]->money_line_visitor_odds : '-'; ?></div>
                </div>
            </div>

            <?php if (!empty($pick->gamePicksCount) && intval($pick->gamePicksCount) > 0): ?>
                <div class="picks-available">
                    <span><?php echo $pick->gamePicksCount; ?> PICKS AVAILABLE</span>
                </div>
            <?php endif ?>
        </div>

        <div class="pick-footer">
            <?php if (!empty($link)): ?>
                <a href="<?php echo $link['url']; ?>" target="<?php echo (empty($link['target'])) ? '_self' : $link['target']; ?>"><?php echo $link['title']; ?></a>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>