<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_TRENDS;
    $block_classes = [$block_name];
    $block_trends = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $trends = [];
    $sport = (!empty(get_field('rdg_trends_sports'))) ? get_field('rdg_trends_sports') : null;
    //$league = (!empty(get_field('rdg_trends_leagues'))) ? get_field('rdg_trends_leagues') : null;
    $team = (!empty(get_field('rdg_trends_teams'))) ? get_field('rdg_trends_teams') : null;
    $items = (!empty(get_field('rdg_trends_items'))) ? get_field('rdg_trends_items') : 10;

    if ($block_trends->isCaching()) {
        $api_url = get_field('trends_api_url', 'option');
        $api_token = get_field('trends_api_token', 'option');

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_trends->getApiAttributes($items, ['sport' => $sport, 'team' => $team]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
            $response = $block_trends->getResources($api_attributes, $cache_file);

            if (empty($response->message)) {
                //dump($response->json);
                $trends = $response->json[0]['data-content'][0][0]['trends'];
            } else {
                $trends = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }

    $teams = (function_exists('shMappingTeamsDirect')) ? shMappingTeamsDirect() : [];
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <h1>Hola</h1>
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
            <?php if (is_array($trends) && count($trends) > 0): ?>
                <table>
                    <tr>
                        <th>#</th>
                        <th>Team</th>
                        <th>Game</th>
                        <th>Start Date</th>
                        <th>Status</th>
                        <th>Display Status</th>
                        <th>Note</th>
                    </tr>
                    <?php
                        $i = 1;
                        $last_team_names = [];
                    ?>
                    <?php foreach ($trends as $trend): ?>
                        <tr>
                            <th><?php echo $i; ?></th>
                            <th>
                                <?php 
                                    if (isset($last_team_names[$trend['team_id']]) && !empty($last_team_names[$trend['team_id']])) {
                                        $team_name = $last_team_names[$trend['team_id']];
                                    } else {
                                        $team_name = $block_trends->getTeamName($teams, $trend['team_id']);
                                    }

                                    if (!empty($team_name) && !isset($last_team_names[$trend['team_id']])) {
                                        $last_team_names[$trend['team_id']] = $team_name;
                                    }

                                    echo $team_name;
                                ?>
                            </th>
                            <th><?php echo $trend['game_id']; ?></th>
                            <th><?php echo $trend['hit_percentage']; ?></th>
                            <th><?php echo $trend['overs']; ?></th>
                            <th><?php echo $trend['unders']; ?></th>
                            <th><?php echo $trend['pushes']; ?></th>
                        </tr>
                        <?php $i++; ?>
                    <?php endforeach; ?>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
