<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Previews_And_Predictions extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PREVIEWS_AND_PREDICTIONS;
    private $block_folder_name = 'rdg-previews-and-predictions';
    protected $block_title = 'RDG Previews and Predictions';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'previews and predictions'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
	protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_previews_and_predictions.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
		if( function_exists('acf_add_local_field_group') ):

			acf_add_local_field_group(array(
				'key' => 'group_642ec9fc03efa',
				'title' => 'Previews and Predictions',
				'fields' => array(
					array(
						'key' => 'field_642ec9ff4f582',
						'label' => 'Title',
						'name' => 'title',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
					array(
						'key' => 'field_642ecb624f583',
						'label' => 'Vs List',
						'name' => 'vs_list',
						'aria-label' => '',
						'type' => 'repeater',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'layout' => 'table',
						'pagination' => 0,
						'min' => 0,
						'max' => 0,
						'collapsed' => '',
						'button_label' => 'Add Row',
						'rows_per_page' => 20,
						'sub_fields' => array(
							array(
								'key' => 'field_642ecb8d4f584',
								'label' => 'Team A',
								'name' => 'team_a',
								'aria-label' => '',
								'type' => 'text',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'maxlength' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'parent_repeater' => 'field_642ecb624f583',
							),
							array(
								'key' => 'field_642ecba34f585',
								'label' => 'Team B',
								'name' => 'team_b',
								'aria-label' => '',
								'type' => 'text',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'maxlength' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'parent_repeater' => 'field_642ecb624f583',
							),
						),
					),
					array(
						'key' => 'field_642ecbbb4f586',
						'label' => 'Previews Btn',
						'name' => 'previews_btn',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
					array(
						'key' => 'field_642ecbdb4f588',
						'label' => 'Previews Link',
						'name' => 'previews_link',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
					array(
						'key' => 'field_642ecbcd4f587',
						'label' => 'Recaps Btn',
						'name' => 'recaps_btn',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
					array(
						'key' => 'field_642ecbe64f589',
						'label' => 'Recaps Link',
						'name' => 'recaps_link',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
				),
				'location' => array(
					array(
						array(
							'param' => 'block',
							'operator' => '==',
							'value' => 'acf/rdg-previews-and-predictions',
						),
					),
				),
				'menu_order' => 0,
				'position' => 'normal',
				'style' => 'default',
				'label_placement' => 'top',
				'instruction_placement' => 'label',
				'hide_on_screen' => '',
				'active' => true,
				'description' => '',
				'show_in_rest' => 0,
			));
			
			endif;		
    }

	public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-previews-and-predictions-column-bg','slug' => 'color-rdg-previews-and-predictions-column-bg','color' => '#FFFFFF'],
            ['name' => 'color-rdg-previews-and-predictions-header','slug' => 'color-rdg-previews-and-predictions-header','color' => '#0160ac'],
            ['name' => 'color-rdg-previews-and-predictions-list','slug' => 'color-rdg-previews-and-predictions-list','color' => '#F1F1F1'],
            ['name' => 'color-rdg-previews-and-predictions-list-team','slug' => 'color-rdg-previews-and-predictions-list-team','color' => '#111111'],
			['name' => 'color-rdg-previews-and-predictions-versus','slug' => 'color-rdg-previews-and-predictions-versus','color' => '#0160ac'],
			['name' => 'color-rdg-previews-and-predictions-footer-btn','slug' => 'color-rdg-previews-and-predictions-footer-btn','color' => '#013b6b'],
			['name' => 'color-rdg-previews-and-predictions-footer-btn-bg','slug' => 'color-rdg-previews-and-predictions-footer-btn-bg','color' => '#0160ac'],
			['name' => 'color-rdg-previews-and-predictions-btn','slug' => 'color-rdg-previews-and-predictions-btn','color' => '#FFFFFF'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-previews-and-predictions .column .header',
                'fontWeight' => '500',
                'fontSize' => '1.125rem',
            ],
            [
                'customSelector' => '.rdg-previews-and-predictions .column .main',
                'fontWeight' => 'bold',
            ],
			[
                'customSelector' => '.rdg-previews-and-predictions .column .list',
                'fontSize' => '1rem',
            ],
			[
                'customSelector' => '.rdg-previews-and-predictions .column .footer .btn',
                'fontWeight' => 'bold',
                'fontSize' => '0.875rem',
				'textDecoration' => 'none',
				'textTransform' => 'uppercase',
            ],
        ];
    }
}

$rdg_previews_and_predictions_class = new Rdg_Blocks_Previews_And_Predictions ();
$rdg_previews_and_predictions_class->init();

return $rdg_previews_and_predictions_class;
