<div class="buttons">
    <?php foreach($items as $item): ?>
        <?php $type = ($item['type'] == 'image') ? $item['image_button'] : $item['basic_button']; ?>
        <?php
            $display_text = (!empty($type['display_text'])) ? $type['display_text'] : 'show';
            $link_rel = (!empty($type['link_rel_option'])) ? $type['link_rel_option'] : 'none';
            
            if ($item['type'] != 'image' && $display_text == 'show') {
                $link_rel = 'none';
            }

            $link_rel_option = '';
            if ($link_rel == 'no_follow') {
                $link_rel_option = 'rel="nofollow noreferrer noopener"';
            }
        ?>
        <?php if (is_array($type['link']) && $type['link']['url'] != ''): ?>
            <a href="<?php echo $type['link']['url']; ?>" target="<?php echo (!empty($type['link']['target'])) ? $type['link']['target'] : '_self'; ?>" <?php echo $link_rel_option; ?>>
        <?php endif; ?>

        <?php if ($item['type'] == 'image'): ?>
            <div class="item-button image-type">
                <?php
                    $item_bg = (!empty($type['background_color'])) ? $type['background_color'] : 'none';
                    $item_padding = (!empty($type['padding_button'])) ? $type['padding_button'].'rem' : '0';
                ?>
                
                <div class="body <?php echo (!is_array($type['texts']) || count($type['texts']) == 0) ? 'center' : ''; ?>" style="--body-bg: <?php echo $item_bg; ?>; --body-padding: <?php echo $item_padding; ?>;">
                    <?php if (!empty($type['image']['url'])): ?>
                        <div class="image">
                            <img src="<?php echo $type['image']['url']; ?>" alt="Image">
                        </div>
                    <?php endif; ?>
                    <?php if (is_array($type['texts']) && count($type['texts']) > 0): ?>
                        <div class="texts" style="<?php echo (!empty($type['image']['url'])) ? '--texts-with: calc(100% - 4rem);' : '--texts-with: calc(100%);'; ?>">
                            <?php foreach($type['texts'] as $text): ?>
                                <?php if (!empty($text['text'])): ?>
                                    <?php
                                        $title = $text['text'];
                                        $size = (!empty($text['size'])) ? $text['size'].'rem;' : '2rem;';
                                        $weight = (!empty($text['weight'])) ? $text['weight'].';' : '500;';
                                        $color = (!empty($text['color'])) ? $text['color'].';' : '#FFFFFF;';
                                        $text_padding = (!empty($text['text_padding'])) ? $text['text_padding'].'rem;' : '0;';
                                    ?>
                                    <span style="--text-size:<?php echo $size; ?> --text-padding:<?php echo $text_padding; ?> --text-weight:<?php echo $weight; ?> --text-color:<?php echo $color; ?>"><?php echo $title; ?></span>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            
            <?php if (!empty($type['text_basic']) || (is_array($type['link']) && !empty($type['link']['title']))): ?>
                <?php
                    $padding = (!empty($type['padding_button'])) ? $type['padding_button'].'rem;' : '.5rem;';
                    $size = (!empty($type['text_size'])) ? $type['text_size'].'rem;' : '2rem;';
                    $weight = (!empty($type['text_weight'])) ? $type['text_weight'].';' : '500;';
                    $color = (!empty($type['color_basic'])) ? $type['color_basic'].';' : '#FFFFFF;';
                    
                    if ($display_text == 'show') {
                        $title = (!empty($type['text_basic'])) ? $type['text_basic'] : '';
                    } else {
                        $title = (is_array($type['link']) && !empty($type['link']['title'])) ? $type['link']['title'] : null;
                    }

                    $style = '';
                    if ($type['style'] == 'custom') {
                        $border_color = (!empty($type['border_color'])) ? $type['border_color'].';' : '#3a96e0;';
                        $background_color = (!empty($type['background_color_button'])) ? $type['background_color_button'].';' : '#0160ac;';
                        $hover_color = (!empty($type['hover_color'])) ? $type['hover_color'].';' : '#03467d;';
                    } else {
                        $style = $type['style'];
                        $border_color = '';
                        $background_color = '';
                        $hover_color = '';
                    }

                ?>

                <?php if ($type['style'] == 'custom'): ?>
                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?> --button-bg:<?php echo $background_color; ?> --button-hover:<?php echo $hover_color; ?>  --button-border:<?php echo $border_color; ?>">
                        <span><?php echo $title; ?></span>
                    </div>
                <?php else: ?>
                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?>">
                        <span><?php echo $title; ?></span>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>

        <?php if (is_array($type['link']) && $type['link']['url'] != ''): ?>
            </a>
        <?php endif; ?>
    <?php endforeach; ?>
</div>