<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_PREVIEW_TEMPLATE];
    $block_preview_template = $rdgb->settings->getBlock(BLOCK_RDG_PREVIEW_TEMPLATE);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $show = get_field('show');
    $titles = get_field('titles');

    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    $order = !empty(get_field('order')) ? get_field('order') : 'asc';
    $quantity = !empty(get_field('quantity')) ? get_field('quantity') : 3;
    $elements = $block_preview_template->get_elements_type(get_fields(), $paged, $order);

    $previews = $elements['posts'];
    $num_pages = intval($elements['max'] / $quantity);

    if (($elements['max'] % $quantity) != 0) {
        $num_pages++;
    }
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div class="body">
                <?php if (is_array($previews) && count($previews) > 0): ?>
                    <div class="previews">
                        <?php foreach($previews as $element): ?>
                            <?php
                                $home_team = get_post_meta($element->ID, 'shg_home_team', true);
                                $visitor_team = get_post_meta($element->ID, 'shg_visitor_team', true);
                                $home_team_logo_url = get_post_meta($element->ID, 'shg_home_image', true);
                                $visitor_team_logo_url = get_post_meta($element->ID, 'shg_visitor_image', true);

                                $home_image = $block_preview_template->get_image($home_team_logo_url, [
                                    'image_type' => 'team_image',
                                    'image_alt' => $home_team,
                                    'logo_label' => true
                                ]);

                                $visitor_image = $block_preview_template->get_image($visitor_team_logo_url, [
                                    'image_type' => 'team_image',
                                    'image_alt' => $visitor_team,
                                    'logo_label' => true
                                ]);

                                $picks = get_post_meta($element->ID, 'shg_game_picks_count', true);
                            ?>
                            <div class="preview">
                                <h3 class="preview-header"><?php echo esc_html($home_team); ?> vs <?php echo esc_html($visitor_team); ?></h3>
                                <div class="preview-body">
                                    <div class="preview-date">
                                        <?php
                                            try {
                                                $date = get_post_meta($element->ID, 'shg_game_date', true);
                                                $dateTime = new DateTime($date);

                                                echo $dateTime->format('Y-m-d H:i');
                                            } catch (\Exception $exception) {
                                                // Do nothing
                                            }
                                        ?>
                                    </div>
                                    <div class="preview-teams">
                                        <div class="preview-team">
                                            <img src="<?php echo esc_url($home_image['url']); ?>" alt="<?php echo $home_image['alt']; ?>">
                                        </div>
                                        <div class="preview-vs"><span>vs</span></div>
                                        <div class="preview-team">
                                            <img src="<?php echo esc_url($visitor_image['url']); ?>" alt="<?php echo $visitor_image['alt']; ?>">
                                        </div>
                                    </div>
                                    <div class="preview-title">
                                        PREVIEW AND PREDICTION
                                    </div>
                                    <div class="preview-description">
                                        <span>
                                            <?php 
                                            $description = $block_preview_template->getContentDescription($element->post_content);
                                            echo trim(wp_trim_words($description, 130, false));
                                        ?>
                                        </span>
                                    </div>
                                    <div class="preview-list">
                                        <ul>
                                            <li><?php echo intval($picks) > 0 ? $picks : 0; ?> CAPPERS PICKS</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="preview-footer">
                                    <a href="<?php echo get_permalink($element->ID); ?>">Read Full Preview</a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="paginate">
                        <?php $rdgb->helpers->rdgPagination($paged, $num_pages); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
