<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Single_Top_Handicappers extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_SINGLE_TOP_HANDICAPPERS;
    private $block_folder_name = 'rdg-single-top-handicappers';
    protected $block_title = 'RDG Single Top Handicappers';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'column', 'pick'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;
    protected $is_pre_saved = false;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_single_top_handicappers.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group(array(
                'key' => 'group_64386d4fc99c9',
                'title' => 'Single Top Handicappers',
                'fields' => array(
                    array(
                        'key' => 'field_64386d57014f4',
                        'label' => 'Columns',
                        'name' => 'columns',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_643877feb1ace',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64386d57014f4',
                            ),
                            array(
                                'key' => 'field_643880c9b1acf',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_643880e4b1ad0',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_643880c9b1acf',
                                    ),
                                    array(
                                        'key' => 'field_64388118b1ad1',
                                        'label' => 'Title',
                                        'name' => 'title',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_643880c9b1acf',
                                    ),
                                    array(
                                        'key' => 'field_64388132b1ad2',
                                        'label' => 'Type Pick',
                                        'name' => 'type_pick',
                                        'aria-label' => '',
                                        'type' => 'radio',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'type1' => 'Type 1',
                                            'type2' => 'Type 2',
                                        ),
                                        'default_value' => 'type1',
                                        'return_format' => 'value',
                                        'allow_null' => 0,
                                        'other_choice' => 0,
                                        'layout' => 'vertical',
                                        'save_other_choice' => 0,
                                        'parent_repeater' => 'field_643880c9b1acf',
                                    ),
                                    array(
                                        'key' => 'field_643881b1b1ad3',
                                        'label' => 'Sub Title',
                                        'name' => 'sub_title',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64388132b1ad2',
                                                    'operator' => '==',
                                                    'value' => 'type1',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_643880c9b1acf',
                                    ),
                                    array(
                                        'key' => 'field_643881eab1ad4',
                                        'label' => 'Total',
                                        'name' => 'total',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64388132b1ad2',
                                                    'operator' => '==',
                                                    'value' => 'type1',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_643880c9b1acf',
                                    ),
                                    array(
                                        'key' => 'field_64388219b1ad5',
                                        'label' => 'Picks',
                                        'name' => 'picks',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64388132b1ad2',
                                                    'operator' => '==',
                                                    'value' => 'type1',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_643880c9b1acf',
                                    ),
                                    array(
                                        'key' => 'field_64388462b1ad6',
                                        'label' => 'Score',
                                        'name' => 'score',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64388132b1ad2',
                                                    'operator' => '==',
                                                    'value' => 'type2',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_643880c9b1acf',
                                    ),
                                    array(
                                        'key' => 'field_64388481b1ad7',
                                        'label' => 'Pick Available',
                                        'name' => 'pick_available',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_643880c9b1acf',
                                    ),
                                ),
                                'parent_repeater' => 'field_64386d57014f4',
                            ),
                            array(
                                'key' => 'field_643884dab1ad8',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_64386d57014f4',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-single-top-handicappers',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            
            endif;			
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'rdg-single-top-handicappers-column-bg','slug' => 'rdg-single-top-handicappers-column-bg','color' => '#FFFFFF'],
            ['name' => 'rdg-single-top-handicappers-column-header','slug' => 'rdg-single-top-handicappers-column-header','color' => '#FFFFFF'],
            ['name' => 'rdg-single-top-handicappers-column-header-bg','slug' => 'rdg-single-top-handicappers-column-header-bg','color' => '#0160ac'],
            ['name' => 'rdg-single-top-handicappers-picks-title','slug' => 'rdg-single-top-handicappers-picks-title','color' => '#111111'],
            ['name' => 'rdg-single-top-handicappers-picks-subtitle','slug' => 'rdg-single-top-handicappers-picks-subtitle','color' => '#3a96e0'],
            ['name' => 'rdg-single-top-handicappers-picks-total','slug' => 'rdg-single-top-handicappers-picks-total','color' => '#111111'],
            ['name' => 'rdg-single-top-handicappers-picks-picks','slug' => 'rdg-single-top-handicappers-picks-picks','color' => '#00bc00'],
            ['name' => 'rdg-single-top-handicappers-available-border','slug' => 'rdg-single-top-handicappers-available-border','color' => '#F1F1F1'],
            ['name' => 'rdg-single-top-handicappers-available-span-text','slug' => 'rdg-single-top-handicappers-available-span-text','color' => '#FFFFFF'],
            ['name' => 'rdg-single-top-handicappers-available-span-bg','slug' => 'rdg-single-top-handicappers-available-span-bg','color' => '#0160ac'],
            ['name' => 'rdg-single-top-handicappers-footer','slug' => 'rdg-single-top-handicappers-footer','color' => '#FFFFFF'],
            ['name' => 'rdg-single-top-handicappers-footer-bg','slug' => 'rdg-single-top-handicappers-footer-bg','color' => '#0160ac'],
            ['name' => 'rdg-single-top-handicappers-footer-a','slug' => 'rdg-single-top-handicappers-footer-a','color' => '#FFFFFF'],
            ['name' => 'rdg-single-top-handicappers-footer-hover','slug' => 'rdg-single-top-handicappers-footer-hover','color' => '#3a96e0'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .column-header',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .picks .pick .content .center-header .pick-header .header-content .title',
                'fontWeight' => 'bold',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .picks .pick .content .center-header .pick-header .header-content .sub-title',
                'fontWeight' => 'bold',
                'fontSize' => '1rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .picks .pick .content .center-header .pick-header .header-content .total',
                'fontWeight' => 'bold',
                'fontSize' => '0.875rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .picks .pick .content .center-header .pick-header .header-content .score',
                'fontWeight' => 'bold',
                'fontSize' => '0.875rem',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .picks .pick .content .center-header .pick-header .header-content .total .picks',
                'fontWeight' => 'bold',
                'fontSize' => '0.875rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .picks .pick .content .picks-available',
                'fontSize' => '0.875rem',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .picks .pick .content .picks-available span',
                'fontWeight' => 'bold',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .pick-footer',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-single-top-handicappers .columns .column .pick-footer a',
                'textDecoration' => 'none',
            ],
        ];
    }
}

$rdg_single_top_handicappers = new Rdg_Single_Top_Handicappers();
$rdg_single_top_handicappers->init();

return $rdg_single_top_handicappers;
