<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Columns_Picks extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_COLUMNS_PICKS;
    private $block_folder_name = 'rdg-columns-picks';
    protected $block_title = 'RDG Columns Picks';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'column', 'pick'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;
    protected $is_pre_saved = false;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_columns_picks.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_columns_picks_block_se45dx234',
                'title' => 'Block_rdg_columns_picks',
                'fields' => array(
                    array(
                        'key' => 'field_63d7e2ed48993',
                        'label' => 'Columns',
                        'name' => 'columns',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63d7e32548994',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d7e2ed48993',
                            ),
                            array(
                                'key' => 'field_63d7e19a4aa34',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63d7e19a4e8a1',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_63d7e19a4aa34',
                                    ),
                                    array(
                                        'key' => 'field_63d7e19a522f0',
                                        'label' => 'Title',
                                        'name' => 'title',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d7e19a4aa34',
                                    ),
                                    array(
                                        'key' => 'field_63d8002d28385',
                                        'label' => 'Type Pick',
                                        'name' => 'type_pick',
                                        'aria-label' => '',
                                        'type' => 'radio',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'type1' => 'Type 1',
                                            'type2' => 'Type 2',
                                        ),
                                        'default_value' => 'type1',
                                        'return_format' => 'value',
                                        'allow_null' => 0,
                                        'other_choice' => 0,
                                        'layout' => 'vertical',
                                        'save_other_choice' => 0,
                                        'parent_repeater' => 'field_63d7e19a4aa34',
                                    ),
                                    array(
                                        'key' => 'field_63d7e19a55dbc',
                                        'label' => 'Sub Title',
                                        'name' => 'sub_title',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_63d8002d28385',
                                                    'operator' => '==',
                                                    'value' => 'type1',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d7e19a4aa34',
                                    ),
                                    array(
                                        'key' => 'field_63d7e19a59719',
                                        'label' => 'Total',
                                        'name' => 'total',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_63d8002d28385',
                                                    'operator' => '==',
                                                    'value' => 'type1',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d7e19a4aa34',
                                    ),
                                    array(
                                        'key' => 'field_63d7e19a5d181',
                                        'label' => 'Picks',
                                        'name' => 'picks',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_63d8002d28385',
                                                    'operator' => '==',
                                                    'value' => 'type1',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d7e19a4aa34',
                                    ),
                                    array(
                                        'key' => 'field_63d800cb28387',
                                        'label' => 'Score',
                                        'name' => 'score',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_63d8002d28385',
                                                    'operator' => '==',
                                                    'value' => 'type2',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d7e19a4aa34',
                                    ),
                                    array(
                                        'key' => 'field_63d7e19a64afe',
                                        'label' => 'Pick Available',
                                        'name' => 'pick_available',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d7e19a4aa34',
                                    ),
                                ),
                                'parent_repeater' => 'field_63d7e2ed48993',
                            ),
                            array(
                                'key' => 'field_63d7e19a686b1',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63d7e2ed48993',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-columns-picks',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-columns-picks-title','slug' => 'color-columns-picks-title','color' => '#111111'],
            ['name' => 'color-columns-picks-sub-title','slug' => 'color-columns-picks-sub-title','color' => '#3a96e0'],
            ['name' => 'color-columns-picks-total','slug' => 'color-columns-picks-total','color' => '#111111'],
            ['name' => 'color-columns-picks-picks','slug' => 'color-columns-picks-picks','color' => '#00bc00'],
            ['name' => 'color-columns-picks-picks-available-text','slug' => 'color-columns-picks-picks-available-text','color' => '#FFFFFF'],
            ['name' => 'color-columns-picks-picks-available','slug' => 'color-columns-picks-picks-available','color' => '#0160ac'],
            ['name' => 'color-columns-picks-white','slug' => 'color-columns-picks-white','color' => '#FFFFFF'],
            ['name' => 'color-columns-picks-primary-dark-light','slug' => 'color-columns-picks-primary-dark-light','color' => '#0160ac'],
            ['name' => 'color-columns-picks-primary','slug' => 'color-columns-picks-primary','color' => '#3a96e0'],
            ['name' => 'color-columns-picks-gray','slug' => 'color-columns-picks-gray','color' => '#F1F1F1'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-blocks .rdg-columns-picks .container.content .columns .column .column-header, .rdg-blocks .rdg-columns-picks .container.content .columns .column .pick-footer',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-columns-picks .columns .column .picks .pick .content .pick-header .header-content.type2 .title',
                'fontWeight' => '800',
                'fontSize' => '1.18rem',
                'lineHeight' => '1.2rem',
            ],
            [
                'customSelector' => '.rdg-columns-picks .columns .column .picks .pick .content .pick-header .header-content.type2 .score',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-columns-picks .columns .column .picks .pick .content .picks-available',
                'fontWeight' => '700',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-columns-picks .columns .column .picks .pick .content .pick-header .header-content.type1 .title',
                'fontWeight' => '700',
                'fontSize' => '1.12rem',
                'lineHeight' => '1.1rem',
            ],
            [
                'customSelector' => '.rdg-columns-picks .columns .column .picks .pick .content .pick-header .header-content.type1 .sub-title',
                'fontWeight' => '700',
                'fontSize' => '0.81rem',
                'lineHeight' => '1.3rem',
            ],
            [
                'customSelector' => '.rdg-columns-picks .columns .column .picks .pick .content .pick-header .header-content.type1 .total',
                'fontWeight' => '700',
                'fontSize' => '0.75rem',
                'lineHeight' => '1.2rem',
            ],
            [
                'customSelector' => '.rdg-columns-picks .container.content .columns .column .pick-footer a',
                'textDecoration' => 'none',
            ],
        ];
    }
}

$rdg_columns_picks_class = new Rdg_Blocks_Columns_Picks();
$rdg_columns_picks_class->init();

return $rdg_columns_picks_class;
