<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Heading_Paragraph extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_HEADING_PARAGRAPH;
    private $block_folder_name = 'rdg-heading-paragraph';
    protected $block_title = 'RDG Heading Paragraph';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'heading', 'paragraph'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;
    protected $is_pre_saved = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_heading_paragraph.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_heading_paragraph_block_sasdwq34f322343d',
                'title' => 'Block_rdg_heading_paragraph',
                'fields' => array(
                    array(
                        'key' => 'field_644039b703fee',
                        'label' => 'Content',
                        'name' => 'content',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                        'delay' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-heading-paragraph',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-heading-paragraph-border','slug' => 'color-rdg-heading-paragraph-border','color' => '#cccccc'],
            ['name' => 'color-rdg-heading-paragraph-p','slug' => 'color-rdg-heading-paragraph-p','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [];
    }
}

$rdg_heading_paragraph_class = new Rdg_Blocks_Heading_Paragraph();
$rdg_heading_paragraph_class->init();

return $rdg_heading_paragraph_class;
