<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [];
    $block_bookie_summary = $rdgb->settings->getBlock(BLOCK_RDG_QUICK_LINKS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $title = (!empty(get_field('title'))) ? get_field('title') : '';
    $items = (!empty(get_field('items'))) ? get_field('items') : null;
?>

<div class="rdg-blocks">
    <div class="<?php echo BLOCK_RDG_QUICK_LINKS; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content <?php echo esc_attr(join(' ', $block_classes)); ?>">
            <?php if (!empty($title)): ?>
                <div class="header">
                    <span class="title"><?php echo $title; ?></span>
                </div>
            <?php endif; ?>
            <div class="body">
                <?php if (is_array($items) && count($items) > 0): ?>
                    <?php foreach($items as $item): ?>
                        <li class="item">
                            <?php if (!empty($item['link'])): ?>
                                <a href="<?php echo $item['link']['url']; ?>" target="<?php echo (!empty($item['link']['target'])) ? $item['link']['target'] : '_self'; ?>">
                            <?php endif; ?>
                                <?php echo $item['text']; ?>
                            <?php if (!empty($item['link'])): ?>
                                </a>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="message danger">
                        <span><?php echo __('Must add some Items.'); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
