<?php 
    global $rdgb;
    $block_styles = [];
    $name_block = BLOCK_RDG_BOOKIE_LOGO;
    $block_classes = [$name_block];
    $block_bookie_logo = $rdgb->settings->get_block($name_block);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $logo = (!empty(get_field('logo'))) ? get_field('logo') : null;
    $list_style = (!empty(get_field('list_style'))) ? get_field('list_style') : 'check';
    $list_color = (!empty(get_field('list_color'))) ? '--list-color:'.get_field('list_color').';' : '--list-color:#000000;';
    $lists = (!empty(get_field('lists'))) ? get_field('lists') : null;
    $show = (!empty(get_field('show_in'))) ? get_field('show_in') : 'column';
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content <?php echo $show; ?>">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (is_array($logo) && isset($logo['url']) && !empty($logo['url'])): ?>
                <div class="logo">
                    <img src="<?php echo $logo['url']; ?>" alt="Image">
                </div>
            <?php endif; ?>

            <?php if (is_array($lists) && count($lists) > 0): ?>
                <ul>
                    <div class="center">
                    <?php foreach($lists as $list): ?>
                        <li class="item">
                            <span class="icon" style="<?php echo $list_color; ?>">
                                <?php echo file_get_contents(RDGBLOCKS_PLUGIN_URL.'dist/images/'.$list_style.'.svg'); ?>
                            </span>
                            <span class="value"><?php echo $list['list']; ?></span>
                        </li>
                    <?php endforeach; ?>
                    </div>
                </ul>
            <?php else: ?>
                <div class="message danger">
                    <span><?php echo __('Must add some item.'); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
