document.addEventListener('change', function(e) {
    if (e.target.id === 'rdg-leader-board-category') {
      e.preventDefault();
      document.querySelectorAll('.rdg-blocks .rdg-leader-board .list-items .message').forEach(function(el) {
        el.style.display = 'none';
      });
  
      const ajax_url = rdg_leader_board_var.ajaxurl;
      const items = document.querySelector('#rdg-leader-board-date-range option:checked').value;
      const cat_seleted = document.querySelector('#rdg-leader-board-category option:checked').value;
  
      const menus = document.querySelectorAll('.table .table-menu .menu a');
      menus.forEach(function(menu) {
        if (menu.getAttribute('data-category') === cat_seleted) {
          menu.classList.remove('unactive');
          menu.classList.add('active');
        } else {
          menu.classList.remove('active');
          menu.classList.add('unactive');
        }
      });
  
      document.getElementById('wait').style.display = 'block';

      fetch(ajax_url, {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
        },
        body: `action=load_leader_board&items=${items}&id_sub_category=${cat_seleted}`
      })

      .then(response => response.text())
      .then(resultado => {
        document.querySelector('.rdg-blocks .rdg-leader-board').querySelector('.list-items').innerHTML = resultado;
        document.querySelector('#wait').style.display = 'none';
        setTimeout(function() {
          document.querySelectorAll('.rdg-blocks .rdg-leader-board .list-items .message').forEach(function(el) {
            el.style.display = 'none';
          });
        }, 4000);
      })
      .catch(err => console.error(err));
    }
  });
  
document.addEventListener("click", function (e) {
    if (e.target.matches(".table .table-menu .menu a")) {
        e.preventDefault();

        if (e.target.classList.contains("active")) {
            return;
        }

        let menus = document.querySelectorAll(".table .table-menu .menu a");
        let menu_id = e.target.getAttribute("id");

        menus.forEach(function (val) {
            if (menu_id == val.getAttribute("id")) {
                val.classList.remove("unactive");
                val.classList.add("active");
            } else {
                val.classList.remove("active");
                val.classList.add("unactive");
            }
        });

        let message = document.querySelector(".rdg-blocks .rdg-leader-board .list-items .message");
            if (message) {
                message.style.display = 'none';
            }

        let ajax_url = rdg_leader_board_var.ajaxurl;
        let items = document.querySelector("#rdg-leader-board-date-range option:checked").value;
        let link_selected = e.target.getAttribute("data-category");
        let categories = document.querySelectorAll("#rdg-leader-board-category option");

        document.querySelectorAll("#rdg-leader-board-category option").forEach((option) => (option.selected = false));

        categories.forEach((option) => {
            if (option.value === link_selected) {
                document.querySelector(
                    `#rdg-leader-board-category option[value="${link_selected}"]`
                ).selected = true;
            }
        });

        document.getElementById('wait').style.display = 'block';

        fetch(ajax_url, {
            method: "POST",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
            },
            body: `action=load_leader_board&items=${items}&id_sub_category=${link_selected}`
            
        })
            .then((response) => {
                document.getElementById("wait").style.display = "none";
                setTimeout(() => {
                    let messages = document.querySelectorAll('.rdg-blocks .rdg-leader-board .list-items .message');
                    let opacity = 1;
                    let interval = setInterval(function() {
                    opacity -= 0.1;
                    messages.forEach(function(message) {
                        message.style.opacity = opacity;
                    });
                    if (opacity <= 0) {
                        clearInterval(interval);
                    }
                    }, 150);
                }, 4000);
                return response.text();
            })
            .then((resultado) => {
                document.querySelector('.rdg-blocks .rdg-leader-board').querySelector('.list-items').innerHTML = resultado;
                document.querySelector('#wait').style.display = 'none';
            })
            .catch((error) => console.error(error));
    }
});

document.querySelector("#rdg-leader-board-date-range").addEventListener("change", function (e) {
        e.preventDefault();
        document.querySelectorAll(".rdg-blocks .rdg-leader-board .list-items .message")
            .forEach(function (el) {
                el.style.display = "none";
            });

        let ajax_url = rdg_leader_board_var.ajaxurl;
        let items = document.querySelector("#rdg-leader-board-date-range option:checked").value;
        let cat_selected = document.querySelector("#rdg-leader-board-category option:checked").value;

        document.getElementById('wait').style.display = 'block';

        fetch(ajax_url, {
            method: "POST",
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `action=load_leader_board&items=${items}&id_sub_category=${cat_selected}`
        })
            .then(function (response) {
                return response.text();
            })
            .then(function (resultado) {
                document.querySelector(".rdg-blocks .rdg-leader-board .list-items").innerHTML = resultado;
                document.querySelector('#wait').style.display = 'none';
                setTimeout(function () {
                    document.querySelectorAll(".rdg-blocks .rdg-leader-board .list-items .message").forEach(function (el) {
                            el.style.display = "none";
                        });
                }, 4000);
            });
    });

// (function($) {
//     $(document).on('change','#rdg-leader-board-category',function(e) {
//         e.preventDefault();
//         $(".rdg-blocks .rdg-leader-board .list-items .message").hide();

//         let ajax_url = rdg_leader_board_var.ajaxurl;
//         let items = $('#rdg-leader-board-date-range option:checked').val();
//         let cat_seleted = $('#rdg-leader-board-category option:checked').val();

//         let menus = $('.table .table-menu .menu a');
//         $('.table .table-menu .menu a').removeClass('active');
//         $('.table .table-menu .menu a').addClass('unactive');

//         $.each(menus, function(key, val) {
//             if ($(val).attr('data-category') == cat_seleted) {
//                 $(val).removeClass('unactive');
//                 $(val).addClass('active');
//             }
//         }, cat_seleted);

//         $.ajax({
//             url : ajax_url,
//             type: 'post',
//             data: {
//                 action : 'load_leader_board',
//                 items: items,
//                 id_sub_category: cat_seleted,
//             },
//             beforeSend: function() {
//                 $('#wait').show();
//             },
//             success: function(resultado) {
//                 $('.rdg-blocks .rdg-leader-board').find('.list-items').html(resultado);
//                 $('#wait').hide();
//                 setTimeout(function() {
//                     $(".rdg-blocks .rdg-leader-board .list-items .message").fadeOut(1500);
//                 }, 4000);
//             }
//         });
//     });
// });

// (function($) {
//     $(document).on('click','.table .table-menu .menu a',function(e) {
//         e.preventDefault();

//         if ($(e.target).hasClass('active')) {
//             return;
//         }

//         let menus = $('.table .table-menu .menu a');
//         let menu_id = $(this).attr('id');

//         $.each(menus, function(key, val) {
//             if (menu_id == $(val).attr("id")) {
//                 $(val).removeClass('unactive');
//                 $(val).addClass('active');
//             } else {
//                 $(val).removeClass('active');
//                 $(val).addClass('unactive');
//             }
//         }, menu_id);

//         $(".rdg-blocks .rdg-leader-board .list-items .message").hide();

//         let ajax_url = rdg_leader_board_var.ajaxurl;
//         let items = $('#rdg-leader-board-date-range option:checked').val();
//         let link_seleted = $(this).attr('data-category');
//         let categories = $('#rdg-leader-board-category option');

//         $('#rdg-leader-board-category option').attr("selected", false);
//         $.each(categories, function(key, option) {
//             if ($(option).val() == link_seleted) {
//                 $('#rdg-leader-board-category option[value="'+link_seleted+'"]').attr("selected", "selected");
//             }
//         }, link_seleted);

//         $.ajax({
//             url : ajax_url,
//             type: 'post',
//             data: {
//                 action : 'load_leader_board',
//                 items: items,
//                 id_sub_category: link_seleted,
//             },
//             beforeSend: function() {
//                 $('#wait').show();
//             },
//             success: function(resultado) {
//                 $('.rdg-blocks .rdg-leader-board').find('.list-items').html(resultado);
//                 $('#wait').hide();
//                 setTimeout(function() {
//                     $(".rdg-blocks .rdg-leader-board .list-items .message").fadeOut(1500);
//                 }, 4000);
//             }
//         });
//     });
// });

// (function($) {
//     $(document).on('change','#rdg-leader-board-date-range',function(e) {
//         e.preventDefault();
//         $(".rdg-blocks .rdg-leader-board .list-items .message").hide();

//         let ajax_url = rdg_leader_board_var.ajaxurl;
//         let items = $('#rdg-leader-board-date-range option:checked').val();
//         let cat_seleted = $('#rdg-leader-board-category option:checked').val();

//         $.ajax({
//             url : ajax_url,
//             type: 'post',
//             data: {
//                 action : 'load_leader_board',
//                 items: items,
//                 id_sub_category: cat_seleted,
//             },
//             beforeSend: function() {
//                 $('#wait').show();
//             },
//             success: function(resultado) {
//                 $('.rdg-blocks .rdg-leader-board').find('.list-items').html(resultado);
//                 $('#wait').hide();
//                 setTimeout(function() {
//                     $(".rdg-blocks .rdg-leader-board .list-items .message").fadeOut(1500);
//                 }, 4000);
//             }
//         });
//     });
// }) (jQuery);
