<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_SOCIALS_ICONS;
    $block_classes = [$block_name];
    $block_picks_list = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $title = get_field('title');
    $icons = get_field('icons');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content">
            <?php if (!empty($icons) && count($icons) > 0): ?>
                <div class="social-header">
                    <span class="title"><?php echo $title; ?></span>
                </div>

                <div class="icons">
                    <?php if (is_array($icons) && count($icons) > 0):?>
                        <?php foreach($icons as $icon):?>
                            <?php if (!empty($icon['logo']['url'])): ?>
                                <div class="logo">
                                    <?php if (!empty($icon['link']['url'])): ?>
                                        <a href="<?php echo $icon['link']['url']; ?>" target="<?php echo $icon['link']['target']; ?>">
                                    <?php endif; ?>

                                    <img src="<?php echo $icon['logo']['url']; ?>" alt="Image">

                                    <?php if (!empty($icon['link']['url'])): ?>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
