<?php  
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_MEMBERSHIP_INFO;
    // $block_classes = [$block_name];
    $block_membership_info = $rdgb->settings->getBlock($block_name);

    $blockTitle = get_field('title');
    $source = get_field('source');

    // Manual
    $premiumPackage = get_field('premium_package');
    $classicPackage = get_field('classic_package');
    $starterPlusPackage = get_field('starter_plus_package');
    $starterPackage = get_field('starter_package');

    // API
    $premiumPackageAPI = get_field('premium_package_api');
    $classicPackageAPI = get_field('classic_package_api');
    $starterPlusPackageAPI = get_field('starter_plus_package_api');
    $starterPackageAPI = get_field('starter_package_api');

    $message = '';
    $cache_file = null;
    $api_attributes = null;

    if ($block_membership_info->isCaching()) {
        $api_url = get_field('membership_info_api_url', 'option');
        $api_token = get_field('membership_info_api_token', 'option');
            
        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_membership_info->getApiAttributes();
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
            $response = $block_membership_info->getResources($api_attributes, $cache_file);

            if (empty($response->message) && is_array($response->json)) {
                    $memberships = $response->json;
            } else {
                    $memberships = null;
                    $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
<?php
        $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
        $block_membership_info->getLogDebug($params);
    ?>
    <div class="rdg-membership-info">
       <div class="mi_section">
            <div class="mi_wrapper">

            <?php if (!empty($memberships)): ?>
                    <?php
                        if ($source == 'api') {
                            require 'partials/api.php';
                        } else {
                            require 'partials/manual.php';
                        }
                    ?>
                <?php else: ?>
                    <?php if (!empty($message)): ?>
                        <span class="message"><?php echo $message; ?></span>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
       </div>
    </div>
</div>
