<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Quick_Links_Sidebar extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_QUICK_LINKS_SIDEBAR;
    private $block_folder_name = 'rdg-quick-links-sidebar';
    protected $block_title = 'RDG Quick Links Sidebar';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'quick', 'link', 'sidebar'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_quick_links_sidebar.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-quick-link-sidebar-header-bg','slug' => 'color-quick-link-sidebar-header-bg','color' => '#0160ac'],
            ['name' => 'color-quick-link-sidebar-title','slug' => 'color-quick-link-sidebar-title','color' => '#FFFFFF'],
            ['name' => 'color-quick-link-sidebar-border','slug' => 'color-rdg-top-winners-body-bg','color' => '#CCC'],
            ['name' => 'color-quick-link-sidebar-item','slug' => 'color-quick-link-sidebar-item','color' => '#0160ac'],
            ['name' => 'color-quick-link-sidebar-li','slug' => 'color-quick-link-sidebar-li','color' => '#00bb08'],
            ['name' => 'color-quick-link-sidebar-a','slug' => 'color-quick-link-sidebar-a','color' => '#0160ac'],
            ['name' => 'color-quick-link-a-sidebar-hover','slug' => 'color-quick-link-a-sidebar-hover','color' => '#3a96e0'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-quick-links-sidebar .header .title',
                'fontWeight' => '700',
                'fontSize' => '1.1rem',
            ],
            [
                'customSelector' => '.rdg-quick-links-sidebar .body li',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-quick-links-sidebar .body li::marker',
                'fontSize' => '0.8rem',
            ],
        ];
    }
}

$rdg_quick_links_sidebar_class = new Rdg_Blocks_Quick_Links_Sidebar();
$rdg_quick_links_sidebar_class->init();

return $rdg_quick_links_sidebar_class;
