<?php 
    global $rdgb;
    $block_styles = [];
    $name_block = BLOCK_RDG_MEMBERSHIPS;
    $block_classes = [$name_block];
    $block_title = $rdgb->settings->get_block($name_block);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $title= get_field('title');
    $firstPack = get_field('first_pack');
    $thirdPack = get_field('third_pack');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <!-- Block Title -->
            <div class="title">
                <p><?php echo $title; ?></p>
            </div>

            <!-- Container -->
            <div class="column">

                <!-- First Pack -->
                <div class="first_pack">
                    <?php  
                    
                    if( $firstPack) {
                    
                        $title = $firstPack['title'];
                        $description = $firstPack['description'];
                        $price = $firstPack['price'];
                        $linkURL = $firstPack['link']['url'];
                        $linkTitle= $firstPack['link']['title'];

                    ?>
                        <div class="header">
                            <p><?php echo  $title;?></p>
                        </div>
                        <div class="body">
                            <div class="description">
                                <?php echo $description; ?>
                            </div>
                            <div class="footer">
                                <div class="price">
                                    <p>$<?php echo $price; ?></p>
                                </div>
                                <div class="btn">
                                    <a href="<?php echo $linkURL; ?>"><?php echo $linkTitle; ?></a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <!-- End First Pack -->
                </div>

                <!-- Second Pack -->
                <div class="second_pack">
                    <?php  
                        if( have_rows('second_pack') ): while ( have_rows('second_pack') ) : the_row(); 
                            
                            $secondTitle = get_sub_field('title');
                            $secondPrice= get_sub_field('price');
                            $secondDescription = get_sub_field('description');
                            $secondLinkURL = get_sub_field('link');

                        ?>

                        <div class="header">
                            <p><?php echo $secondTitle ; ?></p>
                        </div>
                        <div class="body">
                            <div class="deal">
                                <div class="price">
                                <p>$<?php echo $secondPrice; ?></p>
                                </div>
                                <div class="list">
                                    <ul>
                                        <?php if( have_rows('list') ): while ( have_rows('list') ) : the_row();  ?>
                                            <li><?php echo get_sub_field('list_info') ?></li>
                                        <?php endwhile; endif; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="description">
                                <?php echo $secondDescription; ?>
                            </div>
                            <div class="btn">
                                <a href="<?php echo $secondLinkURL['url']; ?>"><?php echo $secondLinkURL['title']; ?></a>
                            </div>
                        </div>
                    <?php endwhile; endif; ?>
                <!-- End Second Pack -->
                </div>

                <!-- Third Pack -->
                <div class="third_pack">
                    <?php  
                    
                        if( $thirdPack ) {
                            
                            $thirdTitle = $thirdPack ['title'];
                            $thirdDescription = $thirdPack['description'];
                            $thirdPrice = $thirdPack ['price'];
                            $thirdGreat_Value = $thirdPack ['great_value'];
                            $thirdLinkURL = $thirdPack ['link']['url'];
                            $thirdLinkTitle= $thirdPack ['link']['title'];

                        ?>

                        <div class="header">
                            <p><?php echo  $thirdTitle; ?></p>
                        </div>
                        <div class="body">
                            <div class="left">
                                <div class="description">
                                <p><?php echo  $thirdDescription; ?></p> 
                                </div>
                                <div class="great_value">
                                    <?php if ($thirdGreat_Value ) { ?>
                                        <img src="https://main-bvxea6i-rdjrocko7mvzg.us-2.platformsh.site/app/uploads/2023/04/icon-completo-1.png" alt="Verified Great Value">
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="right">
                                <div class="price">
                                    <div class="dollar">$</div>
                                    <div class="amount"><?php echo  $thirdPrice; ?></div>
                                </div>
                                <div class="btn">
                                    <a href="<?php echo $thirdLinkURL; ?>"><?php echo $thirdLinkTitle; ?></a>
                                </div>
                            </div>
                        </div>

                    <?php } ?>
                <!-- End Third Pack -->
                </div>

                <!-- Fourth Pack -->
                <div class="fourth_pack">
                    <?php  
                    
                        if ( have_rows('fourth_pack') ): while ( have_rows('fourth_pack') ) : the_row(); 
                            
                        $fourthTitle = get_sub_field('title');
                        $fourthDiscount= get_sub_field('discount');
                        $fourthBestDeal= get_sub_field('best_deal');
                        $fourthDescription = get_sub_field('description');
                        $fourthLink = get_sub_field('link');
                    
                    ?>

                        <div class="header">
                            <p><?php echo $fourthTitle; ?></p>
                        </div>
                        <div class="body">
                            <div class="deal">
                                <span class="off"><?php echo $fourthDiscount; ?></span> 
                                    <span class="dot">•</span> 
                                <span class="best_deal"><?php echo $fourthBestDeal; ?></span>
                            </div>
                            <div class="list">
                                <ul>
                                    <?php if( have_rows('list') ): while ( have_rows('list') ) : the_row(); ?>
                                        <li><?php echo get_sub_field('list_info') ?></li>
                                   <?php endwhile; endif; ?>
                                </ul>
                            </div>
                            <div class="btn">
                                <a href="<?php echo $fourthLink['url']; ?>"><?php echo $fourthLink['title']; ?></a>
                            </div>
                        </div>

                    <?php endwhile; endif; ?>
                <!-- End Fourth Pack -->
                </div>

                <!-- End Container -->
            </div>

            <!-- End Grid Container -->
        </div>
    </div>
</div>