<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_INJURY_REPORT;
    $block_classes = [$block_name];
    $block_injury_report = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $league = (!empty(get_field('rdg_injury_report_leagues'))) ? get_field('rdg_injury_report_leagues') : null;
    $team = (!empty(get_field('rdg_injury_report_teams'))) ? get_field('rdg_injury_report_teams') : null;
    $select_season = (!empty(get_field('rdg_injury_report_season'))) ? get_field('rdg_injury_report_season') : null;
    $items = (!empty(get_field('rdg_injury_report_items_per_page'))) ? get_field('rdg_injury_report_items_per_page') : 10;
    $season = $block_injury_report->getSeason($league, $select_season);

    $injuries = null;
    $api_attributes = [];
    $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
    $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
    $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
    $cache_file_valid = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id, true);

    if ($block_injury_report->isCaching()) {
        $api_url = get_field('injury_report_api_url', 'option');
        $api_token = get_field('injury_report_api_token', 'option');

        if (!empty($api_url) && !empty($api_token) && !empty($team)) {
            $api_attributes = $block_injury_report->getApiAttributes($items, ['league' => $league, 'team' => $team, 'season' => $season]);
            $response = $block_injury_report->getResources($api_attributes, $cache_file);

            if (empty($response->message) && is_array($response->json)) {
                $injuries = $response->json[0]['data-content'][0][0]['injuries'];
            } else {
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }

    $filter_data = $block_injury_report->getSearchOptions($block_name, $post_id_custom, $block_custom_id, true);
    $options_locations = (isset($filter_data['locations']) && !empty($filter_data['locations'])) ? $filter_data['locations'] : '';
    $options_status = (isset($filter_data['status']) && !empty($filter_data['status'])) ? $filter_data['status'] : '';
    $options_display_status = (isset($filter_data['display_status']) && !empty($filter_data['display_status'])) ? $filter_data['display_status'] : '';
?>

<div class="rdg-blocks">
    <?php
        $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
        $block_injury_report->getLogDebug($params);
        $debug_cache = $rdgb->helpers->rdgDebugCache($cache_file);
    ?>
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
            <?php if (is_array($injuries) && count($injuries) > 0): ?>
                <?php
                if (count($injuries) > 3 && is_user_logged_in() && current_user_can('administrator')) {
                    $injuries = array_slice($injuries, 0, 3, true);
                }
                ?>
                <section class="filter" data-debug-cache="<?php echo $debug_cache;?>" data-current-page="1" data-items-per-page="<?php echo $items;?>" data-cache-file="<?php echo $cache_file;?>" data-block-name="<?php echo $block_name;?>" data-custom-id="<?php echo $block_custom_id;?>" data-post-id="<?php echo $post_id_custom;?>">
                    <div class="search">
                        <input type="text" id="search" name="search" class="search" placeholder="SEARCH">
                    </div>
                    <div class="options">
                        <select name="location" id="location">
                            <option value="">Location</option>
                            <?php echo $options_locations; ?>
                        </select>
                        <select name="status" id="status">
                            <option value="">Status</option>
                            <?php echo $options_status; ?>
                        </select>
                        <select name="display_status" id="display-status">
                            <option value="">Display Status</option>
                            <?php echo $options_display_status; ?>
                        </select>
                    </div>
                </section>
                <section class="results"></section>
                <div class="injuries">
                    <?php
                        $players = (function_exists('shMappingTeamPlayers')) ? shMappingTeamPlayers() : [];
                    ?>
                    <?php foreach ($injuries as $injury): ?>
                        <div class="injury">
                            <div class="player">
                                <span>
                                <?php
                                    if (is_user_logged_in() && current_user_can('administrator')) {
                                        echo sprintf('<b>Player:</b> %1$s', $rdgb->helpers->getPlayerName($injury['player_id'], $players));
                                    } else {
                                        echo sprintf('<b>Player:</b> %1$s', $injury['player_id']);
                                    }
                                ?>
                                </span>
                            </div>
                            <div class="content">
                                <span class="location">
                                    <?php echo sprintf('<b>Location:</b> %1$s', $injury['location']); ?>
                                </span>
                                <span class="start-date">
                                    <?php echo sprintf('<b>Start Date:</b> %1$s', $injury['start_date']); ?>
                                </span>
                                <span class="status">
                                    <?php echo sprintf('<b>Status:</b> %1$s', $injury['status']); ?>
                                </span>
                                <span class="display-status">
                                    <?php echo sprintf('<b>Display Status:</b> %1$s', $injury['display_status']); ?>
                                </span>
                            </div>
                            <div class="note">
                                <?php echo sprintf('<b>Note:</b> %1$s', $injury['note']); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <section class="pagination-result"></section>
                <section class="message">
                    <?php
                        if (is_user_logged_in() && current_user_can('administrator') && !file_exists($cache_file_valid)) {
                            echo '<span>It is necessary to save to generate the cache of the RDG Injury Report block.</span>';
                        } 
                    ?>
                </section>
            <?php endif; ?>
        </div>
    </div>
</div>
