<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Carousel extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_CAROUSEL;
    private $block_folder_name = 'rdg-carousel';
    protected $block_title = 'RDG Carousel';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'carousel'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
        
        add_filter('acf/load_field/name=post_type', [$this, 'load_cpts']);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_carousel.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group( array(
                'key' => 'group_66eb6cec5065d',
                'title' => 'RDG Carousel',
                'fields' => array(
                    array(
                        'key' => 'field_66eb6cedd9b7c',
                        'label' => 'Post Type',
                        'name' => 'post_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                        ),
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_66eb6d18d9b7d',
                        'label' => 'Quantity',
                        'name' => 'quantity',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 4,
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_66eb6d96d9b7e',
                        'label' => 'Order By',
                        'name' => 'order_by',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'ASC' => 'ASC',
                            'DESC' => 'DESC',
                        ),
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_66eb6e06d9b7f',
                        'label' => 'Order',
                        'name' => 'order',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'date' => 'Date',
                            'title' => 'Title',
                            'rand' => 'Random',
                        ),
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-carousel',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ) );
        endif;
    }

    function load_cpts( $field ) {
        $field['choices'] = array();
        
        $args = array(
            'public'   => true,  
            '_builtin' => false, 
        );
        
        $cpts_personalizados = get_post_types( $args, 'objects' );

        $args_builtin = array(
            'public'   => true,  
            '_builtin' => true, 
        );
        
        $cpts_builtin = get_post_types( $args_builtin, 'objects' );
        
        $cpts = array_merge( $cpts_builtin, $cpts_personalizados );


        if ( !empty( $cpts ) ) {
            foreach ( $cpts as $cpt ) {
                if ( $cpt->name !== 'kaliforms_submitted' && $cpt->name !== 'attachment' ) {
                    $field['choices'][ $cpt->name ] = $cpt->labels->singular_name;
                }
            }
        }

        return $field;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-carousel-btn-border','slug' => 'color-rdg-carousel-btn-border','color' => '#A7A7A7'],
            ['name' => 'color-rdg-carousel-date','slug' => 'color-rdg-carousel-date','color' => '#A7A7A7'],
            ['name' => 'color-rdg-carousel-title','slug' => 'color-rdg-carousel-title','color' => '#275FA6'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-carousel .wrapper .carousel .carousel-item .date',
                'fontWeight' => '400',
                'fontSize' => '12px',
                'lineHeight' => 'normal',
            ],
            [
                'customSelector' => '.rdg-carousel .wrapper .carousel .carousel-item .title',
                'fontWeight' => '700',
                'fontSize' => '20px',
                'lineHeight' => 'normal',
                'textDecoration' => 'underline',
            ],
            [
                'customSelector' => '.rdg-carousel .wrapper .carousel .carousel-item .excerpt',
                'fontWeight' => '400',
                'fontSize' => '14px',
                'lineHeight' => '24px',
                'letterSpacing' => '0.14px',
            ],
        ];
    }
}

$rdg_carousel = new Rdg_Blocks_Carousel();
$rdg_carousel->init();

return $rdg_carousel;
