<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_SAS_Navbar extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_SAS_NAVBAR;
    private $block_folder_name = 'rdg-sas-navbar';
    protected $block_title = 'RDG SAS Navbar';
    private $block_description = 'The block allow to structure a navbar for the site, it is possible to edit the logo, the menu, idiom links with flags, and buttons for login and sing up';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'navigation', 'menu'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                // 'enqueue_style' => $rdg_helpers->webpack('rdg_sas_navbar.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-sas-navbar-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group( array(
                'key' => 'group_66b917f6cd067',
                'title' => 'SAS Navbar',
                'fields' => array(
                    array(
                        'key' => 'field_66ba8db10c60b',
                        'label' => 'Full container',
                        'name' => 'full_container',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'fullwidth' => 'Full Width',
                            'contained' => 'Contained',
                        ),
                        'default_value' => '',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_66ba78766b2b2',
                        'label' => 'Secondary Menu',
                        'name' => 'secondary_menu',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_66ba788c6b2b3',
                                'label' => 'Secondary Link',
                                'name' => 'secondary_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_66ba78766b2b2',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_66ba9cf234817',
                        'label' => 'Language',
                        'name' => 'language',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_66ba9d0a34818',
                                'label' => 'Language Link',
                                'name' => 'language_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_66ba9d1f34819',
                                'label' => 'Language Flag',
                                'name' => 'language_flag',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_66b917f782f64',
                        'label' => 'Site Logo',
                        'name' => 'site_logo',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_66c50cc717615',
                        'label' => 'Site Logo Link',
                        'name' => 'site_logo_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                    array(
                        'key' => 'field_66ba78c56b2b4',
                        'label' => 'Main Menu',
                        'name' => 'main_menu',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_66ba78d76b2b5',
                                'label' => 'Menu Link',
                                'name' => 'menu_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_66ba78c56b2b4',
                            ),
                            array(
                                'key' => 'field_66ba78eb6b2b6',
                                'label' => 'Has dropdown?',
                                'name' => 'has_dropdown',
                                'aria-label' => '',
                                'type' => 'true_false',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'message' => '',
                                'default_value' => 1,
                                'ui' => 0,
                                'ui_on_text' => '',
                                'ui_off_text' => '',
                                'parent_repeater' => 'field_66ba78c56b2b4',
                            ),
                            array(
                                'key' => 'field_66ba79126b2b7',
                                'label' => 'Submenu Link',
                                'name' => 'submenu',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_66ba78eb6b2b6',
                                            'operator' => '==',
                                            'value' => '1',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_66ba79386b2b8',
                                        'label' => 'Submenu Link',
                                        'name' => 'submenu_link',
                                        'aria-label' => '',
                                        'type' => 'link',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'parent_repeater' => 'field_66ba79126b2b7',
                                    ),
                                    array(
                                        'key' => 'field_66bea31239b49',
                                        'label' => 'Submenu Icon',
                                        'name' => 'submenu_icon',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'noicon' => 'No Icon',
                                            'football' => 'Football',
                                            'hockey' => 'Hockey',
                                            'baseball' => 'Baseball',
                                            'basketball' => 'Basketball',
                                            'soccer' => 'Soccer',
                                        ),
                                        'default_value' => false,
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_66ba79126b2b7',
                                    ),
                                ),
                                'parent_repeater' => 'field_66ba78c56b2b4',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_66ba7a866b2ba',
                        'label' => 'Log In Link',
                        'name' => 'login_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                    array(
                        'key' => 'field_66ba795b6b2b9',
                        'label' => 'Sign Up Link',
                        'name' => 'sign_up_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-sas-navbar',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ) );

        endif;		
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-secondary-banner-bg','slug' => 'color-rdg-secondary-banner-bg','color' => '#F1F1F1'],
            ['name' => 'color-rdg-secondary-banner-left-bg','slug' => 'color-rdg-secondary-banner-left-bg','color' => '#0160ac'],
            ['name' => 'color-rdg-secondary-banner-left','slug' => 'color-rdg-secondary-banner-left','color' => '#FFFFFF'],
            ['name' => 'color-rdg-secondary-banner-right-link','slug' => 'color-rdg-secondary-banner-right-link','color' => '#FFFFFF'],
            ['name' => 'color-rdg-secondary-banner-right-link-bg','slug' => 'color-rdg-secondary-banner-right-link-bg','color' => '#00bc00'],
            ['name' => 'color-rdg-secondary-banner-right-link-bg-hover','slug' => 'color-rdg-secondary-banner--right-link-bg-hover','color' => '#68f96e'],
            ['name' => 'color-rdg-secondary-banner-right-link-border-top','slug' => 'color-rdg-secondary-banner-right-link-border-top','color' => '#244d0e'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-secondary-banner .right a',
                'fontWeight' => '700',
                'textDecoration' => 'none',
            ],
            [
                'customSelector' => '.rdg-secondary-banner .left',
                'fontWeight' => '600',
            ],
        ];
    }
}

$rdg_sas_navbar_class = new Rdg_Blocks_SAS_Navbar();
$rdg_sas_navbar_class->init();

return $rdg_sas_navbar_class;
