<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Sports_Picks_Vs extends Rdg_Blocks_Base implements Rdg_Blocks_Api_Request
{
    protected $block_name = BLOCK_RDG_SPORTS_PICKS_VS;
    private $block_folder_name = 'rdg-sports-picks-vs';
    protected $block_title = 'RDG Sports Picks Vs';
    private $block_description = 'The block allow display the info of sports picks vs in a dynamic or manual form, it is allowed to edit the source of the info, date, number of items, sport / game parts and the link for te items';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'sports', 'picks', 'vs'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = true;
    protected $is_config = true;
    protected $is_styles_load = true;
    protected $config_page_title = 'RDG Sports Picks Vs';
    protected $config_menu_title = 'Sports Picks Vs';

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_sports_picks_vs.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-sports-picks-vs-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        $rdg_helpers = new Rdg_Blocks_Helpers();

        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_sports_picks_vs_block_5e6g456456',
                'title' => 'Block_rdg_sports_picks_vs',
                'fields' => array(
                    array(
                        'key' => 'field_6466295e2c53d',
                        'label' => 'Source',
                        'name' => 'source',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'manual' => 'Manual',
                            'api' => 'API',
                        ),
                        'default_value' => 'manual',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_64badfe684035',
                        'label' => 'Link Options',
                        'name' => 'link_options',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'none' => 'None',
                            'default' => 'API',
                            'custom' => 'Custom',
                        ),
                        'default_value' => 'none',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_64bae02284036',
                        'label' => 'Link',
                        'name' => 'custom_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64badfe684035',
                                    'operator' => '==',
                                    'value' => 'custom',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                    array(
                        'key' => 'field_63c0765368257',
                        'label' => 'Picks',
                        'name' => 'picks',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'manual',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63c0765389857',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c0765368257',
                            ),
                            array(
                                'key' => 'field_63c076539bd5b',
                                'label' => 'Teams',
                                'name' => 'teams',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 2,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63c07653b655e',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                    array(
                                        'key' => 'field_63c07653b9f7b',
                                        'label' => 'Odds',
                                        'name' => 'odds',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                    array(
                                        'key' => 'field_63c094f2bc9e8',
                                        'label' => 'Opener',
                                        'name' => 'opener',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                    array(
                                        'key' => 'field_63c09538bc9e9',
                                        'label' => 'Current',
                                        'name' => 'current',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                    array(
                                        'key' => 'field_63c0955dbc9ea',
                                        'label' => 'Money Line',
                                        'name' => 'money_line',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                ),
                                'parent_repeater' => 'field_63c0765368257',
                            ),
                            array(
                                'key' => 'field_63c095b6bc9eb',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c0765368257',
                            ),
                            array(
                                'key' => 'field_63c07653a3263',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63c0765368257',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_64662bda2c53e',
                        'label' => 'Sports / Game Parts',
                        'name' => 'sports_parts',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => 'sport_picks_vs_sports_categories',
                        ),
                        'choices' => $rdg_helpers->getSporstPartsOptions(true),
                        'default_value' => '',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 1,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64662e1c8a863',
                        'label' => 'Date Type',
                        'name' => 'date_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'yesterday' => 'Yesterday',
                            'now' => 'Now',
                            'tomorrow' => 'Tomorrow',
                            'range' => 'Specific Date',
                        ),
                        'default_value' => 'now',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64662eaf8a864',
                        'label' => 'Date',
                        'name' => 'date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64662e1c8a863',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'd/m/Y',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                    ),
                    array(
                        'key' => 'field_64662c0d2c53f',
                        'label' => 'Number of Items',
                        'name' => 'number_of_items',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 100,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64662c472c540',
                        'label' => 'All Link',
                        'name' => 'all_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-sports-picks-vs',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_sports_picks_vs_block_awedddadads',
                'title' => 'API configuration',
                'fields' => array(
                    array(
                        'key' => 'field_64665c60064d2',
                        'label' => 'URL',
                        'name' => 'sports_picks_vs_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '70',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64665cbb064d3',
                        'label' => 'Cache Refresh Frequency (Hours)',
                        'name' => 'sports_picks_vs_interval',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 10,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64665cf1064d4',
                        'label' => 'Token',
                        'name' => 'sports_picks_vs_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '70',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sports-picks-vs',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getApiAttributes($items = null, $attributes = []) {
        $api_url = get_field('sports_picks_vs_api_url', 'option');
        $api_token = get_field('sports_picks_vs_api_token', 'option');
        $cache_refresh = get_field('sports_picks_vs_interval', 'option');
        $items = (!empty($items)) ? intval($items) : 10;

        $api_url = (substr($api_url, -1) == '/') ? substr($api_url, 0, strlen($api_url) -1) : $api_url;
        $api_url .= '?recordsQty='.$items;

        if (isset($attributes['sports_parts']) && strpos($attributes['sports_parts'], '-')) {
            list($sport, $game_part) = explode('-', $attributes['sports_parts']);
        } else {
            $game_part = null;

            if (isset($attributes['sports_parts']) && !empty($attributes['sports_parts'])) {
                $sport = $attributes['sports_parts'];
            } else {
                $sport = null;
            }
        }

        if (!empty($sport)) {
            $api_url .= '&sport='.$sport;
        }

        if (!empty($game_part)) {
            $api_url .= '&gamePart='.$game_part;
        }

        if (isset($attributes['date']) && is_array($attributes['date']) && count($attributes['date']) == 1) {
            if (!empty($attributes['date']['start'])) {
                $api_url .= '&date='.$attributes['date']['start'];
            }
        }

        $api_url .= '&completeGames=1';
        $api_request = $api_url.'&api_token='.$api_token;

        return [
            'items' => $items,
            'method' => 'GET',
            'cache_refresh' => $cache_refresh,
            'headers' => ['Accept: application/json'],
            'request' => $api_request,
        ];
    }

    public function getApiParams() {
        return [
            'sports_parts' => 'sports_parts',
            '_to_transform_' => [
                'key' => 'date',
                'function' => 'get_date_filter',
                'params' => ['date_type', 'date'],
                'fields_date' => ['date'],
            ],
        ];
    }

    public function get_date_filter($date_type, $date) {
        $array_date = [
            'start' => null
        ];

        if ($date_type == API_DATE_TYPE_YESTERDAY) {
            $array_date['start'] = date('Y-m-d', strtotime("-1 days"));

            return $array_date;
        }

        if ($date_type == API_DATE_TYPE_NOW) {
            $array_date['start'] = date('Y-m-d');

            return $array_date;
        }
        
        if ($date_type == API_DATE_TYPE_TOMORROW) {
            $array_date['start'] = date('Y-m-d',strtotime("+1 days"));
            
            return $array_date;
        }

        if ($date_type == API_DATE_TYPE_RANGE && !empty($date)) {
            $array_date['start'] = $date;

            return $array_date;
        }

        return $array_date;
    }

    public function getResources($request, $cache_file) {
        $data = new StdClass();
        $data->json = '';
        $data->message = '';
        $rdgb_helpers = New Rdg_Blocks_Helpers;

        $sport_picks_vs = $rdgb_helpers->getApiData($this->block_name, $cache_file, $request);

        if (!empty($sport_picks_vs->message)) {
            $data->message = $sport_picks_vs->message;
        
            return $data;
        }

        $data->json = $sport_picks_vs->json;

        return $data;
    }

    public function get_image($url_image, $attributes = []) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $url_image = $rdgb_helpers->getImageSource($url_image, $attributes);

        return $url_image;
    }

    public function getFieldsValidate() {
        return [
            //'id_game' => ['required', 'notnull'],
            //'game_date' => ['required', 'notnull'],
            //'sport' => ['required', 'notnull'],
            //'id_visitor_team' => ['required', 'notnull'],
            //'id_master_visitor_team' => ['required', 'notnull'],
            'visitor_team' => ['required', 'notnull'],
            //'visitor_score' => ['required', 'notnull'],
            'visitor_image' => ['required', 'notnull'],
            //'id_home_team' => ['required', 'notnull'],
            //'id_master_home_team' => ['required', 'notnull'],
            'home_team' => ['required', 'notnull'],
            //'home_score' => ['required', 'notnull'],
            'home_image' => ['required', 'notnull'],
            //'game_stat' => ['required', 'notnull'],
            //'category' => ['required', 'notnull'],
            //'league' => ['required', 'notnull'],
            'game_picks_count' => ['required'],
            'game_url' => ['required', 'notnull'],
        ];
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-sports-picks-vs-title-bg','slug' => 'color-sports-picks-vs-title-bg','color' => '#021c40'],
            ['name' => 'color-sports-picks-vs-bg','slug' => 'color-sports-picks-vs-bg','color' => '#FFFFFF'],
            ['name' => 'color-sports-picks-vs-title-color','slug' => 'color-sports-picks-vs-title-color','color' => '#FFFFFF'],
            ['name' => 'color-sports-picks-vs-footer-bg','slug' => 'color-sports-picks-vs-footer-bg','color' => '#021c40'],
            ['name' => 'color-sports-picks-vs-border','slug' => 'color-sports-picks-vs-border','color' => '#3a96e0'],
            ['name' => 'color-sports-picks-vs-team-vs-logo-bg','slug' => 'color-sports-picks-vs-team-vs-logo-bg','color' => '#0160ac'],
            ['name' => 'color-sports-picks-vs-team-vs-logo','slug' => 'color-sports-picks-vs-team-vs-logo','color' => '#ffffff'],
            ['name' => 'color-sports-picks-vs-separator-border','slug' => 'color-sports-picks-vs-separator-border','color' => '#CCC'],
            ['name' => 'color-sports-picks-vs-available','slug' => 'color-sports-picks-vs-available','color' => '#FFFFFF'],
            ['name' => 'color-sports-picks-vs-available-bg','slug' => 'color-sports-picks-vs-available-bg','color' => '#0160ac'],
            ['name' => 'color-sports-picks-vs-footer-link','slug' => 'color-sports-picks-vs-footer-link','color' => '#ffffff'],
            ['name' => 'color-sports-picks-vs-footer-link-hover','slug' => 'color-sports-picks-vs-footer-link-hover','color' => '#3a96e0'],
            ['name' => 'color-sports-picks-vs-field-color','slug' => 'color-sports-picks-vs-field-color','color' => '#475364'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-sports-picks-vs .picks .pick .pick-header .title',
                'fontWeight' =>'600',
                'fontSize' => '1.1rem',
                //'fontSizeMobile' => '1rem',
            ],
            [
                'customSelector' => '.rdg-sports-picks-vs .picks .pick .pick-body .fields .leyend',
                'fontSize' => '0.9rem',
                'fontSizeMobile' => '0.8rem'
            ],
            [
                'customSelector' => '.rdg-sports-picks-vs .picks .pick .pick-body .fields .team-home, .rdg-sports-picks-vs .picks .pick .pick-body .fields .team-visitor',
                'fontWeight' => '700',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-sports-picks-vs .picks .pick .pick-body .teams .team-vs .vs-logo span',
                'fontWeight' => '500',
                'fontSize' => '1.1rem',
            ],
            [
                'customSelector' => '.rdg-sports-picks-vs .picks .pick .pick-body .picks-available',
                'fontWeight' => '500',
                'fontSize' => '0.9rem',
                'fontSizeTablet' => '0.8rem',
            ],
            [
                'customSelector' => '.rdg-sports-picks-vs .picks .pick .pick-footer a',
                'fontWeight' => '600',
            ],
        ];
    }
}

$rdg_sports_picks_vs_class = new Rdg_Blocks_Sports_Picks_Vs();
$rdg_sports_picks_vs_class->init();

return $rdg_sports_picks_vs_class;
