<?php
   
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Container extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_CONTAINER;
    private $block_folder_name = BLOCK_RDG_CONTAINER;
    protected $block_title = 'RDG Container';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'container'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;
    protected $is_config = true;
    protected $config_page_title = 'RDG Container';
    protected $config_menu_title = 'Container Block';

    public function init() {
        $this->register_block();
        $this->register_fields();

        add_action('acf/init', [$this, 'registerConfigMenu'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_container.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if (function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_container_form',
                'title' => 'RDG Container Test',
                'fields' => array(
                    array(
                        'key' => 'key_container_name',
                        'label' => 'Name',
                        'name' => 'container_name',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'acfe_save_meta' => 0,
                        'default_value' => '',
                        'required_message' => '',
                        'maxlength' => '',
                        'allow_in_bindings' => 0,
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'key_container_description',
                        'label' => 'Description',
                        'name' => 'container_description',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'acfe_save_meta' => 0,
                        'default_value' => '',
                        'required_message' => '',
                        'maxlength' => '',
                        'allow_in_bindings' => 0,
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-container',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));
        endif;
    }

    public function registerConfigMenu() {
        if (function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_container',
                'title' => 'API configuration',
                'fields' => array(
                    array(
                        'key' => 'key_container_pages',
                        'label' => 'Pages',
                        'name' => 'container_pages',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'acfe_save_meta' => 0,
                        'acfe_repeater_stylised_button' => 0,
                        'layout' => 'table',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'key_container_pages_link',
                                'label' => 'Link',
                                'name' => 'key_container_pages_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'acfe_save_meta' => 0,
                                'return_format' => 'array',
                                'allow_in_bindings' => 0,
                                'parent_repeater' => 'key_container_pages',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-container-block',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getTest() {
        return 'Test';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-container-body-border','slug' => 'color-rdg-container-body-border','color' => '#111111'],
            ['name' => 'color-rdg-container-name','slug' => 'color-rdg-container-name','color' => '#e11414'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-container .description .name',
                'fontSize' => '2rem',
                'fontWeight' => '700',
            ],
            [
                'customSelector' => '.rdg-container .description .bio',
                'fontSize' => '1.2rem',
                'fontWeight' => '600',
            ],
        ];
    }
}

$rdg_container_class = new Rdg_Blocks_Container();
$rdg_container_class->init();

return $rdg_container_class;
