<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    global $post;
    $block_styles = [];
    $block_classes = [];
    $review_valid = explode(',', RDG_BLOCKS_REVIEWS);
    $block_quick_link_sidebar = $rdgb->settings->getBlock(BLOCK_RDG_QUICK_LINKS_SIDEBAR);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    if (in_array($post->post_type, $review_valid)) {
        $fields = get_fields($post->ID);
        $title = (!empty($fields['quick_links_title'])) ? $fields['quick_links_title'] : '';
        $items = (!empty($fields['quick_links_items'])) ? $fields['quick_links_items'] : null;
    }
?>

<?php if (in_array($post->post_type, $review_valid)): ?>
<div class="rdg-blocks">
    <div class="<?php echo BLOCK_RDG_QUICK_LINKS_SIDEBAR; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content <?php echo esc_attr(join(' ', $block_classes)); ?>">
            <?php if (!empty($title)): ?>
                <div class="header">
                    <span class="title"><?php echo $title; ?></span>
                </div>
            <?php endif; ?>
            <div class="body">
                <?php if (is_array($items) && count($items) > 0): ?>
                    <?php foreach($items as $item): ?>
                        <li class="item">
                            <?php if (!empty($item['link'])): ?>
                                <a href="<?php echo $item['link']['url']; ?>" target="<?php echo (!empty($item['link']['target'])) ? $item['link']['target'] : '_self'; ?>">
                            <?php endif; ?>
                                <?php echo $item['text']; ?>
                            <?php if (!empty($item['link'])): ?>
                                </a>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="message">
                        <span><?php echo __('Must add some Items.'); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php else: ?>
    <div class="rdg-blocks">
        <div class="<?php echo BLOCK_RDG_BOOKIE_SUMMARY_SIDEBAR; ?>">
            <?php if ($post->post_type != 'gp_elements'): ?>
                <div class="message danger">
                    <?php echo __('Requires to be used with a custom post type review.'); ?>
                </div>
            <?php else: ?>
                <div class="message info">
                    <?php echo __('Will be generated on page load.'); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
