<?php 
    global $rdgb;
    $block_styles = [];
    $block_classes = [];
    $block_bookie_summary = $rdgb->settings->get_block(BLOCK_RDG_BOOKIE_SUMMARY);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $separator = (!empty(get_field('separator'))) ? get_field('separator') : null;
    $separator_style = $block_bookie_summary->get_style(get_fields(), 'separator');

    $logo_show = (!empty(get_field('logo_show'))) ? get_field('logo_show') : 'hide';
    $bookie_logo = (!empty(get_field('bookie_logo'))) ? get_field('bookie_logo') : null;
    
    $review_show = (!empty(get_field('review_show'))) ? get_field('review_show') : 'hide';
    $review_ranking = (!empty(get_field('ranking'))) ? get_field('ranking') : 0;
    $review_site = (!empty(get_field('site'))) ? get_field('site') : null;
    $review_since = (!empty(get_field('since'))) ? get_field('since') : null;
    $review_description = (!empty(get_field('description'))) ? get_field('description') : null;
    $offers = (!empty(get_field('offers'))) ? get_field('offers') : null;
    
    $payment_show = (!empty(get_field('payment_methods'))) ? get_field('payment_methods') : 'hide';
    $payment_methods = (!empty(get_field('methods'))) ? get_field('methods') : null;
    
    $buttons = (!empty(get_field('buttons'))) ? get_field('buttons') : null;
    $items = null;
?>

<div class="rdg-blocks">
    <div class="<?php echo BLOCK_RDG_BOOKIE_SUMMARY; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content <?php echo esc_attr(join(' ', $block_classes)); ?>">
            <?php if ($logo_show == 'show' && !empty($bookie_logo)): ?>
                <div class="header">
                    <div class="logo">
                        <img src="<?php echo $bookie_logo['url']; ?>" alt="Image">
                    </div>
                    <hr style="<?php echo $separator_style; ?>">
                </div>
            <?php endif; ?>

            <?php if ($review_show == 'show'): ?>
                <div class="bookie">
                    <?php if (!empty($review_ranking)): ?>
                        <div class="stars <?php echo (empty($sub_title)) ? 'ml-0' : ''; ?>">
                            <?php $block_bookie_summary->get_stars($review_ranking); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($review_site) || !empty($review_since) || !empty($review_description)): ?>
                        <div class="site">
                            <?php if (!empty($review_site)): ?>
                                <span class="url"><?php echo $review_site; ?></span>
                            <?php endif; ?>

                            <?php if (!empty($review_since)): ?>
                                <span class="since"><?php echo $review_since; ?></span>
                            <?php endif; ?>

                            <?php if (!empty($review_description)): ?>
                                <span class="description"><?php echo $review_description; ?></span>
                            <?php endif; ?>

                            <?php if (is_array($offers) && count($offers) > 0): ?>
                                <?php $items = $offers; ?>
                                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/buttons.php'; ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php if ($payment_show == 'show' && is_array($payment_methods['images']) && count($payment_methods['images']) > 0): ?>
                <div class="methods">
                    <hr style="<?php echo $separator_style; ?>">
                    <?php if (!empty($payment_methods['title'])): ?>
                        <span class="title"><?php echo $payment_methods['title']; ?></span>
                    <?php endif; ?>
                    <div class="logos">
                        <?php foreach ($payment_methods['images'] as $method): ?>
                            <?php if (!empty($method['method']['url'])): ?>
                                <img src="<?php echo $method['method']['url']; ?>" alt="Image">
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (is_array($buttons) && count($buttons) > 0): ?>
                <hr style="<?php echo $separator_style; ?>">
                <?php $items = $buttons; ?>
                <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/buttons.php'; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
