<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Scores_And_Odds extends Rdg_Blocks_Base implements Rdg_Blocks_Api_Request
{
    protected $block_name = BLOCK_RDG_SCORES_AND_ODDS;
    private $block_folder_name = 'rdg-scores-and-odds';
    protected $block_title = 'RDG Scores and Odds';
    private $block_description = 'This block displays scores and odds for various sports events. The block can display the latest scores, scores for a specific date, or scores within a date range.';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'scores', 'odds'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = true;
    protected $is_config = true;
    protected $is_styles_load = true;
    protected $config_page_title = 'RDG Scores and Odds';
    protected $config_menu_title = 'Scores and Odds';

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_scores_and_odds.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-scores-and-odds.png",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        $sports = (function_exists('shMappingSportsLeaguesOption')) ? shMappingSportsLeaguesOption() : [];

        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group( array(
                'key' => 'group_67aa45208181a',
                'title' => 'scores and odds',
                'fields' => array(
                    array(
                        'key' => 'field_67aa4522723f7',
                        'label' => 'Block Type',
                        'name' => 'block_type',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'api' => 'API',
                            'manual' => 'Manual',
                        ),
                        'default_value' => '',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'allow_in_bindings' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_67aa4528723f8',
                        'label' => 'Manual',
                        'name' => 'manual',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67aa4522723f7',
                                    'operator' => '==',
                                    'value' => 'manual',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'acfe_repeater_stylised_button' => 0,
                        'layout' => 'row',
                        'pagination' => 0,
                        'min' => 1,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_67aa4c06723f9',
                                'label' => 'Team A',
                                'name' => 'team_a',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4cb772406',
                                'label' => 'Img Team A',
                                'name' => 'img_team_a',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'uploader' => '',
                                'return_format' => 'array',
                                'library' => 'all',
                                'upload_folder' => '',
                                'acfe_thumbnail' => 0,
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'allow_in_bindings' => 0,
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c0f723fa',
                                'label' => 'Team B',
                                'name' => 'team_b',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4cd272407',
                                'label' => 'Img Team B',
                                'name' => 'img_team_b',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'uploader' => '',
                                'return_format' => 'array',
                                'library' => 'all',
                                'upload_folder' => '',
                                'acfe_thumbnail' => 0,
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'allow_in_bindings' => 0,
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c51723fb',
                                'label' => 'Game Part',
                                'name' => 'game_part',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c57723fc',
                                'label' => 'Date',
                                'name' => 'date',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c5b723fd',
                                'label' => 'Hour',
                                'name' => 'hour',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c68723fe',
                                'label' => 'Score A',
                                'name' => 'score_a',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c70723ff',
                                'label' => 'Score B',
                                'name' => 'score_b',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c7872400',
                                'label' => 'Spread A',
                                'name' => 'spread_a',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c7d72401',
                                'label' => 'Spread B',
                                'name' => 'spread_b',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c8872402',
                                'label' => 'Total A',
                                'name' => 'total_a',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c8d72403',
                                'label' => 'Total B',
                                'name' => 'total_b',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c9672404',
                                'label' => 'Moneyline A',
                                'name' => 'moneyline_a',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4c9b72405',
                                'label' => 'Moneyline B',
                                'name' => 'moneyline_b',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa4cdd72408',
                                'label' => 'Previews',
                                'name' => 'previews',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'allow_in_bindings' => 0,
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                            array(
                                'key' => 'field_67aa504f72409',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'allow_in_bindings' => 0,
                                'parent_repeater' => 'field_67aa4528723f8',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_67aa50667240a',
                        'label' => 'Quantity',
                        'name' => 'number_of_items',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67aa4522723f7',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => '',
                        'max' => '',
                        'allow_in_bindings' => 0,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_67aa508f7240b',
                        'label' => 'Date Type',
                        'name' => 'date_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67aa4522723f7',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'latest' => 'Latest',
                            'specific' => 'Specific Date',
                            'range' => 'Range',
                        ),
                        'default_value' => 'latest',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'max' => '',
                        'prepend' => '',
                        'append' => '',
                        'allow_null' => 0,
                        'allow_in_bindings' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                        'allow_custom' => 0,
                        'search_placeholder' => '',
                        'min' => '',
                    ),
                    array(
                        'key' => 'field_67aa50d77240c',
                        'label' => 'From day',
                        'name' => 'from_day',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67aa508f7240b',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                        'placeholder' => '',
                        'min_date' => '',
                        'max_date' => '',
                        'no_weekends' => 0,
                        'allow_in_bindings' => 0,
                    ),
                    array(
                        'key' => 'field_67aa51327240d',
                        'label' => 'To day',
                        'name' => 'to_day',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67aa508f7240b',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                        'placeholder' => '',
                        'min_date' => '',
                        'max_date' => '',
                        'no_weekends' => 0,
                        'allow_in_bindings' => 0,
                    ),
                    array(
                        'key' => 'field_67aa51677240e',
                        'label' => 'Specific Date',
                        'name' => 'specific_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67aa508f7240b',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                        'placeholder' => '',
                        'min_date' => '',
                        'max_date' => '',
                        'no_weekends' => 0,
                        'allow_in_bindings' => 0,
                    ),
                    array(
                        'key' => 'field_67b212f4d36fe',
                        'label' => 'Sports',
                        'name' => 'sports',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67aa4522723f7',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => [0 => 'Choose an option'] + $sports,
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'max' => '',
                        'prepend' => '',
                        'append' => '',
                        'allow_null' => 0,
                        'allow_in_bindings' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                        'allow_custom' => 0,
                        'search_placeholder' => '',
                        'min' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-scores-and-odds',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'left',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
                'acfe_autosync' => '',
                'acfe_form' => 0,
                'acfe_display_title' => '',
                'acfe_meta' => '',
                'acfe_note' => '',
            ) );   
        endif;
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_scores_and_odds_block_sdfw34fs2332',
                'title' => 'API configuration',
                'fields' => array(
                    array(
                        'key' => 'key_scores_and_odds_api_url',
                        'label' => 'URL',
                        'name' => 'scores_and_odds_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'key_scores_and_odds_api_token',
                        'label' => 'Token',
                        'name' => 'scores_and_odds_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'key_scores_and_odds_interval',
                        'label' => 'Cache Refresh Frequency (Hours)',
                        'name' => 'scores_and_odds_interval',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-scores-and-odds',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getApiAttributes($items = null, $attributes = []) {
        $api_url = get_field('scores_and_odds_api_url', 'option');
        $api_token = get_field('scores_and_odds_api_token', 'option');
        $cache_refresh = get_field('scores_and_odds_interval', 'option');
        $items = (!empty($items)) ? intval($items) : 10;

        $api_url = (substr($api_url, -1) == '/') ? substr($api_url, 0, strlen($api_url) -1) : $api_url;
        $api_url .= '?recordsQty='.$items;
        
        if ($attributes['date_type'] == 'specific') {
            $api_url .= '&principalDate=' .$attributes['specific'];
        } else if ($attributes['date_type'] == 'latest') {
            $api_url .= '&principalDate='. date("Y-m-d");
        } else {
            $api_url .= '&principalDate='.$attributes['from_day']. '&secondaryDate='.$attributes['to_day'];
        }

        $sports = null;
        $league = null;

        if (isset($attributes['sports']) && strpos($attributes['sports'], '-')) {
            list($sports, $league) = explode('-', $attributes['sports']);
            $league = shMappingSportsConverter([$sports => [$league]], 'members');
        } else {
            if (isset($attributes['sports']) && !empty($attributes['sports'])) {
                $sports = $attributes['sports'];
                $sports = shMappingSportsConverter([$sports => ""], 'members');
            }
        }

        if (!empty($league)) {
            $api_url .= '&leagues_hierarchy='.$league;
        } else if (!empty($sports)) {
            $api_url .= '&sports_hierarchy='.$sports;
        }

        $api_request = $api_url.'&api_token='.$api_token; 

        error_log(print_r($api_request, true));

        return [
            'items' => $items,
            'method' => 'GET',
            'cache_refresh' => $cache_refresh,
            'headers' => ['Accept: application/json'],
            'request' => $api_request,
        ];
    }

    public function getApiParams() {
        return [
            'date_type' => 'date_type',
            '_to_transform_' => [
                [
                    'key' => 'from_day',
                    'function' => 'formatDate',
                    'params' => ['from_day'],
                ],[
                    'key' => 'to_day',
                    'function' => 'formatDate',
                    'params' => ['to_day'],
                ],[
                    'key' => 'specific',
                    'function' => 'formatDate',
                    'params' => ['specific_date'],
                ],
            ]
        ];
    }

    public function formatDate($date) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
    
        return $rdgb_helpers->getValidDate($date);
    }

    public function getResources($request, $cache_file) {
        $data = new StdClass();
        $data->json = '';
        $data->message = '';

        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $scores_and_odds = $rdgb_helpers->getApiData($this->block_name, $cache_file, $request);

        if (!empty($scores_and_odds->message)) {
            $data->message = $scores_and_odds->message;
        
            return $data;
        }

        $data->json = $scores_and_odds->json;

        return $data;
    }

    public function getFieldsValidate() {
        return [
            'visitor_team' => ['required', 'notnull'],
            'home_team' => ['required', 'notnull'],
            'game_date' => ['required', 'notnull'],
            'visitor_image' => ['required', 'notnull'],
            'home_image' => ['required', 'notnull'],
        ];
    }

    public function get_image($url_image, $attributes = []) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $url_image = $rdgb_helpers->getImageSource($url_image, $attributes);

        return $url_image;
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => '--color-scores-and-odds-p','slug' => '--color-scores-and-odds-p','color' => '#67748e'],
            ['name' => '--color-scores-and-odds-wrapper-bg','slug' => '--color-scores-and-odds-wrapper-bg','color' => '#fff'],
            ['name' => '--color-scores-and-odds-header-bg','slug' => '--color-scores-and-odds-header-bg','color' => '#1c4579'],
            ['name' => '--color-scores-and-odds-header-p','slug' => '--color-scores-and-odds-header-p','color' => '#fff'],
            ['name' => '--color-scores-and-odds-black','slug' => '--color-scores-and-odds-black','color' => '#000'],
            ['name' => '--color-scores-and-odds-border','slug' => '--color-scores-and-odds-border','color' => '#E6EBF2'],
            ['name' => '--color-scores-and-odds-prev-border','slug' => '--color-scores-and-odds-prev-border','color' => '#1c4579'],
            ['name' => '--color-scores-and-odds-prev-bg','slug' => '--color-scores-and-odds-prev-bg','color' => '#fff'],
            ['name' => '--color-scores-and-odds-prev-p','slug' => '--color-scores-and-odds-prev-p','color' => '#1c4579'],
            ['name' => '--color-scores-and-odds-prev-border-hover','slug' => '--color-scores-and-odds-prev-border-hover','color' => '#1c4579'],
            ['name' => '--color-scores-and-odds-prev-bg-hover','slug' => '--color-scores-and-odds-prev-bg-hover','color' => '#1c4579'],
            ['name' => '--color-scores-and-odds-prev-p-hover','slug' => '--color-scores-and-odds-prev-p-hover','color' => '#fff'],
            ['name' => '--color-scores-and-odds-pick-border','slug' => '--color-scores-and-odds-pick-border','color' => '#1c4579'],
            ['name' => '--color-scores-and-odds-pick-bg','slug' => '--color-scores-and-odds-pick-bg','color' => '#1c4579'],
            ['name' => '--color-scores-and-odds-pick-p','slug' => '--color-scores-and-odds-pick-p','color' => '#fff'],
            ['name' => '--color-scores-and-odds-pick-border-hover','slug' => '--color-scores-and-odds-pick-border-hover','color' => '#0160ac'],
            ['name' => '--color-scores-and-odds-pick-bg-hover','slug' => '--color-scores-and-odds-pick-bg-hover','color' => '#0160ac'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-scores-and-odds .sao-container .sao-wrapper .header p ',
                'fontWeight' =>'700',
            ],
        ];
    }
}

$rdg_scores_and_odds_class = new Rdg_Blocks_Scores_And_Odds();
$rdg_scores_and_odds_class->init();

return $rdg_scores_and_odds_class;