<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_TOP_CAPPERS_SPORT;
    $block_classes = [$block_name];
    $block_top_cappers_sport = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $primary_capper = 0;
    $titles = get_field('titles');
    $title = (!empty(get_field('title'))) ? get_field('title') : '';
    $cappers = (!empty(get_field('cappers'))) ? get_field('cappers') : [];
    $source = get_field('source');
    $display_block = (!empty(get_field('display_block'))) ? get_field('display_block') : 'full-width';
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    $sport = (!empty(get_field('sport'))) ? get_field('sport') : '';
    $days = (!empty(get_field('days'))) ? get_field('days') : 30;
    $sports = (function_exists('shMappingSportsConverter')) ? shMappingSportsConverter(["$sport" => "$sport"], 'members') : [];

    $cache_file = null;
    $api_attributes = null;
    if ($source == 'api' && $block_top_cappers_sport->isCaching()) {
        $api_url = get_field('top_cappers_sport_api_url', 'option');
        $api_token = get_field('top_cappers_sport_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_top_cappers_sport->getApiAttributes($items, ['sport' => $sports, 'days' => $days]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
            $response = $block_top_cappers_sport->getResources($api_attributes, $cache_file);

            if (empty($response->message) && is_array($response->json)) {
                $cappers = $response->json;
            } else {
                $cappers = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <?php
        $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
        $block_top_cappers_sport->getLogDebug($params);
    ?>
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?> <?php echo $display_block; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (is_array($cappers) && count($cappers) > 0): ?>
                <?php
                    if ($source == 'api') {
                        require 'partials/api.php';
                    } else {
                        require 'partials/manual.php';
                    }
                ?>
            <?php else: ?>
                <?php if (!empty($message)): ?>
                    <span class="message"><?php echo $message; ?></span>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
