<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Secondary_Banner extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_SECONDARY_BANNER;
    private $block_folder_name = 'rdg-secondary-banner';
    protected $block_title = 'RDG Secondary Banner';
    private $block_description = 'The block is a horizontal banner with the options to edit the text description, introduce an image, and add a button';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'banner', 'secondary', 'secondary banner'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_secondary_banner.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-secundary-banner-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group(array(
                'key' => 'group_64301c352d848',
                'title' => 'Secondary Banner',
                'fields' => array(
                    array(
                        'key' => 'field_64301c485aecc',
                        'label' => 'Description',
                        'name' => 'description',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 0,
                        'delay' => 0,
                    ),
                    array(
                        'key' => 'field_image_description',
                        'label' => 'Image',
                        'name' => 'image_description',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'url',
                        'preview_size' => 'medium',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                    ),
                    array(
                        'key' => 'field_64301c8f5aece',
                        'label' => 'Show Image on Mobile',
                        'name' => 'show_image_mobile',
                        'aria-label' => '',
                        'type' => 'true_false',
                        'instructions' => 'Check this box to display the image on mobile devices.',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'message' => 'Show on Mobile',
                        'ui' => 1,
                        'ui_on_text' => 'Yes',
                        'ui_off_text' => 'No',
                    ),
                    array(
                        'key' => 'field_64301c725aecd',
                        'label' => 'Link Btn',
                        'name' => 'link_btn',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64301c7e5aece',
                        'label' => 'Text Btn',
                        'name' => 'text_btn',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64301d7a5b0ef',
                        'label' => 'Link Attributes',
                        'name' => 'link_attributes',
                        'aria-label' => '',
                        'type' => 'checkbox',
                        'instructions' => 'Select the attributes to add to the link.',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'choices' => array(
                            'nofollow' => 'nofollow',
                            'noopener' => 'noopener',
                            'noreferrer' => 'noreferrer',
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => array(),
                        'layout' => 'vertical',
                    ),
                    array(
                        'key' => 'field_64301f3255aed',
                        'label' => 'Background',
                        'name' => 'background',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-secondary-banner',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
       
            endif;		
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-secondary-banner-bg','slug' => 'color-rdg-secondary-banner-bg','color' => '#F1F1F1'],
            ['name' => 'color-rdg-secondary-banner-left-bg','slug' => 'color-rdg-secondary-banner-left-bg','color' => '#0160ac'],
            ['name' => 'color-rdg-secondary-banner-left','slug' => 'color-rdg-secondary-banner-left','color' => '#FFFFFF'],
            ['name' => 'color-rdg-secondary-banner-right-link','slug' => 'color-rdg-secondary-banner-right-link','color' => '#FFFFFF'],
            ['name' => 'color-rdg-secondary-banner-right-link-bg','slug' => 'color-rdg-secondary-banner-right-link-bg','color' => '#00bc00'],
            ['name' => 'color-rdg-secondary-banner-right-link-bg-hover','slug' => 'color-rdg-secondary-banner--right-link-bg-hover','color' => '#68f96e'],
            ['name' => 'color-rdg-secondary-banner-right-link-border-top','slug' => 'color-rdg-secondary-banner-right-link-border-top','color' => '#244d0e'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-secondary-banner .right a',
                'fontWeight' => '700',
                'textDecoration' => 'none',
            ],
            [
                'customSelector' => '.rdg-secondary-banner .left',
                'fontWeight' => '600',
            ],
        ];
    }
}

$rdg_secondary_banner_class = new Rdg_Blocks_Secondary_Banner ();
$rdg_secondary_banner_class->init();

return $rdg_secondary_banner_class;
