<?php
if (isset($block['data']['isExample']) && $block['data']['isExample']) {
    echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
    return;
}
global $rdgb;
$rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

$block_styles = [];
$block_classes = ['rdg-team-schedules'];
$block_team_schedules = $rdgb->settings->getBlock(BLOCK_RDG_TEAM_SCHEDULES);

if (!empty($block['backgroundColor'])) {
    $block_classes[] = 'has-background';
    $block_classes[] = 'has-' . $block['backgroundColor'] . '-background-color';
}

if (!empty($block['style']['color']['background'])) {
    $block_styles[] = 'background-color: ' . $block['style']['color']['background'] . ';';
}

$titles = get_field('titles');
$position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

$data = $block_team_schedules->get_data();
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>"
         style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR . 'partials/titles.php'; ?>

            <?php if ($data['error'] && is_user_logged_in() && current_user_can('administrator')): ?>
                <h2>Fatal Error:</h2>
                <pre><?php echo $data['error']; ?></pre>
            <?php elseif (is_array($data['schedulesByType']) && count($data['schedulesByType'])): ?>
                <?php foreach ($data['schedulesByType'] as $key => $schedules): ?>
                    <h2 class="title"><?php echo str_replace('-', ' ', $key); ?></h2>
                    <table>
                        <thead>
                        <tr>
                            <th>Week</th>
                            <th>Date</th>
                            <th>Opponent</th>
                            <th>Result</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($schedules as $schedule): ?>
                            <tr>
                                <td class="type">
                                    <?php echo $schedule['type']; ?>
                                </td>
                                <td class="data">
                                    <span>Date:</span>
                                    <?php echo $schedule['date']; ?>
                                </td>
                                <td class="data">
                                    <span>Opponent:</span>
                                    <?php echo $schedule['opponent']; ?>
                                </td>
                                <td class="data">
                                    <span>Result:</span>
                                    <?php echo $schedule['result']; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endforeach; ?>
            <?php elseif (!$data['parameters']['teamId'] || !$data['parameters']['seasonId']): ?>
                <p>Please complete the block form.</p>
            <?php elseif (null === $data['schedulesByType']): ?>
                <p>The selected sport does not have a schedule mapper configured.</p>
            <?php elseif (is_array($data['schedulesByType'])): ?>
                <p>No schedules found.</p>
            <?php else: ?>
                <p>Error.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
if ('active' === get_field('rdg_blocks_debug_cache', 'option') || 'active' === get_field('rdg_blocks_debug_request', 'option')) {
    if (is_user_logged_in() && current_user_can('administrator')) {
        echo "<!--\n";
        echo "==================================================================================================================\n";
        echo "--------------------------------------------Debug Team schedules block--------------------------------------------\n";
        echo "==================================================================================================================\n";
        echo $data['log'] . "\n";
        echo "==================================================================================================================\n";
        echo "-->";
    }
}
?>
