<?php foreach($picks as $pick):?>
    <div class="pick">
        <div class="pick-header">
            <div class="title">
                <span class="header-title"><?php echo $pick['home_team']; ?> vs <?php echo $pick['visitor_team']; ?></span>
            </div>
        </div>
        <div class="pick-body">
            <div class="teams">
                <div class="team team-a">
                    <div class="team-logo">
                        <?php
                            $pick_image = $block_sports_picks_vs->get_image($pick['home_image'], [
                                'image_type' => 'sport_pick_vs',
                                'image_alt' => $pick['home_team'],
                                'logo_label' => true,
                            ]);
                        ?>
                        <?php if (isset($pick['home_image']) && $pick['home_image'] != ''): ?>
                            <img src="<?php echo $pick_image['url']; ?>" alt="<?php echo $pick_image['alt']; ?>">
                        <?php endif; ?>
                    </div>
                </div>

                <div class="team team-vs">
                    <div class="vs-logo"><span>vs</span></div>
                </div>

                <div class="team team-b">
                    <div class="team-logo">
                        <?php
                            $pick_image_visitor = $block_sports_picks_vs->get_image($pick['visitor_image'], [
                                'image_type' => 'sport_pick_vs',
                                'image_alt' => $pick['visitor_team'],
                                'logo_label' => true,
                            ]);
                        ?>
                        <?php if (isset($pick['visitor_image']) && $pick['visitor_image'] != ''): ?>
                            <img src="<?php echo $pick_image_visitor['url']; ?>" alt="<?php echo $pick_image_visitor['alt']; ?>">
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="fields">
                <div class="field separator">
                    <div class="team-home"><?php echo $pick['home_team']; ?></div>
                    <div class="leyend"><?php echo _('ODDS'); ?></div>
                    <div class="team-visitor"><?php echo $pick['visitor_team']; ?></div>
                </div>

                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick['opener_game_odds'][0]['spread_home_odds'])) ? $pick['opener_game_odds'][0]['spread_home_odds'] : '-'; ?></div>
                    <div class="leyend"><?php echo _('OPENER'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick['opener_game_odds'][0]['spread_visitor_odds'])) ? $pick['opener_game_odds'][0]['spread_visitor_odds'] : '-'; ?></div>
                </div>

                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick['current_game_odds'][0]['spread_home_odds'])) ? $pick['current_game_odds'][0]['spread_home_odds'] : '-'; ?></div>
                    <div class="leyend"><?php echo _('CURRENT'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick['current_game_odds'][0]['spread_visitor_odds'])) ? $pick['current_game_odds'][0]['spread_visitor_odds'] : '-'; ?></div>
                </div>
            
                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick['current_game_odds'][0]['money_line_home_odds'])) ? $pick['current_game_odds'][0]['money_line_home_odds'] : '-'; ?></div>
                    <div class="leyend"><?php echo _('MONEYLINE'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick['current_game_odds'][0]['money_line_visitor_odds'])) ? $pick['current_game_odds'][0]['money_line_visitor_odds'] : '-'; ?></div>
                </div>
            </div>

            <?php if (!empty($pick['game_picks_count']) && intval($pick['game_picks_count']) > 0): ?>
                <div class="picks-available">
                    <?php if (!empty($picks_link['url'])): ?>
                        <?php
                            $link_url = (!empty($picks_link['url'])) ? $picks_link['url'] : '#';
                            $link_target = (!empty($picks_link['target'])) ? $picks_link['target'] : '_self';
                        ?>
                        <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                    <?php endif; ?>

                    <span><?php echo $pick['game_picks_count']; ?> PICKS AVAILABLE</span>

                    <?php if (!empty($picks_link['url'])): ?>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif ?>
        </div>

        <div class="pick-footer">
            <?php if (!empty($link)): ?>
                <a href="<?php echo $link['url']; ?>" target="<?php echo (empty($link['target'])) ? '_self' : $link['target']; ?>"><?php echo $link['title']; ?></a>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>