<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_HEADING_PARAGRAPH];
    $block_heading_paragraph = $rdgb->settings->getBlock(BLOCK_RDG_HEADING_PARAGRAPH);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $content = (!empty(get_field('content'))) ? get_field('content') : null;
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/heading.php'; ?>

            <?php if (!empty($content)): ?>
                <div class="body">
                    <?php echo $content; ?>
                </div>
            <?php else: ?>
                <div class="message">
                    <span><?php echo __('Must add some content.'); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
