
<?php   
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_PICKS_VS_MULTI;
    $block_classes = [$block_name];
    $block_picks_vs_multi = $rdgb->settings->getBlock($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $source = get_field('source');
    $sports = (!empty(get_field('sports'))) ? get_field('sports') : '';

    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : null;
    $since_date = (!empty(get_field('since_date'))) ? get_field('since_date') : null;
    $to_date = (!empty(get_field('to_date'))) ? get_field('to_date') : null;
    $date_ranges = (!empty(get_field('date_range'))) ? get_field('date_range') : [];
  
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $date_request = $block_picks_vs_multi->get_date_filter($date_type, $since_date, $to_date);

    $cache_file = null;
    $api_attributes = null;
    $post_id = get_the_ID();
    $picks = [];

    if ($source == 'api' && $block_picks_vs_multi->isCaching()) {
        $api_url = get_field('picks_vs_multi_api_url', 'option');
        $api_token = get_field('picks_vs_multi_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_picks_vs_multi->getApiAttributes($items, ['sports' => $sports, 'date' => $date_request]);

            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->getCacheName($block_name, $post_id_custom, $block_custom_id);
            $response = $block_picks_vs_multi->getResources($api_attributes, $cache_file);

            if (empty($response->message) && is_array($response->json)) {
                $picks = $response->json;
            } else {
                $picks = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
    
?>
<div class="rdg-blocks">
        <?php
            $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
            $block_picks_vs_multi->getLogDebug($params);
        ?>
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
            <div class="pvm-container">
                <?php
                    if ($source == 'api') {
                        require 'partials/api.php';
                    } else {
                        require 'partials/manual.php';
                    }
                ?>
        </div>
    </div>
</div>
