<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_POSTS_LIST];
    $block_posts_list = $rdgb->settings->getBlock(BLOCK_RDG_POSTS_LIST);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $show = get_field('show');
    $titles = get_field('titles');
    $display = (empty(get_field('display')) || get_field('display') == 'default') ? '' : 'flex';

    $elements = $block_posts_list->get_elements_type(get_fields());
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <div class="body">
            <?php if (is_array($elements) && count($elements) > 0): ?>
                <div class="items <?php echo $display; ?>">
                    <?php foreach($elements as $element): ?>
                        <div class="item">
                            <?php
                                $image = '';
                                if ($element instanceof WP_Post) {
                                    $image = $block_posts_list->get_image($element->ID);
                                } else {
                                    if (isset($element['image']['url']) && !empty($element['image']['url'])) {
                                        $image = $element['image']['url'];
                                    }
                                }
                            ?>
                            
                                <?php
                                    $link_url = '';
                                    $link_target = '_self';
                                    $link_name = 'Read more';
                                    if ($element instanceof WP_Post) {
                                        $link_url = get_permalink($element);
                                    } else {
                                        if (isset($element['link_post']['url']) && !empty($element['link_post']['url'])) {
                                            $link_url = $element['link_post']['url'];
                                        }

                                        if (isset($element['link_post']['target']) && !empty($element['link_post']['target'])) {
                                            $link_target = $element['link_post']['target'];
                                        }

                                        if (isset($element['link_post']['title']) && !empty($element['link_post']['title'])) {
                                            $link_name = $element['link_post']['title'];
                                        }
                                    } 
                                ?>
                                <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                                    <div class="image" style="background-image: url(<?php echo $image; ?>);"></div>
                                </a>
                            
                            <footer>
                                <div class="footer-title">
                                    <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                                        <?php echo (!empty($element->post_title)) ? $element->post_title : $element['title']; ?>
                                    </a>
                                </div>
                                <div class="header">
                                    <div class="date">
                                        <?php
                                            $author_name = '';
                                            $date = (!empty($element->post_date)) ? $element->post_date : $element['date'];

                                            if (isset($element->post_author)) {
                                                $author_name = get_the_author_meta('display_name', $element->post_author);
                                            }

                                            try {
                                                $d = DateTime::createFromFormat('Y-m-d H:i:s', $date);
                                                $date_status = $d && $d->format('Y-m-d H:i:s') == $date;

                                                if ($date_status) {
                                                    $month = $d->format('F');
                                                    $more_date = $d->format('j, Y');
                                                    $date = $month.' '.$more_date;
                                                }
                                            } catch (\Exception $exception) {
                                                //
                                            }
                                        ?>

                                        <span>
                                            <?php echo __('By', 'rdg-blocks-posts-list'); ?>
                                            <?php echo $author_name; ?>
                                            <?php if (isset($month) && !empty($month)): ?>
                                                | <?php echo __($month, 'rdg-blocks-months'); ?>
                                                <?php echo $more_date; ?>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                                <?php
                                    $excerpt = '';
                                    if ($element instanceof WP_Post) {
                                        if (!empty($element->post_excerpt)) {
                                            $excerpt = $element->post_excerpt;
                                        } else {
                                            $excerpt = $element->post_content;
                                        }
                                    } else {
                                        if (isset($element['content']) && !empty($element['content'])) {
                                            $excerpt = $element['content'];
                                        }
                                    }
                                ?>
                                <?php if (!empty($excerpt)): ?>
                                    <div class="footer-description">
                                        <?php echo wp_trim_words($excerpt, 35, false); ?>
                                    </div>
                                <?php endif; ?>
                            </footer>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
