<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_SH_YOUTUBE_VIDEO];
    $block_rdg_sh_youtube_video = $rdgb->settings->getBlock(BLOCK_RDG_SH_YOUTUBE_VIDEO);


    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());    
    $videos = (is_array(get_field('sh_youtube_video_videos')) && count(get_field('sh_youtube_video_videos')) > 0) ? get_field('sh_youtube_video_videos') : [];
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php if (count($videos) > 0): ?>
                <div class="videos">
                    <?php foreach ($videos as $video): ?>
                        <div class="video" style="width: <?php echo (isset($video['sh_youtube_video_width']) && !empty($video['sh_youtube_video_width'])) ? esc_attr($video['sh_youtube_video_width']).'%' : '100%'; ?>;">
                            <?php if (isset($video['sh_youtube_video_url']) && !empty($video['sh_youtube_video_url'])): ?>
                                <div class="lazyframe" data-src="<?php echo htmlspecialchars($video['sh_youtube_video_url'], ENT_QUOTES, 'UTF-8'); ?>" data-vendor="youtube" 
                                    <?php if (isset($video['place_holder_image']) && !empty($video['place_holder_image']['url'])): ?>
                                        data-thumbnail="<?php echo htmlspecialchars($video['place_holder_image']['url'], ENT_QUOTES, 'UTF-8'); ?>"
                                    <?php endif; ?>                                    
                                ></div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
