<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_LOGO_RANKING;
    $block_classes = [$block_name];
    $block_logo_ranking = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $logo = (!empty(get_field('logo'))) ? get_field('logo') : null;
    $trophy = (!empty(get_field('trophy'))) ? get_field('trophy') : null;
    $ranking = (!empty(get_field('title'))) ? get_field('title') : null;
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <?php if (!empty($logo)): ?>
            <div class="logo">
                <img src="<?php echo $logo['url']; ?>" alt="Image">
            </div>
        <?php endif; ?>
        <?php if (!empty($trophy) || !empty($ranking)): ?>
            <div class="footer">
                <?php if (!empty($trophy)): ?>
                    <div class="trophy<?php echo $block_logo_ranking->get_width('trophy', $trophy, $ranking); ?>">
                        <img src="<?php echo $trophy['url']; ?>" alt="Image">
                    </div>
                <?php endif; ?>
                <?php if (!empty($ranking)): ?>
                    <div class="title<?php echo $block_logo_ranking->get_width('ranking', $trophy, $ranking); ?>">
                        <span><?php echo $ranking; ?></span>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
