<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Bookie_Summary_Sidebar extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_BOOKIE_SUMMARY_SIDEBAR;
    private $block_folder_name = 'rdg-bookie-summary-sidebar';
    protected $block_title = 'RDG Bookie Summary Sidebar';
    private $block_description = 'This block is a template structure for create sidebars in Elements section on Wordpress Appearance, it work with GeneratePress and the info included in it is added for each specific page where it is used';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'bookie', 'summary', 'sidebar'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_bookie_summary_sidebar.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-bookie-summary-sidebar-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_stars(float $stars) {
        $fills = intval($stars);
        $half = ($stars - $fills == 0) ? 0 : 1;
        $emptys = 5 - $fills - $half;

        for ($i = 0; $i < $fills; $i++) {
            echo '<span class="star star-fill"></span>';
        }

        if ($half > 0) {
            echo '<span class="star star-half"></span>';
        }

        for ($i = 0; $i < $emptys; $i++) {
            echo '<span class="star star-empty"></span>';
        }
    }

    public function get_style($fields, $type) {
        $style = [];

        if ($type == 'separator') {
            $style[] = (is_array($fields) && !empty($fields['border'])) 
                ? '--separator-border:'.intval($fields['border']).'px' 
                : '--separator-border:1px';
            $style[] = (is_array($fields) && !empty($fields['margin'])) 
                ? '--separator-margin:'.intval($fields['margin']).'rem' 
                : '--separator-margin:1rem';
            $style[] = (is_array($fields) && !empty($fields['color'])) 
                ? '--separator-color:'.$fields['color'] 
                : '--separator-color:#CCC';

            return implode('; ',$style).';';
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-bookie-summary-sidebar-url','slug' => 'color-bookie-summary-sidebar-url','color' => '#111111'],
            ['name' => 'color-bookie-summary-sidebar-since','slug' => 'color-bookie-summary-sidebar-since','color' => '#7F8C8D'],
            ['name' => 'color-bookie-summary-sidebar-description','slug' => 'color-bookie-summary-sidebar-description','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-bookie-summary-sidebar .content .site .url',
                'fontWeight' => '700',
                'fontSize' => '1.43rem',
            ],
            [
                'customSelector' => '.rdg-bookie-summary-sidebar .content .site .since',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-bookie-summary-sidebar .content .site .description',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-bookie-summary-sidebar .content .methods .title',
                'fontWeight' => '700',
                'fontSize' => '1rem',
                'fontSizeTablet' => '0.8rem',
            ],
        ];
    }
}

$rdg_bookie_sumary_sidebar_class = new Rdg_Blocks_Bookie_Summary_Sidebar();
$rdg_bookie_sumary_sidebar_class->init();

return $rdg_bookie_sumary_sidebar_class;
