<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Cpt_List extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_CPT_LIST;
    private $block_folder_name = 'rdg-cpt-list';
    protected $block_title = 'RDG Custom Post Type List';
    private $block_description = 'This block structure and show custom post type lists of pages, post, blog and others, the block allow customize quantity, title and block spaces';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'cpt', 'post', 'type', 'list'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_64df7c1a36532',
                'title' => 'RDG Custom Post Type List Block',
                'fields' => array(
                    array(
                        'key' => 'field_64df7c1aa362c',
                        'label' => 'Custom Post Type',
                        'name' => 'cpt_custom_post_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => $this->get_post_types_list(),
                        'default_value' => 'blog',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64df7d5ea7379',
                        'label' => 'Show Blog',
                        'name' => 'cpt_blog_show',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64df7c1aa362c',
                                    'operator' => '==',
                                    'value' => 'blog',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'latest' => 'Latest Posts',
                            'specific' => 'Specific Posts',
                        ),
                        'default_value' => 'latest',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64df7e792fbbf',
                        'label' => 'Select Category Type',
                        'name' => 'cpt_blog_select_category_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64df7d5ea7379',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'include' => 'Include Category',
                            'exclude' => 'Exclude Category',
                        ),
                        'default_value' => 'include',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64df7f48a197a',
                        'label' => 'Category Include',
                        'name' => 'cpt_blog_category_include',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64df7e792fbbf',
                                    'operator' => '==',
                                    'value' => 'include',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'blog-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64df8020a197b',
                        'label' => 'Category Exclude',
                        'name' => 'cpt_blog_category_exclude',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64df7e792fbbf',
                                    'operator' => '==',
                                    'value' => 'exclude',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'blog-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64df80ddb8d17',
                        'label' => 'Blogs',
                        'name' => 'cpt_blog_specific',
                        'aria-label' => '',
                        'type' => 'relationship',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64df7d5ea7379',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'post_type' => array(
                            0 => 'blog',
                        ),
                        'post_status' => array(
                            0 => 'publish',
                        ),
                        'taxonomy' => '',
                        'filters' => array(
                            0 => 'search',
                            1 => 'taxonomy',
                        ),
                        'return_format' => 'object',
                        'min' => '',
                        'max' => '',
                        'elements' => array(
                            0 => 'featured_image',
                        ),
                    ),
                    array(
                        'key' => 'field_64dfa8e0d40fb',
                        'label' => 'Show News',
                        'name' => 'cpt_news_show',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64df7c1aa362c',
                                    'operator' => '==',
                                    'value' => 'gambling-news',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'latest' => 'Latest Posts',
                            'specific' => 'Specific Posts',
                        ),
                        'default_value' => 'latest',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64dfa8e9d40fc',
                        'label' => 'Select Category Type',
                        'name' => 'cpt_news_select_category_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64dfa8e0d40fb',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'include' => 'Include Category',
                            'exclude' => 'Exclude Category',
                        ),
                        'default_value' => 'include',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64dfa8f3d40fd',
                        'label' => 'Category Include',
                        'name' => 'cpt_news_category_include',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64dfa8e9d40fc',
                                    'operator' => '==',
                                    'value' => 'include',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'news-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64dfa8fad40fe',
                        'label' => 'Category Exclude',
                        'name' => 'cpt_news_category_exclude',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64dfa8e9d40fc',
                                    'operator' => '==',
                                    'value' => 'exclude',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'news-category',
                        'add_term' => 0,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_64dfa903d40ff',
                        'label' => 'News',
                        'name' => 'cpt_news_specific',
                        'aria-label' => '',
                        'type' => 'relationship',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64dfa8e0d40fb',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'post_type' => array(
                            0 => 'gambling-news',
                        ),
                        'post_status' => array(
                            0 => 'publish',
                        ),
                        'taxonomy' => '',
                        'filters' => array(
                            0 => 'search',
                            1 => 'taxonomy',
                        ),
                        'return_format' => 'object',
                        'min' => '',
                        'max' => '',
                        'elements' => array(
                            0 => 'featured_image',
                        ),
                    ),
                    array(
                        'key' => 'field_64df81e831d11',
                        'label' => 'Quantity',
                        'name' => 'cpt_quantity',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 100,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64e5f345543f435',
                        'label' => 'Max Categories',
                        'name' => 'cpt_max_categories',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 10,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-cpt-list',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_post_types_list() {
        $args = array('public' => true);
        
        $all_post_types = get_post_types($args, 'objects');
        $post_types_array = array();
        foreach ($all_post_types as $post_type_slug => $post_type_obj) {
          $post_types_array[$post_type_slug] = $post_type_obj->labels->name;
        }
        
        return $post_types_array;
      }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_cpt_list.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-custom-post-type-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_fields_cpt($fields) {
        $quantity = (isset($fields['cpt_quantity']) && !empty($fields['cpt_quantity']))
            ? $fields['cpt_quantity']
            : 1;

        $cpt = (isset($fields['cpt_custom_post_type']) && !empty($fields['cpt_custom_post_type']))
            ? $fields['cpt_custom_post_type']
            : null;
        
        if ($cpt == null) return null;

        $slug = $cpt;
        $cpt_array['taxonomy'] = 'blog-category';
        
        if ($cpt == 'gambling-news') {
            $slug = 'news';
            $cpt_array['taxonomy'] = 'news-category';
        } 
        
        $cpt_array['cpt'] = $cpt;
        $cpt_array['quantity'] = $quantity;
        $cpt_array['show'] = isset($fields[sprintf('cpt_%1$s_show', $slug)]) ? $fields[sprintf('cpt_%1$s_show', $slug)] : 'blog';
        $cpt_array['select_category_type'] = isset($fields[sprintf('cpt_%1$s_select_category_type', $slug)]) ? $fields[sprintf('cpt_%1$s_select_category_type', $slug)] : 'include';
        $cpt_array['category_include'] = isset($fields[sprintf('cpt_%1$s_category_include', $slug)]) ? $fields[sprintf('cpt_%1$s_category_include', $slug)] : false;
        $cpt_array['category_exclude'] = isset($fields[sprintf('cpt_%1$s_category_exclude', $slug)]) ? $fields[sprintf('cpt_%1$s_category_exclude', $slug)] : false;
        $cpt_array['elements'] = isset($fields[sprintf('cpt_%1$s_specific', $slug)]) ? $fields[sprintf('cpt_%1$s_specific', $slug)] : false;
        
        return $cpt_array;
    }

    public function get_elements_type($fields, $paged) {
        if (!is_array($fields) || count($fields) == 0) return;

        if (BLOCK_RDG_TYPE_SPECIFIC == $fields['show']) {
            return $fields['elements'];
        }

        $get_quantity = $fields['quantity'];
        $quantity = $get_quantity ? $get_quantity : 1;

        $category = '';
        $operator = 'IN';
        $select_category_type = $fields['select_category_type'];

        if (!empty($select_category_type)) {
            if ('include' == $select_category_type && is_array($fields['category_include']) && count($fields['category_include']) > 0) {
                $category = $fields['category_include'];
            } elseif ('exclude' == $select_category_type && is_array($fields['category_exclude']) && count($fields['category_exclude']) > 0) {
                $operator = 'NOT IN';
                $category = $fields['category_exclude'];
            }
        }

        $args = [
            'post_type' => $fields['cpt'],
            'post_status' => 'publish',
            'posts_per_page' => $quantity,
            'paged' => $paged
        ];

        if (is_array($category) && count($category) > 0) {
            $args['tax_query'] = [
                [
                    'taxonomy' => $fields['taxonomy'],
                    'field' => 'id',
                    'terms' => $category,
                    'operator' => $operator
                ]
            ];
        }

        $elements = (new WP_Query($args));
        wp_reset_postdata();

        return $elements;
    }

    public function get_taxonomy_categories($post_id, $attributes = []) {
        $terms = get_the_terms($post_id, $attributes['taxonomy']);

        if (is_array($terms) && count($terms) > 0) {
            $max_categories = (!empty(get_field('cpt_max_categories'))) ? get_field('cpt_max_categories') : 1;
            $categories = [];
            $mores = [];
            $item = 0;
            
            foreach ($terms as $term) {
                if ($max_categories <= $item) {
                    $mores[] = $term;
                } else {
                    $categories[] = $term;
                }
                
                $item++;
            }
            ?>
            
            <?php if (is_array($categories) && count($categories) > 0): ?>
                <span class="categories <?php echo $attributes['taxonomy']; ?>">
                    <?php echo (is_array($attributes) && isset($attributes['divider'])) 
                            ? $attributes['divider'] 
                            : ' | '; ?>
                    <?php foreach ($categories as $category): ?>
                        <span class='<?php echo $category->slug; ?>'>
                            <a href="<?php echo get_term_link($category); ?>"><?php echo $category->name; ?></a>
                        </span>

                        <?php
                            if (next($categories)) {
                                echo (is_array($attributes) && isset($attributes['separator']) && !empty($attributes['separator'])) 
                                    ? $attributes['separator'] 
                                    : ' ';
                            }
                        ?>
                    <?php endforeach; ?>
                </span>
            <?php endif; ?>
            
            <?php if (is_array($mores) && count($mores) > 0): ?>
                <?php
                    echo (is_array($attributes) && isset($attributes['separator']) && !empty($attributes['separator'])) 
                        ? $attributes['separator'] 
                        : ' ';
                ?>
                <div class="article-dropdown">
                    <a href="#">More</a>
                    <div class="more-content">
                    <?php foreach ($mores as $more): ?>
                        <span class='<?php echo $more->slug; ?>'>
                            <a href="<?php echo get_term_link($more); ?>"><?php echo $more->name; ?></a>
                        </span>
                    <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-cpt-list-date','slug' => 'color-cpt-list-date','color' => '#111111'],
            ['name' => 'color-cpt-list-category','slug' => 'color-cpt-list-category','color' => '#0160ac'],
            ['name' => 'color-cpt-list-category-hover','slug' => 'color-cpt-list-category-hover','color' => '#3a96e0'],
            ['name' => 'color-cpt-list-more','slug' => 'color-cpt-list-more','color' => '#f0f0f0'],
            ['name' => 'color-cpt-list-title','slug' => 'color-cpt-list-title','color' => '#111111'],
            ['name' => 'color-cpt-list-excerpt','slug' => 'color-cpt-list-excerpt','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-cpt-list .posts article .inside-article .article-header',
                'fontWeight' => '500',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-cpt-list .posts article .inside-article .article-summary .article-title',
                'fontWeight' => '800',
                'fontSize' => '1rem',
                'lineHeight' => '1.4rem'
            ],
            [
                'customSelector' => '.rdg-cpt-list .posts a',
                'textDecoration' => 'none'
            ],
        ];
    }
}

$rdg_cpt_list_class = new Rdg_Blocks_Cpt_List();
$rdg_cpt_list_class->init();

return $rdg_cpt_list_class;
