<?php
$logo_label = true;

if (intval($api_attributes['category_primary']) == 2) {
    $mu_sub_category = [4, 14, 21, 25, 26, 31];

    if (in_array(intval($api_attributes['sub_category']), $mu_sub_category)) {
        $logo_label = false;
    }
}

if (intval($api_attributes['category_primary']) == 7) {
    $mu_sub_category = [4, 26, 27];

    if (in_array(intval($api_attributes['sub_category']), $mu_sub_category)) {
        $logo_label = false;
    }
}

$fields = $block_picks_vs->getFieldsValidate();
if (empty($color_class_pick)) {
    $color_class_pick = 'color';
}
?>
<?php foreach($picks as $pick):?>
    <?php if (!$rdgb->helpers->validateFields($fields, $pick)) continue; ?>
    <div class="pick <?php echo $color_class_pick; ?>" style="<?php echo $color_style_pick; ?>">
        <div class="pick-header">
            <div class="content">
                <div class="sport"><span><?php echo $pick['sport_name']; ?></span></div>
                <div class="date-time">
                    <span>
                        <?php
                            try {
                                $d = DateTime::createFromFormat('Y-m-d H:i:s', $pick['game_date']);
                                $date_status = $d && $d->format('Y-m-d H:i:s') == $pick['game_date'];

                                if ($date_status) {
                                    echo $d->format('Y-m-d H:i');
                                }
                            } catch (\Exception $exception) {
                                //
                            }
                        ?>
                    </span>
                </div>
                <div class="status"><span><?php echo $pick['game_stat']; ?></span></div>
            </div>
        </div>
        <div class="pick-body">
            <div class="teams">
                <div class="team team-b">
                    <div class="team-logo">
                        <?php
                            $visitor_image = $block_picks_vs->get_image($pick['visitor_image'], [
                                'image_type' => 'team_image',
                                'image_alt' => $pick['visitor_name'],
                                'logo_label' => $logo_label
                            ]);
                        ?>
                        <img width="90" heigt="90" src="<?php echo $visitor_image['url']; ?>" alt="<?php echo $visitor_image['alt']; ?>">
                    </div>
                    <div class="team-name"><span><?php echo $pick['visitor_name']; ?></span></div>
                </div>
                <div class="team team-vs">
                    <div class="vs-logo"><span>vs</span></div>
                    <?php if ($link_options != 'none'): ?>
                        <?php
                            $url = '';
                            $target = '_self';
                            $rel = '';
                            $rel_tag = '';

                            if ($link_options == 'custom') {
                                if (is_array($custom_link)) {
                                    if (isset($custom_link['url'])) {
                                        $url = $custom_link['url'];
                                    }
    
                                    if (isset($custom_link['target']) && !empty($custom_link['target'])) {
                                        $target = $custom_link['target'];
                                    }
                                }

                                if (is_array($custom_link_rel)) {
                                    foreach ($custom_link_rel as $index => $rel_name) {
                                        $rel .= $rel_name;
                                        if ($index == count($custom_link_rel) - 2) $rel .= ' ';
                                    }

                                    $rel_tag = 'rel="'.$rel.'"';
                                }
                            } else {
                                $url = (!empty($pick['game_url'])) ? $pick['game_url'] : '#';
                                $target = '_blank';
                            }
                        ?>
                        <a href="<?php echo $url; ?>" target="<?php echo $target; ?>" <?php echo $rel_tag; ?>>
                    <?php endif; ?>
                        <div class="vs-name">
                            <span><?php echo $pick['num_picks']; ?> PICKS</span>
                        </div>
                    <?php if ($link_options != 'none'): ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="team team-a">
                    <div class="team-logo">
                        <?php
                            $home_image = $block_picks_vs->get_image($pick['home_image'], [
                                'image_type' => 'team_image',
                                'image_alt' => $pick['home_name'],
                                'logo_label' => $logo_label
                            ]);
                        ?>
                        <img width="90" heigt="90" src="<?php echo $home_image['url']; ?>" alt="<?php echo $home_image['alt']; ?>">
                    </div>
                    <div class="team-name"><span><?php echo $pick['home_name']; ?></span></div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; ?>
