<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Picks_Vs extends Rdg_Blocks_Base implements Rdg_Blocks_Api_Request
{
    protected $block_name = BLOCK_RDG_PICKS_VS;
    private $block_folder_name = 'rdg-picks-vs';
    protected $block_title = 'RDG Picks Vs';
    private $block_description = 'This block allow to create a 3 columns table with teams pick but with only one category';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'sports', 'picks', 'api'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = true;
    protected $is_config = true;
    protected $is_styles_load = true;
    protected $config_page_title = 'RDG Picks Vs';
    protected $config_menu_title = 'Picks Vs';
    protected $interval_field = 'picks_vs_interval';

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_picks_vs.css'),
                'enqueue_assets' => function(){
                    wp_register_script('rdg_picks_vs_script', RDGBLOCKS_PLUGIN_URL.'blocks/rdg-picks-vs/assets/js/rdg-picks-vs.js', array('jquery'), '2.0.0', true);
                    wp_enqueue_script('rdg_picks_vs_script');
                    wp_localize_script('rdg_picks_vs_script','rdg_picks_vs_var',['ajaxurl' => admin_url('admin-ajax.php')]);
                },
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-picks-vs-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'render_callback' => function($block) use ($rdg_helpers) {
                    global $wp_query;
                    $loop = $wp_query->in_the_loop;
                    $template_path = RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php";

                    if ($loop) {
                        include $template_path;
                        return;
                    }

                    $trace_config = $rdg_helpers->getBacktraceConfig();
                    $traces = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, $trace_config['max_trace']);
                    $trace_valid_admin = $rdg_helpers->checkExistsTraceFunction($traces, $trace_config['max_trace'], $trace_config['functions']);

                    if (is_admin() && !$trace_valid_admin) {
                        include $template_path;
                        return;
                    }
                },
            ]);
        }
    }

    public function register_fields() {
        $rdg_helpers = new Rdg_Blocks_Helpers();
        $sports = (function_exists('shMappingHierarchySports')) ? shMappingHierarchySports() : [];
        
        add_filter('acf/prepare_field', [$this, 'loadLeagues']);

        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_picks_vs_block_sdf4334r',
                'title' => 'Block_rdg_picks_vs',
                'fields' => array(
                    array(
                        'key' => 'field_645c264c1d81d',
                        'label' => 'Show In',
                        'name' => 'show_in',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'full' => 'Full width',
                            'content' => 'Content width',
                        ),
                        'default_value' => 'full',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'rdg_picks_vs_show_title',
                        'label' => 'Show Title',
                        'name' => 'show_title',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'show' => 'Show',
                            'none' => 'None',
                        ),
                        'default_value' => 'show',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63d9b54a73136',
                        'label' => 'Source',
                        'name' => 'source',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'manual' => 'Manual',
                            'api' => 'API',
                        ),
                        'default_value' => 'manual',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'save_other_choice' => 0,
                        'layout' => 'horizontal',
                    ),
                    array(
                        'key' => 'field_642eebcadb45e',
                        'label' => 'Link Options',
                        'name' => 'link_options',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'none' => 'None',
                            'default' => 'API',
                            'custom' => 'Custom',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_642f017adb45f',
                        'label' => 'Link',
                        'name' => 'custom_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_642eebcadb45e',
                                    'operator' => '==',
                                    'value' => 'custom',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                    array(
                        'key' => 'field_6761bqwdd23d8607',
                        'label' => 'Link Rel',
                        'name' => 'custom_link_rel',
                        'aria-label' => '',
                        'type' => 'checkbox',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_642eebcadb45e',
                                    'operator' => '==',
                                    'value' => 'custom',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'nofollow' => 'Nofollow',
                            'sponsored' => 'Sponsored',
                        ),
                        'default_value' => array(
                        ),
                        'return_format' => 'value',
                        'min' => '',
                        'max' => '',
                        'allow_custom' => 0,
                        'allow_in_bindings' => 1,
                        'layout' => 'horizontal',
                        'toggle' => 0,
                        'save_custom' => 0,
                        'custom_choice_button_text' => 'Add new choice',
                    ),
                    array(
                        'key' => 'field_63dbbd1ec1393',
                        'label' => 'Filter Category',
                        'name' => 'filter_category',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hide' => 'Hide',
                            'show' => 'Show',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'key_picks_vs_picks',
                        'label' => 'Picks',
                        'name' => 'picks',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'manual',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63cc527cbe269',
                                'label' => 'Category',
                                'name' => 'category',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'key_picks_vs_picks',
                            ),
                            array(
                                'key' => 'field_63cc527cc1bba',
                                'label' => 'Time',
                                'name' => 'time',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'key_picks_vs_picks',
                            ),
                            array(
                                'key' => 'field_63cc527cc584e',
                                'label' => 'Status',
                                'name' => 'status',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'key_picks_vs_picks',
                            ),
                            array(
                                'key' => 'field_63cc527cc92a2',
                                'label' => 'Vs',
                                'name' => 'vs',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'key_picks_vs_picks',
                            ),
                            array(
                                'key' => 'field_63cc527cccd29',
                                'label' => 'Teams',
                                'name' => 'teams',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 2,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63cc527ce34ba',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_63cc527cccd29',
                                    ),
                                    array(
                                        'key' => 'field_63cc527ce6f33',
                                        'label' => 'Name',
                                        'name' => 'name',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63cc527cccd29',
                                    ),
                                ),
                                'parent_repeater' => 'key_picks_vs_picks',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_63d9b5edd9ce1',
                        'label' => 'Sports',
                        'name' => 'sport',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => [0 => 'Choose an option'] + $sports,
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_picks_vs_league',
                        'label' => 'League',
                        'name' => 'league',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => 'rdg-picks-vs-league-select',
                            'id' => '',
                        ),
                        'choices' => [0 => 'Choose an option'],
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63d9b735d9ce3',
                        'label' => 'Number of Items',
                        'name' => 'number_of_items',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 3,
                        'min' => 0,
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_picks_vs_game_part',
                        'label' => 'Game Part',
                        'name' => 'game_part',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'none' => 'None',
                            'game' => 'Game'
                        ),
                        'default_value' => 'none',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_picks_vs_show_props',
                        'label' => 'Show Props',
                        'name' => 'show_props',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            '0' => 'No',
                            '1' => 'Yes'
                        ),
                        'default_value' => '0',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63dbbff733345',
                        'label' => 'Filter Date',
                        'name' => 'filter_date',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hide' => 'Hide',
                            'show' => 'Show',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63e6b06bc7010',
                        'label' => 'Date Type',
                        'name' => 'date_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63dbbff733345',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'yesterday' => 'Yesterday',
                            'now' => 'Now',
                            'tomorrow' => 'Tomorrow',
                            'range' => 'Range',
                        ),
                        'default_value' => 'now',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63e6af4c50608',
                        'label' => 'Since Date',
                        'name' => 'since_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63e6b06bc7010',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                    ),
                    array(
                        'key' => 'field_63e6afb550609',
                        'label' => 'To Date',
                        'name' => 'to_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63e6b06bc7010',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                    ),
                    array(
                        'key' => 'field_63dbbed44c4bd',
                        'label' => 'Date Range',
                        'name' => 'date_range',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63dbbff733345',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63eb9ff68a727',
                                'label' => 'Status',
                                'name' => 'status',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'link-info' => 'Active',
                                    'link-default' => 'Deactive',
                                ),
                                'default_value' => 'link-default',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63eb8ed62d5eb',
                                'label' => 'Date Type',
                                'name' => 'date_type',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63dbbff733345',
                                            'operator' => '==',
                                            'value' => 'show',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yesterday' => 'Yesterday',
                                    'now' => 'Now',
                                    'tomorrow' => 'Tomorrow',
                                    'range' => 'Range',
                                ),
                                'default_value' => 'now',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63eb8ee12d5ec',
                                'label' => 'Since Date',
                                'name' => 'since_date',
                                'aria-label' => '',
                                'type' => 'date_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63eb8ed62d5eb',
                                            'operator' => '==',
                                            'value' => 'range',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'display_format' => 'Y-m-d',
                                'return_format' => 'Y-m-d',
                                'first_day' => 1,
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63eb8eef2d5ed',
                                'label' => 'To Date',
                                'name' => 'to_date',
                                'aria-label' => '',
                                'type' => 'date_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63eb8ed62d5eb',
                                            'operator' => '==',
                                            'value' => 'range',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'display_format' => 'Y-m-d',
                                'return_format' => 'Y-m-d',
                                'first_day' => 1,
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63e6b171f782c',
                                'label' => 'Title Date',
                                'name' => 'title_date',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63dbbde453392',
                                'label' => 'Icon',
                                'name' => 'icon',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'fa-circle' => 'Circle',
                                    'fa-chevron-circle-up' => 'Circle Up',
                                    'fa-chevron-circle-right' => 'Circle Right',
                                    'fa-chevron-circle-down' => 'Circle Down',
                                    'fa-chevron-circle-left' => 'Circle Left',
                                    'fa-dot-circle' => 'Circle Dot',
                                    'fa-check-circle' => 'Circle Check',
                                    'fa-times-circle' => 'Circle X Mark',
                                    'fa-user-circle' => 'Circle User',
                                    'fa-question-circle' => 'Circle Question',
                                    'fa-info-circle' => 'Circle Info',
                                ),
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 1,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-picks-vs',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function loadLeagues($field) {
        if ($field['key'] == 'field_picks_vs_league') {
            // Get the sport field value using ACF's get_field_object
            $sport = get_field_object('field_63d9b5edd9ce1');
            
            // If sport field doesn't have a value, return field with default option
            if (!is_array($sport) || !isset($sport['value']) || empty($sport['value'])) {
                $field['choices'] = ['0' => 'Choose an option'];
                return $field;
            }
            
            // Load leagues for the selected sport
            $field['choices'] = ['0' => 'Choose an option'];
            
            if (function_exists('shMappingHierarchyFamily')) {
                $leagues = shMappingHierarchyFamily($sport['value']);
                if (is_array($leagues) && count($leagues) > 0) {
                    $field['choices'] = ['0' => 'Choose an option'] + $leagues;
                }
            }
        }
        
        return $field;
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_picks_vs_block_sdfw34fs2332',
                'title' => 'API configuration',
                'fields' => array(
                    array(
                        'key' => 'key_picks_vs_api_url',
                        'label' => 'URL',
                        'name' => 'picks_vs_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '70',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'key_picks_vs_interval',
                        'label' => 'Cache Refresh Frequency (Hours)',
                        'name' => 'picks_vs_interval',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'key_picks_vs_api_token',
                        'label' => 'Token',
                        'name' => 'picks_vs_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-picks-vs',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getApiAttributes($items = null, $attributes = []) {
        $api_url = get_field('picks_vs_api_url', 'option');
        $api_token = get_field('picks_vs_api_token', 'option');
        $cache_refresh = get_field('picks_vs_interval', 'option');
        $items = (!empty($items)) ? intval($items) : 10;
        
        $api_url = (substr($api_url, -1) == '/') ? substr($api_url, 0, strlen($api_url) -1) : $api_url;
        $api_url .= '?gamesToShow='.$items;

        // Backward compatibility: support old 'category' field or new 'league' field
        $hierarchy_id = null;
        $sub_category = null;
        
        if (isset($attributes['league']) && !empty($attributes['league'])) {
            // New structure: league field contains the hierarchy ID (league ID)
            $hierarchy_id = $attributes['league'];
        } elseif (isset($attributes['category']) && !empty($attributes['category'])) {
            // Old structure: category field (for backward compatibility)
            if (strpos($attributes['category'], '-') !== false) {
                list($hierarchy_id, $sub_category) = explode('-', $attributes['category']);
            } else {
                $hierarchy_id = $attributes['category'];
            }
        }
        
        // League selection is required - return null if missing
        if (empty($hierarchy_id)) {
            return null;
        }

        $hierarchy_clean = preg_replace('/\D/', '', $hierarchy_id);
        $api_url .= '&hierarchy='.$hierarchy_clean;

        // Add game_part parameter
        if (isset($attributes['game_part']) && !empty($attributes['game_part']) && $attributes['game_part'] !== 'none') {
            $api_url .= '&gamePart='.$attributes['game_part'];
        }

        // Add showProbs parameter
        $show_props = isset($attributes['show_props']) ? $attributes['show_props'] : '0';
        $api_url .= '&showProbs='.$show_props;

        // Add date filters
        if (isset($attributes['date']) && is_array($attributes['date']) && count($attributes['date']) == 2) {
            if (!empty($attributes['date']['start'])) {
                $api_url .= '&principalDate='.$attributes['date']['start'];
            }
            
            if (!empty($attributes['date']['end'])) {
                $api_url .= '&secondaryDate='.$attributes['date']['end'];
            }
        }

        $api_request = $api_url.'&api_token='.$api_token;

        return [
            'items' => $items,
            'method' => 'GET',
            'cache_refresh' => $cache_refresh,
            'headers' => ['Accept: application/json'],
            'request' => $api_request,
            'hierarchy' => $hierarchy_id,
            'category_primary' => $hierarchy_id, // Backward compatibility
            'sub_category' => $sub_category,
        ];
    }

    public function getApiParams() {
        return [
            'sport' => 'sport',
            'league' => 'league',
            'category' => 'category', // Backward compatibility
            'game_part' => 'game_part',
            'show_props' => 'show_props',
            '_to_transform_' => [
                [
                    'key' => 'date',
                    'function' => 'get_date_filter',
                    'params' => ['date_type', 'since_date', 'to_date'],
                    'fields_date' => ['since_date', 'to_date'],
                ]
            ],
        ];
    }

    public function getResourcesAjax($request) {
        $data = new StdClass();
        $data->json = '';
        $data->message = '';

        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $picks_vs = $rdgb_helpers->getApiDataAjax($this->block_name, $request);

        if (!empty($picks_vs->message)) {
            $data->message = $picks_vs->message;
        
            return $data;
        }

        // Normalize API response to handle new structure (hierarchy-keyed object)
        $hierarchy_id = isset($request['hierarchy']) ? preg_replace('/\D/', '', $request['hierarchy']) : null;
        $data->json = $this->normalizeApiResponse($picks_vs->json, $hierarchy_id);

        return $data;
    }

    /**
     * Normalize API response to handle both old and new structures
     * 
     * Old structure: [...picks...]
     * New structure: {"263": [...picks...], "269": [...picks...]}
     * 
     * @param mixed $response_data The API response data
     * @param string|null $hierarchy_id The hierarchy ID to extract
     * @return array Normalized array of picks
     */
    private function normalizeApiResponse($response_data, $hierarchy_id = null) {
        // If response is already an array of picks (old format)
        if (is_array($response_data) && isset($response_data[0])) {
            return $response_data;
        }
        
        // If response is object with hierarchy keys (new format)
        if (is_array($response_data) && !isset($response_data[0])) {
            // Try to get picks for specific hierarchy
            if ($hierarchy_id && isset($response_data[$hierarchy_id])) {
                return $response_data[$hierarchy_id];
            }
            
            // Fallback: return first available hierarchy
            $first_hierarchy = reset($response_data);
            if (is_array($first_hierarchy)) {
                return $first_hierarchy;
            }
        }
        
        // Unknown format or empty response
        return [];
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }

    public function get_width($type, $filter_category, $filter_date) {
        if ($type == 'style') {
            if ($filter_category == 'hide' && $filter_date == 'hide') {
                return '';
            }
    
            if ($filter_category == 'show' && $filter_date == 'show') {
                $style[] = '--category-align: flex-end';
                $style[] = '--category-select-width: 70%';
                $style[] = '--sub-category-align: flex-start';
        
                return implode('; ', $style).';';
            }
    
            if ($filter_category == 'show' && $filter_date == 'hide') {
                $style[] = '--category-align: center';
                $style[] = '--category-select-width: 40%';
                $style[] = '--sub-category-align: flex-start';
        
                return implode('; ', $style).';';
            }
        
            $style[] = '--category-align: flex-end';
            $style[] = '--sub-category-align: center';
    
            return implode('; ', $style).';';
        }

        if ($filter_category == 'hide' && $filter_date == 'hide') {
            return '';
        }

        if ($filter_category == 'show' && $filter_date == 'show') {
            return 'w-50';
        }
        
        if ($type == 'class_category') {
            if ($filter_category == 'show' && $filter_date == 'hide') {
                return 'w-100';
            }
        }

        if ($type == 'class_sub_category') {
            if ($filter_category == 'hide' && $filter_date == 'show') {
                return 'w-100';
            }
        }
        
        return '';
    }

    public function get_date_filter($date_type, $since_date, $to_date) {
        $date = [
            'start' => null,
            'end' => null
        ];

        if ($date_type == API_DATE_TYPE_YESTERDAY) {
            $date['start'] = date('Y-m-d', strtotime("-1 days"));

            return $date;
        }

        if ($date_type == API_DATE_TYPE_NOW) {

            return $date;
        }
        
        if ($date_type == API_DATE_TYPE_TOMORROW) {
            $date['start'] = date('Y-m-d',strtotime("+1 days"));
            
            return $date;
        }

        if ($date_type == API_DATE_TYPE_RANGE) {
            if (!empty($since_date) && !empty($to_date)) {
                $date['start'] = $since_date;
                $date['end'] = $to_date;
            
                return $date;
            }

            if (empty($since_date) && empty($to_date)) {
                return $date;
            }

            if (!empty($since_date) && empty($to_date)) {
                $date['start'] = $since_date;
            
                return $date;
            }

            if (empty($since_date) && !empty($to_date)) {
                $date['start'] = $to_date;
            
                return $date;
            }
        }

        return $date;
    }

    public function get_image($url_image, $attributes = []) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $url_image = $rdgb_helpers->getImageSource($url_image, $attributes);

        return $url_image;
    }

    public function get_picks_vs_title_format($title) {
        if (strpos($title, '|') && is_array(explode(' | ', $title)) && count(explode(' | ', $title)) == 2) {
            $title_parts = explode(' | ', $title);
    
            return "<span style='color: var(--color-black); text-shadow: none;'>$title_parts[0] | </span> $title_parts[1]";
        }
        
        return "<span style='color: var(--color-black); text-shadow: none;'>$title</span>";
    }

    public function getFieldsValidate() {
        return [
            //'id_game' => ['required'],
            //'id_sport' => ['required'],
            'sport_name' => ['required', 'notnull'],
            'game_date' => ['required', 'notnull'],
            //'id_visitor_team' => ['required'],
            //'id_master_visitor_team' => ['required'],
            'visitor_name' => ['required', 'notnull'],
            //'id_home_team' => ['required'],
            //'id_master_home_team' => ['required'],
            'home_name' => ['required', 'notnull'],
            'game_stat' => ['required', 'notnull'],
            'num_picks' => ['required'], // Allow 0 as valid value
            'game_url' => ['required', 'notnull'],
            'visitor_image' => ['required', 'notnull'],
            'home_image' => ['required', 'notnull'],
            //'visitor_image_type' => ['required'],
            //'home_image_type' => ['required'],
        ];
    }

    public function getPreSavedData($data, $attributes = [])
    {
        return $data;
    }

    public function getColorsToloadGeneratePress()
    {
        return [
            [
                'name' => 'color-picks-vs-wait-bg',
                'slug' => 'color-picks-vs-wait-bg',
                'color' => 'rgba(255, 255, 255, .8)',
            ],
            [
                'name' => 'color-picks-vs-filter-select-box-shadow',
                'slug' => 'color-picks-vs-filter-select-box-shadow',
                'color' => 'rgba(0, 0, 0, .15)',
            ],
            [
                'name' => 'color-picks-vs-filter-select',
                'slug' => 'color-picks-vs-filter-select',
                'color' => '#3a96e0',
            ],
            [
                'name' => 'color-picks-vs-filter-select-bg',
                'slug' => 'color-picks-vs-filter-select-bg',
                'color' => '#ffffff',
            ],
            [
                'name' => 'color-picks-vs-filter-button',
                'slug' => 'color-picks-vs-filter-button',
                'color' => '#ffffff',
            ],
            [
                'name' => 'color-picks-vs-filter-button-link-info',
                'slug' => 'color-picks-vs-filter-button-link-info',
                'color' => '#ffffff',
            ],
            [
                'name' => 'color-picks-vs-filter-button-link-info-bg',
                'slug' => 'color-picks-vs-filter-button-link-info-bg',
                'color' => '#0160ac',
            ],
            [
                'name' => 'color-picks-vs-filter-button-link-info-border',
                'slug' => 'color-picks-vs-filter-button-link-info-border',
                'color' => '#3a96e0',
            ],
            [
                'name' => 'color-picks-vs-filter-button-link-default',
                'slug' => 'color-picks-vs-filter-button-link-default',
                'color' => '#ffffff',
            ],
            [
                'name' => 'color-picks-vs-filter-button-link-default-bg',
                'slug' => 'color-picks-vs-filter-button-link-default-bg',
                'color' => '#3a96e0',
            ],
            [
                'name' => 'color-picks-vs-filter-button-link-default-hover',
                'slug' => 'color-picks-vs-filter-button-link-default-hover',
                'color' => '#3a96e0',
            ],
            [
                'name' => 'color-picks-vs-filter-button-link-default-hover-bg',
                'slug' => 'color-picks-vs-filter-button-link-default-hover-bg',
                'color' => '#cccccc',
            ],
            [
                'name' => 'color-picks-vs-picks-message-bg',
                'slug' => 'color-picks-vs-picks-message-bg',
                'color' => '#f79e9e',
            ],
            [
                'name' => 'color-picks-vs-picks-message-border',
                'slug' => 'color-picks-vs-picks-message-border',
                'color' => '#891010',
            ],
            [
                'name' => 'color-picks-vs-picks-message-span',
                'slug' => 'color-picks-vs-picks-message-span',
                'color' => '#891010',
            ],
            [
                'name' => 'color-picks-vs-picks-pick-bg',
                'slug' => 'color-picks-vs-picks-pick-bg',
                'color' => '#ffffff',
            ],
            [
                'name' => 'color-picks-vs-picks-pick-teams-vs-logo-span',
                'slug' => 'color-picks-vs-picks-pick-teams-vs-logo-span',
                'color' => '#ffffff',
            ],
            [
                'name' => 'color-picks-vs-picks-pick-teams-vs-name-bg',
                'slug' => 'color-picks-vs-picks-pick-teams-vs-name-bg',
                'color' => '#0160ac',
            ],
            [
                'name' => 'color-picks-vs-picks-pick-teams-vs-name-span',
                'slug' => 'color-picks-vs-picks-pick-teams-vs-name-span',
                'color' => '#ffffff',
            ],
            [
                'name' => 'color-picks-vs-picks',
                'slug' => 'color-picks-vs-picks',
                'color' => '#0160ac',
            ],
        ];
    }

    public function getStylesToloadGeneratePress()
    {
        return [
            [
                'customSelector' => '.rdg-picks-vs .filter .buttons a',
                'fontSize' => '1rem',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.rdg-picks-vs .filter .buttons a i',
                'fontSize' => '1.2rem',
            ],
            [
                'customSelector' => '.rdg-picks-vs .message span',
                'fontSize' => '1.125rem',
                'fontSizeTablet' => '1rem',
                'fontWeight' => '600',
            ],
            [
                'customSelector' => '.rdg-picks-vs .pick .pick-header .sport',
                'fontSize' => '.875rem',
                'fontWeight' => '700',
                'textTransform' => 'uppercase'
            ],
            [
                'customSelector' => '.rdg-picks-vs .pick .pick-header .date-time',
                'fontSize' => '.938rem',
                'fontSizeMobile' => '.813rem',
            ],
            [
                'customSelector' => '.rdg-picks-vs .pick .pick-header .status',
                'fontSize' => '.875rem',
                'fontWeight' => '700',
                'textTransform' => 'uppercase'
            ],
            [
                'customSelector' => '.rdg-picks-vs .pick .pick-body .team-vs .vs-logo span',
                'fontSize' => '.9rem',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.rdg-picks-vs .pick .pick-body .team .team-name',
                'fontSize' => '.938rem',
                'fontWeight' => '700',
            ],
            [
                'customSelector' => '.rdg-picks-vs .pick .pick-body .team-vs .vs-name span',
                'fontSize' => '.9rem',
                'fontWeight' => '600',
            ],
        ];
    }
}

add_action('wp_ajax_nopriv_load_picks_vs','get_picks_vs_data');
add_action('wp_ajax_load_picks_vs','get_picks_vs_data');

function get_picks_vs_data() {
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_PICKS_VS;
    $block_picks_vs = $rdgb->settings->getBlock($block_name);

    $message = null;
    $items = $_POST['items'];
    $id_sub_category = isset($_POST['id_sub_category']) ? $_POST['id_sub_category'] : null;
    $data_date_type = $_POST['data_date_type'];
    $data_since_date = $_POST['data_since_date'];
    $data_to_date = $_POST['data_to_date'];

    $link_options = $_POST['custom_link_show'];
    $custom_link = [
        'url' => $_POST['custom_link_url'],
        'target' => $_POST['custom_link_target'],
    ];

    $api_url = get_field('picks_vs_api_url', 'option');
    $api_token = get_field('picks_vs_api_token', 'option');

    $date_request = $block_picks_vs->get_date_filter($data_date_type, $data_since_date, $data_to_date);

    if (strpos($id_sub_category, '-')) {
        list($cat_primary, $cat_secondary) = explode('-', $id_sub_category);
        $key = $cat_primary.':'.$cat_secondary.':'.$data_since_date.':'.$data_to_date.':'.$items;
    } else {
        $cat_primary = $id_sub_category;
        $cat_secondary = '';
        $key = $cat_primary.':'.$data_since_date.':'.$data_to_date.':'.$items;
    }

    $api_attributes = [
        'hierarchy' => $cat_primary,
        'category_primary' => $cat_primary, // Backward compatibility
        'sub_category' => $cat_secondary,
    ];

    if ($rdgb->helpers->initRedis()) {
        $rdgb->helpers->setRedisGroup(REDIS_GROUP_BLOCKS);
        $data_block = $rdgb->helpers->getRedis($key);

        if (!empty($data_block)) {
            $picks = unserialize($data_block);

            require 'partials/api.php';
            wp_die();
        }
    }

    if (!empty($api_url) && !empty($api_token)) {
        $api_attributes = $block_picks_vs->getApiAttributes($items, ['category' => $id_sub_category, 'date' => $date_request]);
        $response = $block_picks_vs->getResourcesAjax($api_attributes);

        if (empty($response->message)) {
            // Response is already normalized by getResourcesAjax()
            $picks = $response->json;
        } else {
            $picks = null;
            $message = $response->message;
        }

        if ($rdgb->helpers->initRedis() && $picks !== null) {
            $rdgb->helpers->setRedis($key, serialize($picks), REDIS_TIMEOUT);
        }
    } else {
        $message = 'Configure API connection correctly.';
    }

    if (!empty($message)) {
        $message = 'Picks with these characteristics were not found.';
        require 'partials/message.php';
        wp_die();
    }

    require 'partials/api.php';

    wp_die();
}

add_action('wp_ajax_nopriv_load_picks_vs_title','get_picks_vs_title');
add_action('wp_ajax_load_picks_vs_title','get_picks_vs_title');

function get_picks_vs_title() {
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_PICKS_VS;
    $block_picks_vs = $rdgb->settings->getBlock($block_name);
    $id_sub_category = isset($_POST['id_sub_category']) ? $_POST['id_sub_category'] : '';

    $titles_sports = $rdgb->helpers->getSporstCategoriesTitles(true);
    $title = (is_array($titles_sports) && isset($titles_sports[$id_sub_category])) ? $titles_sports[$id_sub_category] : '';

    echo $block_picks_vs->get_picks_vs_title_format($title);

    wp_die();
}

add_action('wp_ajax_nopriv_load_picks_vs_options','getPicksVsOptions');
add_action('wp_ajax_load_picks_vs_options','getPicksVsOptions');

function getPicksVsOptions() {
    $sport = $_POST['sport'] ?? null;
    $data['leagues'] = [];

    if (empty($sport)) {
        echo json_encode($data);
        wp_die();
    }

    $leagues = (function_exists('shMappingHierarchyFamily')) ? shMappingHierarchyFamily($sport) : [];

    if (!is_array($leagues) || count($leagues) == 0) {
        echo json_encode($data);
        wp_die();
    }

    $data['leagues'] = ['0' => 'Choose an option'] + $leagues;

    echo json_encode($data);
    wp_die();
}

$rdg_picks_vs_class = new Rdg_Blocks_Picks_Vs();
$rdg_picks_vs_class->init();

return $rdg_picks_vs_class;
