document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll("[name='redis-cache-delete']").forEach(button => {
        button.addEventListener("click", function (event) {
            event.preventDefault();

            let button = this;
            let cache = this.getAttribute("data-cache");

            if (button.disabled === true) {
                return;
            }

            button.disabled = true;
            button.textContent = "Deleting...";

            fetch(ajaxurl, {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: `action=rdg_blocks_delete_cache&cache=${cache}`,
            })
            .then((response) => response.text())
            .then((result) => {
                let item = this.parentElement.parentElement;

                button.disabled = false;
                button.textContent = "Delete";

                if (result == 'success') {
                    item.remove();
                } else {
                    let idSelector = `api_response_item_${cache}`.replace(/:/g, "\\:");
                    document.querySelector('.' + idSelector + ' pre').innerHTML = result;
                }
            })
            .catch((err) => console.error(err));
        });
    });

    document.querySelectorAll("[name='redis-cache-update']").forEach(button => {
        button.addEventListener("click", function (event) {
            event.preventDefault();
            let button = this;
            let cache = this.getAttribute("data-cache");

            if (button.disabled === true) {
                return;
            }

            button.disabled = true;
            button.textContent = "Updating...";

            fetch(ajaxurl, {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: `action=rdg_blocks_update_cache&cache=${cache}`,
            })
            .then((response) => response.text())
            .then((resultado) => {
                let idSelector = `api_response_item_${cache}`.replace(/:/g, "\\:");
                document.querySelector('.' + idSelector + ' pre').innerHTML = resultado;

                button.disabled = false;
                button.textContent = "Update";
            })
            .catch((err) => console.error(err));
        });
    });

    document.querySelectorAll("select.filter_cache").forEach(select => {
        select.addEventListener("change", function () {
            let url = new URL(window.location.href);

            document.querySelectorAll("select.filter_cache").forEach(sel => {
                let paramName = sel.id;
                let paramValue = sel.value;

                if (paramValue && paramValue !== "") {
                    url.searchParams.set(paramName, paramValue);
                } else {
                    url.searchParams.delete(paramName);
                }
            });

            window.location.href = url.toString();
        });
    });

    document.querySelector("[name='redis-cache-delete-all']").addEventListener("click", function (event) {
        event.preventDefault();

        let button = this;
        if (button.disabled === true) {
            return;
        }

        const confirmed = confirm("Are you sure you want to continue?");
        if (!confirmed) {
            return;
        }

        button.disabled = true;
        button.textContent = "Deleting All...";
        let url = new URL(window.location.href);

        fetch(ajaxurl, {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "action=rdg_blocks_delete_cache_all",
        })
        .then(response => response.text())
        .then(result => {
            button.disabled = false;
            button.textContent = "Delete All";
            
            if (result == 'success') {
                window.location.href = url.toString();
            }
        })
        .catch((err) => console.error(err));
    });

    document.querySelector("[name='redis-cache-filter-clear']").addEventListener("click", function (event) {
        event.preventDefault();

        const paramsToKeep = ["page"];
        const currentUrl = new URL(window.location.href);
        const newUrl = new URL(currentUrl.origin + currentUrl.pathname);

        paramsToKeep.forEach(param => {
            const value = currentUrl.searchParams.get(param);
            if (value !== null) {
                newUrl.searchParams.set(param, value);
            }
        });

        window.location.href = newUrl.toString();
    });

    document.querySelector("[name='redis-cache-delete-selected']").addEventListener("click", function (event) {
        event.preventDefault();

        let selectedItems = Array.from(document.querySelectorAll(".filters_cache_data tbody tr")).map(tr => tr.className);
        if (selectedItems.length === 0) {
            return;
        }

        let button = this;
        if (button.disabled === true) {
            return;
        }

        const confirmed = confirm("Are you sure you want to continue?");
        if (!confirmed) {
            return;
        }

        button.disabled = true;
        button.textContent = "Deleting Selected...";
        let url = new URL(window.location.href);

        fetch(ajaxurl, {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "action=rdg_blocks_delete_cache_selected&selected=" + selectedItems,
        })
        .then(response => response.text())
        .then(result => {
            button.disabled = false;
            button.textContent = "Delete Selected";
            window.location.href = url.toString();
        })
        .catch((err) => console.error(err));
    });

    function populateSelect(selectId, data, selectedValue) {
        let select = document.getElementById(selectId);
        if (!select) return;

        select.innerHTML = "";

        let defaultOption = document.createElement("option");
        defaultOption.value = "";
        defaultOption.textContent = "Select an option";
        select.appendChild(defaultOption);

        data.forEach(item => {
            let option = document.createElement("option");
            option.value = item;
            option.textContent = item;
            select.appendChild(option);

            if (selectedValue && selectedValue === item) {
                option.selected = true;
            }

            select.appendChild(option);
        });
    }

    populateSelect("filter_type", jsonData.data_filter_type, jsonData.selected.filter_type);
    populateSelect("filter_type_id", jsonData.data_filter_type_ids, jsonData.selected.filter_type_id);
    populateSelect("filter_block_type", jsonData.data_filter_block_types, jsonData.selected.filter_block_type);
    populateSelect("filter_block_status", jsonData.data_filter_block_status, jsonData.selected.filter_block_status);

    // Handler for Regenerate All Cache
    document.querySelector("[name='redis-cache-regenerate-all']").addEventListener("click", function (event) {
        event.preventDefault();

        let button = this;
        if (button.disabled === true) {
            return;
        }

        const confirmed = confirm(
            "⚠️ WARNING: This operation will regenerate ALL cache blocks.\n\n" +
            "This process runs in the background and may take 2-5 minutes.\n" +
            "You can close this page and check back later.\n\n" +
            "Are you sure you want to continue?"
        );
        
        if (!confirmed) {
            return;
        }

        // Disable button and change text
        // Save original height before changing text to maintain layout
        const originalHeight = button.offsetHeight + 'px';
        
        button.disabled = true;
        button.textContent = "🔄 Regenerating...";
        button.style.opacity = "0.6";
        button.style.whiteSpace = "nowrap";
        button.style.minWidth = "auto";
        button.style.height = originalHeight;
        button.style.lineHeight = originalHeight;

        // Show progress message to user
        const progressDiv = document.createElement("div");
        progressDiv.style.cssText = "background: #fff3cd; border: 1px solid #ffc107; padding: 10px; margin: 10px 0; border-radius: 4px;";
        progressDiv.innerHTML = "⏳ <strong>Cache regeneration started!</strong><br>" +
            "<small>The process is running in the background (2-5 minutes).<br>" +
            "You can close this page and come back later to see updated blocks.</small>";
        button.parentElement.insertBefore(progressDiv, button.nextSibling);

        fetch(rdg_block_var.ajaxurl, {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: `action=rdg_blocks_regenerate_all_cache&nonce=${rdg_block_var.regenerate_nonce}`,
        })
        .then(response => {
            // Verify that server response is valid
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(result => {
            // Restore button to its original state
            button.disabled = false;
            button.textContent = "Regenerate All Cache";
            button.style.opacity = "1";
            button.style.whiteSpace = "normal";
            button.style.minWidth = "";
            button.style.height = "";
            button.style.lineHeight = "";

            // Remove progress message
            progressDiv.remove();

            // WordPress wp_send_json_success/error uses format: {success: true/false, data: {...}}
            if (result.success) {
                const successDiv = document.createElement("div");
                successDiv.style.cssText = "background: #d4edda; border: 1px solid #28a745; padding: 10px; margin: 10px 0; border-radius: 4px;";
                successDiv.innerHTML = `✅ <strong>Success!</strong> ${result.data.message}<br><small>Refreshing page in 3 seconds...</small>`;
                button.parentElement.insertBefore(successDiv, button.nextSibling);
                
                // Auto-close after 3 seconds and reload page
                setTimeout(() => {
                    successDiv.remove();
                    // Reload page to show updated cache
                    window.location.reload();
                }, 3000);
            } else {
                const errorDiv = document.createElement("div");
                errorDiv.style.cssText = "background: #f8d7da; border: 1px solid #dc3545; padding: 10px; margin: 10px 0; border-radius: 4px;";
                errorDiv.innerHTML = `❌ <strong>Error:</strong> ${result.data.message || 'Unknown error'}`;
                button.parentElement.insertBefore(errorDiv, button.nextSibling);
                
                // Auto-close after 10 seconds
                setTimeout(() => errorDiv.remove(), 10000);
            }
        })
        .catch((err) => {
            console.error('AJAX Error:', err);
            
            // Restore button to its original state
            button.disabled = false;
            button.textContent = "Regenerate All Cache";
            button.style.opacity = "1";
            button.style.whiteSpace = "normal";
            button.style.minWidth = "";
            button.style.height = "";
            button.style.lineHeight = "";
            
            // If it's a timeout (504), show informative message instead of error
            // The process continues running correctly in the background
            if (err.message.includes('504') || err.message.includes('timeout')) {
                // Change progress message to success
                if (progressDiv && progressDiv.parentElement) {
                    progressDiv.style.cssText = "background: #d1ecf1; border: 1px solid #17a2b8; padding: 10px; margin: 10px 0; border-radius: 4px;";
                    progressDiv.innerHTML = "✅ <strong>Process started successfully!</strong><br>" +
                        "<small>The regeneration is running in the background (takes 2-5 minutes).<br>" +
                        "Check the debug.log or refresh this page in a few minutes to see the results.</small>";
                    
                    // Auto-close after 15 seconds
                    setTimeout(() => {
                        if (progressDiv && progressDiv.parentElement) {
                            progressDiv.remove();
                        }
                    }, 15000);
                }
            } else {
                // Remove progress message for other errors
                if (progressDiv && progressDiv.parentElement) {
                    progressDiv.remove();
                }
                
                // Show real connection error
                const errorDiv = document.createElement("div");
                errorDiv.style.cssText = "background: #f8d7da; border: 1px solid #dc3545; padding: 10px; margin: 10px 0; border-radius: 4px;";
                errorDiv.innerHTML = `❌ <strong>Connection Error:</strong> ${err.message}`;
                button.parentElement.insertBefore(errorDiv, button.nextSibling);
                
                // Auto-close after 10 seconds
                setTimeout(() => errorDiv.remove(), 10000);
            }
        });
    });
});

