<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_TABLE;
    $block_classes = [$block_name];
    $block_table = $rdgb->settings->getBlock($block_name);

    $message = '';
    $link = get_field('link');
    $tops = get_field('tops');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
    list($heading, $title, $styles) = $block_table->getTitle(get_fields());
?>

<div class="rdg-blocks">
    <div id="<?php echo $block['id']; ?>" class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block; ?>">
        <div class="header">
            <?php if(!empty($title)): ?>
                <div class="title" style="<?php echo $styles; ?>">
                    <<?php echo $heading; ?> class="header-title"><?php echo $title; ?></<?php echo $heading; ?>>
                </div>
            <?php endif; ?>
        </div>

        <div class="body">
            <div class="tops">
                <?php if (is_array($tops) && count($tops) > 0): ?>
                    <?php foreach($tops as $top): ?>
                        <div class="top">
                            <div class="separator">
                                <div class="name"><?php echo $top['name']; ?></div>
                                <div class="value"><?php echo $top['value']; ?></div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="footer">
            <?php if(!empty($link)): ?>
                <div class="footer-link">
                    <a href="<?php echo $link['url']; ?>" target="<?php echo $link['target']; ?>">
                        <?php echo $link['title']; ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
