<?php
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_LOGIN;
    $block_classes = [$block_name];
    $block_paragraph_custom = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $content = (!empty(get_field('content'))) ? get_field('content') : '';
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <div class="body">
            <div class="box">
                <div class="box-title">
                    <span>member area</span>
                </div>
                <div class="box-body">
                    <label for="email">Email</label>
                    <input type="text" name="email">
                    <label for="password">Password</label>
                    <input type="text" name="password">
                    <input type="checkbox"><span class="remember">Remember me</span>
                    <div class="link">
                        <a href="">sign in</a>
                    </div>

                    <div class="box-footer">
                        <a href="#">Forgot your Password?</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
