<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_New_Paragraph_Custom extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_NEW_PARAGRAPH_CUSTOM;
    private $block_folder_name = 'rdg-new-paragraph-custom';
    protected $block_title = 'RDG New Paragraph Custom';
    private $block_description = 'This block allow create sections for writing custom text with title, sub title and paragraph, with a vertical style blocks';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'paragraph', 'text', 'new'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_new_paragraph_custom.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-new-paragraph-custom-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_new_paragraph_custom_block_dfgt34t34r',
                'title' => 'Block_rdg_new_paragraph_custom',
                'fields' => array(
                    array(
                        'key' => 'field_63cb3de9a8bb4',
                        'label' => 'Elements',
                        'name' => 'elements',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63cb3de9aca46',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9b09f7',
                                'label' => 'Heading',
                                'name' => 'heading',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'h1' => 'Heading H1',
                                    'h2' => 'Heading H2',
                                    'h3' => 'Heading H3',
                                    'span' => 'Heading Span',
                                ),
                                'default_value' => 'h1',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9b44bc',
                                'label' => 'Border Line',
                                'name' => 'border_line',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 3,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9b80ab',
                                'label' => 'Padding',
                                'name' => 'padding',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '0.5',
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9bbc08',
                                'label' => 'Text Align',
                                'name' => 'title_align',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'left' => 'Left',
                                    'center' => 'Center',
                                    'right' => 'Right',
                                ),
                                'default_value' => 'left',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9bf873',
                                'label' => 'Font Weight',
                                'name' => 'font_weight',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    100 => '100',
                                    200 => '200',
                                    300 => '300',
                                    400 => '400',
                                    500 => '500',
                                    600 => '600',
                                    700 => '700',
                                    800 => '800',
                                    900 => '900',
                                ),
                                'default_value' => 700,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9c3300',
                                'label' => 'Size',
                                'name' => 'size',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '1.5',
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9c6d1e',
                                'label' => 'Size LG',
                                'name' => 'size_lg',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9caa03',
                                'label' => 'Size MD',
                                'name' => 'size_md',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9ce4a9',
                                'label' => 'Size SM',
                                'name' => 'size_sm',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9d1dec',
                                'label' => 'Title Color',
                                'name' => 'title_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9aca46',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#000000',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9d57fc',
                                'label' => 'Border Color',
                                'name' => 'line_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63cb3de9b44bc',
                                            'operator' => '>',
                                            'value' => '0',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3f2ae502f',
                                'label' => 'Sub Title',
                                'name' => 'sub_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                            array(
                                'key' => 'field_63cb3de9d918e',
                                'label' => 'Paragraph',
                                'name' => 'paragraph',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_63cb3de9a8bb4',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-new-paragraph-custom',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_sub_title($element) {
        $rdg_helpers = new Rdg_Blocks_Helpers();
        list($heading, $title, $styles) = $rdg_helpers->getTitle($element, false);

        $new_style = [];
        foreach($styles as $style) {
            if (strpos($style, 'text-shadow:') === false) {
                $new_style[] = $style;
            }
        }

        $color_line = (!empty($element['line_color'])) ? $element['line_color'] : '#3a96e0';
        $line = (!empty($element['border_line'])) ? 'border-bottom: '.$element['border_line'].'px solid '.$color_line : 'border-bottom: none';

        if (count($new_style) > 0) {
            $styles = implode('; ', $new_style).';';
        }

        return [$heading, $title, $styles, $line];
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'new-paragraph-custom-sub-title','slug' => 'new-paragraph-custom-sub-title','color' => '#7F8C8D'],
            ['name' => 'new-paragraph-custom-description','slug' => 'new-paragraph-custom-description','color' => '#111111'],
            ['name' => 'new-paragraph-custom-line','slug' => 'new-paragraph-custom-line','color' => '#0160ac'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-new-paragraph-custom .items .item .sub-title',
                'fontWeight' => '600',
                'fontSize' => '0.9rem',
                'lineHeight' => '1.2rem',
            ],
            [
                'customSelector' => '.rdg-new-paragraph-custom .items .item .description',
                'fontSize' => '1.2rem',
                'lineHeight' => '1.2rem',
            ],
        ];
    }
}

$rdg_new_paragraph_custom_class = new Rdg_Blocks_New_Paragraph_Custom();
$rdg_new_paragraph_custom_class->init();

return $rdg_new_paragraph_custom_class;
