<?php
if( have_rows('manual') ):
    while( have_rows('manual') ) : the_row();

    $name_a = get_sub_field('rdg_scores_and_odds_team_a');
    $name_b = get_sub_field('rdg_scores_and_odds_team_b');

    $img_a = get_sub_field('rdg_scores_and_odds_img_team_a');
    $img_b = get_sub_field('rdg_scores_and_odds_img_team_b');

    $game_part = get_sub_field('rdg_scores_and_odds_manual_game_part');
    $date = get_sub_field('rdg_scores_and_odds_date');
    $hour = get_sub_field('rdg_scores_and_odds_hour');

    $score_a = get_sub_field('rdg_scores_and_odds_score_a');
    $score_b = get_sub_field('rdg_scores_and_odds_score_b');

    $spread_a = get_sub_field('rdg_scores_and_odds_spread_a');
    $spread_b = get_sub_field('rdg_scores_and_odds_spread_b');

    $total_a = get_sub_field('rdg_scores_and_odds_total_a');
    $total_b = get_sub_field('rdg_scores_and_odds_total_b');

    $money_a = get_sub_field('rdg_scores_and_odds_moneyline_a');
    $money_b = get_sub_field('rdg_scores_and_odds_moneyline_b');

    $preview = get_sub_field('rdg_scores_and_odds_previews');
    $picks = get_sub_field('rdg_scores_and_odds_picks');
    ?>
    <div class="sao-wrapper">
        <div class="header">
            <p><?php echo $name_a; ?></p>
            <p>vs</p>
            <p><?php echo $name_b; ?></p>
        </div>
        <div class="body">
            <div class="versus">
                <div class="team-a">
                <?php if (isset($img_a['url']) && !empty($img_a['url'])): ?>
                    <img src="<?php echo esc_url($img_a['url']); ?>" alt="<?php echo esc_attr(isset($img_a['alt']) ? $img_a['alt'] : ''); ?>">
                <?php endif ?>
                </div>
                <div class="vs">
                    <p class="state"><?php echo $game_part; ?></p>
                    <p class="vs-p">vs</p>
                    <p class="date"><?php echo $date; ?></p>
                    <p class="hour"><?php echo $hour; ?></p>
                </div>
                <div class="team-b">
                <?php if (isset($img_b['url']) && !empty($img_b['url'])): ?>
                    <img src="<?php echo esc_url($img_b['url']); ?>" alt="<?php echo esc_attr(isset($img_b['alt']) ? $img_b['alt'] : ''); ?>">
                <?php endif ?>
                </div>
            </div>
            <div class="stats">
                <div class="stat">
                    <p class="team-a"><?php echo $score_a; ?></p>
                    <p class="name">Score</p>
                    <p class="team-b"><?php echo $score_b; ?></p>
                </div>
                <div class="stat">
                    <p class="team-a"><?php echo $spread_a; ?></p>
                    <p class="name">Spread</p>
                    <p class="team-b"><?php echo $spread_b; ?></p>
                </div>
                <div class="stat">
                    <p class="team-a"><?php echo $total_a; ?></p>
                    <p class="name">Total</p>
                    <p class="team-b"><?php echo $total_b; ?></p>
                </div>
                <div class="stat">
                    <p class="team-a"><?php echo $money_a; ?></p>
                    <p class="name">Moneyline</p>
                    <p class="team-b"><?php echo $money_b; ?></p>
                </div>
            </div>
            <div class="ctas">
            <?php if (isset($preview) && !empty($preview)): ?>
                <a href="<?php echo esc_url($preview['url']); ?>" class="preview">
                    <?php echo esc_html($preview['title']); ?>
                </a>
            <?php endif; ?>
            <?php if (isset($picks) && !empty($picks)): ?>
                <a href="<?php echo esc_url($picks['url']); ?>" class="pick">
                    <?php echo esc_html($picks['title']); ?>
                </a>
            <?php endif; ?>
            </div>
        </div>
    </div>

<?php
    endwhile;
else :
endif;
?>
