<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_ADMIN_CAPPERS_SIMPLE;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $cappers = get_field('cappers');
    $links = get_field('links');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <?php if (!empty($cappers) && count($cappers) > 0): ?>
            <div class="cappers">
                <?php foreach($cappers as $capper):?>
                    <div class="capper">
                        <div class="content">
                            <div class="capper-content">
                                <div class="content-category">
                                    <div class="category">
                                        <span><?php echo $capper['category']; ?></span>
                                    </div>
                                    <div class="date">
                                        <span><?php echo $capper['date']; ?></span>
                                    </div>
                                    <div class="handicap">
                                        <span><?php echo $capper['handicap']; ?></span>
                                    </div>
                                </div>
                                
                                <?php if (!empty($capper['show_logo']) && $capper['show_logo'] == 'show'): ?>
                                    <div class="content-teams-logo">
                                        <div class="teams">
                                            <div class="team team-a">
                                                <div class="team-logo">
                                                    <?php if (isset($capper['home_team_logo']['url']) && $capper['home_team_logo']['url'] != ''): ?>
                                                        <img src="<?php echo $capper['home_team_logo']['url']; ?>" alt="">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="team-name"><span><?php echo $capper['home_team']; ?></span></div>
                                            </div>

                                            <div class="team team-vs">
                                                <div class="vs-logo"><span>vs</span></div>
                                            </div>

                                            <div class="team team-b">
                                                <div class="team-logo">
                                                    <?php if (isset($capper['visitor_team_logo']['url']) && $capper['visitor_team_logo']['url'] != ''): ?>
                                                        <img src="<?php echo $capper['visitor_team_logo']['url']; ?>" alt="">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="team-name"><span><?php echo $capper['visitor_team']; ?></span></div>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="content-teams">
                                        <span class="team-home">
                                            <?php echo $capper['home_team']; ?>
                                        </span>
                                        <span class="team-vs">@</span>
                                        <span class="team-visitor">
                                            <?php echo $capper['visitor_team']; ?>
                                        </span>
                                    </div>
                                <?php endif; ?>

                                <div class="content-release">
                                    <hr>
                                    <span class="release-date">Release Date:
                                        <span><?php echo $capper['release_date']; ?></span>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="capper-footer">
                            <div class="footer-link">
                                <a href="<?php echo $capper['link']['url']; ?>"><?php echo $capper['link']['title']; ?></a>
                            </div>
                            <div class="footer-status">
                                <span><?php echo $capper['status']; ?></span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
