<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_PICKS_VS;
    $block_classes = [$block_name];
    $block_picks_vs = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $picks = get_field('picks');
    $titles = get_field('titles');
    $source = get_field('source');
    $category = get_field('category');
    $filter_category = (!empty(get_field('filter_category'))) ? get_field('filter_category') : 'hide';
    $filter_date = (!empty(get_field('filter_date'))) ? get_field('filter_date') : 'hide';
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : null;
    $since_date = (!empty(get_field('since_date'))) ? get_field('since_date') : null;
    $to_date = (!empty(get_field('to_date'))) ? get_field('to_date') : null;
    $date_ranges = (!empty(get_field('date_range'))) ? get_field('date_range') : [];
    $picks_titles = $block_picks_vs->get_picks_vs_titles(true);
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $date_request = $block_picks_vs->get_date_filter($date_type, $since_date, $to_date);

    if ($source == 'api' && $block_picks_vs->is_caching()) {
        $api_url = get_field('picks_vs_api_url', 'option');
        $api_token = get_field('picks_vs_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_picks_vs->get_api_attributes($items, ['category' => $category, 'date' => $date_request]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id, $block_custom_id);
            $response = $block_picks_vs->get_resources($api_attributes, $cache_file);

            if (empty($response->message)) {
                $picks = $response->json;
            } else {
                $picks = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }

    $styles_filter_style = $block_picks_vs->get_width('style', $filter_category, $filter_date);
    $styles_filter_class_category = $block_picks_vs->get_width('class_category', $filter_category, $filter_date);
    $styles_filter_class_sub_category = $block_picks_vs->get_width('class_sub_category', $filter_category, $filter_date);
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php if ($source == 'api'): ?>
                <?php if ($filter_category == 'show' || $filter_date == 'show'): ?>
                    <div class="filter" style="<?php echo $styles_filter_style; ?>">
                        <?php if ($filter_category == 'show'): ?>
                            <div class="categories <?php echo $styles_filter_class_category; ?>">
                                <?php 
                                    if (strpos($category, '-')) {
                                        list($category_primary, $sub_category) = explode('-', $category);
                                    } else {
                                        $category_primary = $category;
                                    }
                                ?>
                                <div class="select">
                                    <select>
                                        <?php if (strpos($category, '-')): ?>
                                            <optgroup label="<?php echo $category_primary; ?>">
                                        <?php endif; ?>

                                        <?php
                                            if (strpos($category, '-')) {
                                                foreach ($picks_titles[$category_primary]  as $key => $sub_titles) {
                                                    if ($key == $category) {
                                                        $select = $sub_titles;
                                                    }
                                                }
                                            } else {
                                                $select = $picks_titles[$category];
                                            }
                                        ?>

                                        <option value="<?php echo $category; ?>"><?php echo $select; ?></option>

                                        <?php if (strpos($category, '-')): ?>
                                            </optgroup>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($filter_date == 'show'): ?>
                            <div class="sub-categories <?php echo $styles_filter_class_sub_category; ?>">
                                <?php if (is_array($date_ranges) && count($date_ranges)): ?>
                                    <div class="buttons">
                                        <?php foreach($date_ranges as $date_range): ?>
                                            <?php
                                                $link_class = '';
                                                $link_style = '';
                                                if ($date_range['default_styles'] != 'custom') {
                                                    $link_class = 'class="'.$date_range['default_styles'].'"';
                                                } else {
                                                    $link_style = 'onMouseOut="this.style.backgroundColor=\''.$date_range['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$date_range['background_hover_color'].'\'" class="" style="'.$block_picks_vs->get_style('buttons', $date_range).'"';
                                                }

                                                $icon = (!empty($date_range['icon'])) ? '<i class="fal '.$date_range['icon'].'"></i>' : '';
                                            ?>
                                            <?php if (!empty($date_range['title_date'])): ?>
                                                <a href="#" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $date_range['title_date']; echo $icon;?></a>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (!empty($picks) && count($picks) > 0): ?>
                <div class="picks">
                    <?php if (!empty($picks)): ?>
                        <?php
                            if ($source == 'api') {
                                require 'partials/api.php';
                            } else {
                                require 'partials/manual.php';
                            }
                        ?>
                    <?php else: ?>
                        <?php if (!empty($message)): ?>
                            <span class="message"><?php echo $message; ?></span>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
