<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_LEADER_BOARD;
    $block_classes = [$block_name];
    $block_leader_board = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div class="table">
                <div class="table-menu">
                    <ul class="menu">
                        <li><a href="#">All</a></li>
                        <li><a href="#" class="unactive">Football</a></li>
                        <li><a href="#" class="unactive">Basketball</a></li>
                        <li><a href="#" class="unactive">Hokey</a></li>
                        <li><a href="#" class="unactive">Baseball</a></li>
                        <li><a href="#" class="unactive">Other Sports <i class="fal fa-chevron-down"></i></a></li>
                    </ul>
                </div>
                <div class="table-filter">
                    <ul class="filter">
                        <li>
                            <span class="init">Categories</span>
                            <select name="" id="">
                                <option>All</option>
                            </select>
                        </li>
                        <li>
                            <span>Bet Type</span>
                            <select name="" id="">
                                <option>All</option>
                            </select>
                        </li>
                        <li>
                            <span>Period</span>
                            <select name="" id="">
                                <option>All</option>
                            </select>
                        </li>
                        <li>
                            <span>Date Range</span>
                            <select name="" id="">
                                <option>All</option>
                            </select>
                        </li>
                        <li>
                            <span>Pick Range</span>
                            <select name="" id="">
                                <option>All</option>
                            </select>
                        </li>
                    </ul>
                </div>
                <div class="list">
                    <div class="list-header">
                        <span></span>
                        <span></span>
                        <span class="name">Total Bets <i class="fal fa-sort"></i></span>
                        <span>Win <i class="fal fa-sort"></i></span>
                        <span>Loss <i class="fal fa-sort"></i></span>
                        <span>Push <i class="fal fa-sort"></i></span>
                        <span>Win% <i class="fal fa-sort"></i></span>
                        <span>Win Amount <i class="fal fa-sort"></i></span>
                        <span>Risk Amount <i class="fal fa-sort"></i></span>
                        <span>Net <i class="fal fa-sort"></i></span>
                    </div>
                    <div class="list-items">
                        <div class="item">
                            <span>1</span>
                            <span class="name">Patoto</span>
                            <span>60</span>
                            <span>41</span>
                            <span>19</span>
                            <span>0</span>
                            <span>68.33%</span>
                            <span>$4,278</span>
                            <span>$14,278</span>
                            <span>$1,278</span>
                        </div>
                        <div class="item">
                            <span>2</span>
                            <span class="name">Woody</span>
                            <span>80</span>
                            <span>51</span>
                            <span>29</span>
                            <span>0</span>
                            <span>63.75%</span>
                            <span>$5,102</span>
                            <span>$15,102</span>
                            <span>$1,102</span>
                        </div>
                        <div class="item">
                            <span>3</span>
                            <span class="name">Aliens</span>
                            <span>75</span>
                            <span>45</span>
                            <span>30</span>
                            <span>0</span>
                            <span>60.00%</span>
                            <span>$4,550</span>
                            <span>$14,550</span>
                            <span>$1,550</span>
                        </div>
                        <div class="item">
                            <span>4</span>
                            <span class="name">Rex</span>
                            <span>120</span>
                            <span>71</span>
                            <span>49</span>
                            <span>0</span>
                            <span>59.71%</span>
                            <span>$4,278</span>
                            <span>$14,278</span>
                            <span>$1,278</span>
                        </div>
                        <div class="item">
                            <span>5</span>
                            <span class="name">Slinky</span>
                            <span>60</span>
                            <span>41</span>
                            <span>19</span>
                            <span>0</span>
                            <span>68.33%</span>
                            <span>$4,278</span>
                            <span>$14,278</span>
                            <span>$1,278</span>
                        </div>
                        <div class="item">
                            <span>6</span>
                            <span class="name">Walle</span>
                            <span>60</span>
                            <span>41</span>
                            <span>19</span>
                            <span>0</span>
                            <span>68.33%</span>
                            <span>$4,278</span>
                            <span>$14,278</span>
                            <span>$1,278</span>
                        </div>
                        <div class="item">
                            <span>7</span>
                            <span class="name">Wise</span>
                            <span>60</span>
                            <span>41</span>
                            <span>19</span>
                            <span>0</span>
                            <span>68.33%</span>
                            <span>$4,278</span>
                            <span>$14,278</span>
                            <span>$1,278</span>
                        </div>
                        <div class="item">
                            <span>8</span>
                            <span class="name">Hamn</span>
                            <span>60</span>
                            <span>41</span>
                            <span>19</span>
                            <span>0</span>
                            <span>68.33%</span>
                            <span>$4,278</span>
                            <span>$14,278</span>
                            <span>$1,278</span>
                        </div>
                        <div class="item">
                            <span>9</span>
                            <span class="name">Forky</span>
                            <span>60</span>
                            <span>41</span>
                            <span>19</span>
                            <span>0</span>
                            <span>68.33%</span>
                            <span>$4,278</span>
                            <span>$14,278</span>
                            <span>$1,278</span>
                        </div>
                        <div class="item">
                            <span>10</span>
                            <span class="name">Sid</span>
                            <span>60</span>
                            <span>41</span>
                            <span>19</span>
                            <span>0</span>
                            <span>68.33%</span>
                            <span>$4,278</span>
                            <span>$14,278</span>
                            <span>$1,278</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
